/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load;

import java.io.File;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.cmd.LoadPhotosWithPointsCmd;
import tim.prune.config.Config;
import tim.prune.data.Photo;
import tim.prune.load.FileToBeLoaded;
import tim.prune.load.GenericFileFilter;
import tim.prune.load.JpegLoader;
import tim.prune.load.NmeaFileLoader;
import tim.prune.load.TextFileLoader;
import tim.prune.load.json.JsonFileLoader;
import tim.prune.load.xml.GzipFileLoader;
import tim.prune.load.xml.XmlFileLoader;
import tim.prune.load.xml.ZipFileLoader;

public class FileLoader {
    private App _app;
    private JFileChooser _fileChooser = null;
    private TextFileLoader _textFileLoader = null;
    private NmeaFileLoader _nmeaFileLoader = null;
    private XmlFileLoader _xmlFileLoader = null;
    private ZipFileLoader _zipFileLoader = null;
    private GzipFileLoader _gzipFileLoader = null;

    public FileLoader(App app) {
        this._app = app;
        this._textFileLoader = new TextFileLoader(app);
        this._nmeaFileLoader = new NmeaFileLoader(app);
        this._xmlFileLoader = new XmlFileLoader(app);
        this._zipFileLoader = new ZipFileLoader(app, this._xmlFileLoader);
        this._gzipFileLoader = new GzipFileLoader(app, this._xmlFileLoader);
    }

    public void openFile() {
        Object object;
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            this._fileChooser.addChoosableFileFilter(new GenericFileFilter("filetype.txt", new String[]{"txt", "text"}));
            this._fileChooser.addChoosableFileFilter(new GenericFileFilter("filetype.gpx", new String[]{"gpx"}));
            this._fileChooser.addChoosableFileFilter(new GenericFileFilter("filetype.kml", new String[]{"kml"}));
            this._fileChooser.addChoosableFileFilter(new GenericFileFilter("filetype.kmz", new String[]{"kmz"}));
            this._fileChooser.setAcceptAllFileFilterUsed(true);
            this._fileChooser.setFileFilter(this._fileChooser.getAcceptAllFileFilter());
            object = Config.getConfigString("prune.trackdirectory");
            if (object == null) {
                object = Config.getConfigString("prune.photodirectory");
            }
            if (object != null) {
                this._fileChooser.setCurrentDirectory(new File((String)object));
            }
            this._fileChooser.setMultiSelectionEnabled(true);
        }
        if (this._fileChooser.showOpenDialog(this._app.getFrame()) == 0) {
            object = this._fileChooser.getSelectedFiles();
            ArrayList<File> arrayList = new ArrayList<File>();
            if (object != null) {
                File[] fileArray = object;
                int n = ((File[])object).length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.exists() && file.isFile() && file.canRead()) {
                        arrayList.add(file);
                    }
                    ++n2;
                }
            }
            if (arrayList.size() > 0) {
                this._app.loadDataFiles(arrayList);
            } else {
                this._app.showErrorMessage("error.load.dialogtitle", "error.load.noread");
            }
        }
    }

    public void openFile(File file, boolean bl) {
        File file2 = file.getParentFile();
        if (file2 != null) {
            Config.setConfigString("prune.trackdirectory", file2.getAbsolutePath());
        }
        FileToBeLoaded fileToBeLoaded = new FileToBeLoaded(file, () -> this._app.informDataLoadComplete());
        String string = file.getName().toLowerCase();
        if (string.length() > 4) {
            string = string.substring(string.length() - 4);
        }
        if (string.equals(".kml") || string.equals(".gpx") || string.equals(".xml")) {
            this._xmlFileLoader.openFile(fileToBeLoaded, bl);
        } else if (string.equals(".kmz") || string.equals(".zip")) {
            this._zipFileLoader.openFile(fileToBeLoaded, bl);
        } else if (string.endsWith(".gz") || string.equals("gzip")) {
            this._gzipFileLoader.openFile(fileToBeLoaded, bl);
        } else if (string.equals("nmea")) {
            this._nmeaFileLoader.openFile(fileToBeLoaded, bl);
        } else if (string.equals(".jpg") || string.equals("jpeg")) {
            Photo photo = JpegLoader.createPhoto(file);
            LoadPhotosWithPointsCmd loadPhotosWithPointsCmd = new LoadPhotosWithPointsCmd(photo);
            loadPhotosWithPointsCmd.setDescription(I18nManager.getText("undo.loadphoto", file.getName()));
            loadPhotosWithPointsCmd.setConfirmText(I18nManager.getText("confirm.jpegload.single"));
            this._app.execute(loadPhotosWithPointsCmd);
        } else if (string.equals("json")) {
            new JsonFileLoader(this._app).openFile(fileToBeLoaded, bl);
        } else {
            this._textFileLoader.openFile(fileToBeLoaded, bl);
        }
        fileToBeLoaded.release();
    }

    public char getLastUsedDelimiter() {
        return this._textFileLoader.getLastUsedDelimiter();
    }
}

