/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.cli.options;

import java.util.Locale;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.cli.CLIArgumentsList;
import org.netbeans.installer.utils.cli.CLIOptionOneArgument;
import org.netbeans.installer.utils.exceptions.CLIOptionException;

public class LocaleOption
extends CLIOptionOneArgument {
    private Locale targetLocale;
    public static final String LOCALE_ARG = "--locale";
    private static final String WARNING_BAD_LOCALE_ARG_PARAM_KEY = "O.warning.bad.locale.arg.param";
    private static final String WARNING_BAD_LOCALE_ARG_KEY = "O.warning.bad.locale.arg";

    @Override
    public void execute(CLIArgumentsList arguments) throws CLIOptionException {
        Locale.setDefault(this.targetLocale);
        LogManager.log("... locale set to: " + this.targetLocale);
    }

    private void initializeLocale(String value) {
        String[] valueParts = value.split("_");
        switch (valueParts.length) {
            case 1: {
                this.targetLocale = new Locale(valueParts[0]);
                break;
            }
            case 2: {
                this.targetLocale = new Locale(valueParts[0], valueParts[1]);
                break;
            }
            case 3: {
                this.targetLocale = new Locale(valueParts[0], valueParts[1], valueParts[2]);
                break;
            }
            default: {
                this.targetLocale = null;
            }
        }
    }

    @Override
    public void validateOptions(CLIArgumentsList arguments) throws CLIOptionException {
        super.validateOptions(arguments);
        String value = arguments.next();
        this.initializeLocale(value);
        if (this.targetLocale == null) {
            LogManager.log("... locale is not set properly, using system default: " + Locale.getDefault());
            throw new CLIOptionException(ResourceUtils.getString(LocaleOption.class, WARNING_BAD_LOCALE_ARG_PARAM_KEY, LOCALE_ARG, value));
        }
    }

    @Override
    protected String getLackOfArgumentsMessage() {
        return ResourceUtils.getString(LocaleOption.class, WARNING_BAD_LOCALE_ARG_KEY, LOCALE_ARG);
    }

    @Override
    public String getName() {
        return LOCALE_ARG;
    }
}

