/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.erc.wellcheck;

import com.sun.electric.database.topology.RTNode;
import com.sun.electric.tool.erc.ERCWellCheck;
import com.sun.electric.tool.erc.wellcheck.Utils;
import com.sun.electric.tool.erc.wellcheck.WellCheckAnalysisStrategy;
import com.sun.electric.tool.erc.wellcheck.WellCon;
import com.sun.electric.util.ElapseTimer;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DistanceCheck
implements WellCheckAnalysisStrategy {
    private ERCWellCheck.StrategyParameter parameter;
    private double worstPWellDist;
    private Point2D worstPWellCon;
    private Point2D worstPWellEdge;
    private double worstNWellDist;
    private Point2D worstNWellCon;
    private Point2D worstNWellEdge;
    private RTNode<ERCWellCheck.WellBound> pWellRoot;
    private RTNode<ERCWellCheck.WellBound> nWellRoot;

    public DistanceCheck(ERCWellCheck.StrategyParameter parameter, double worstPWellDist, Point2D worstPWellCon, Point2D worstPWellEdge, double worstNWellDist, Point2D worstNWellCon, Point2D worstNWellEdge, RTNode<ERCWellCheck.WellBound> pWellRoot, RTNode<ERCWellCheck.WellBound> nWellRoot) {
        this.parameter = parameter;
        this.worstPWellDist = worstPWellDist;
        this.worstPWellCon = worstPWellCon;
        this.worstPWellEdge = worstPWellEdge;
        this.worstNWellDist = worstNWellDist;
        this.worstNWellCon = worstNWellCon;
        this.worstNWellEdge = worstNWellEdge;
        this.pWellRoot = pWellRoot;
        this.nWellRoot = nWellRoot;
    }

    @Override
    public void execute() {
        if (this.parameter.getWellPrefs().findWorstCaseWell) {
            ElapseTimer timer = ElapseTimer.createInstance().start();
            this.worstPWellDist = 0.0;
            this.worstPWellCon = null;
            this.worstPWellEdge = null;
            this.worstNWellDist = 0.0;
            this.worstNWellCon = null;
            this.worstNWellEdge = null;
            HashMap<Integer, ERCWellCheck.WellNet> wellNets = new HashMap<Integer, ERCWellCheck.WellNet>();
            for (WellCon wc : this.parameter.getWellCons()) {
                if (wc.getWellNum() == null) continue;
                Integer netNUM = new Integer(wc.getWellNum().getIndex());
                ERCWellCheck.WellNet wn = (ERCWellCheck.WellNet)wellNets.get(netNUM);
                if (wn == null) {
                    wn = new ERCWellCheck.WellNet(new ArrayList<Point2D>(), new ArrayList<WellCon>(), wc.getFun());
                    wellNets.put(netNUM, wn);
                }
                wn.getContactsOnNet().add(wc);
            }
            this.findWellNetPoints(this.pWellRoot, wellNets);
            this.findWellNetPoints(this.nWellRoot, wellNets);
            for (Integer netNUM : wellNets.keySet()) {
                ERCWellCheck.WellNet wn = (ERCWellCheck.WellNet)wellNets.get(netNUM);
                for (Point2D pt : wn.getPointsOnNet()) {
                    double closestDist = Double.MAX_VALUE;
                    Point2D closestCon = null;
                    for (WellCon wc : wn.getContactsOnNet()) {
                        double dist = wc.getCenter().distance(pt);
                        if (!(dist < closestDist)) continue;
                        closestDist = dist;
                        closestCon = wc.getCenter();
                    }
                    if (Utils.canBeSubstrateTap(wn.getFun())) {
                        if (!(closestDist > this.worstPWellDist)) continue;
                        this.worstPWellDist = closestDist;
                        this.worstPWellCon = closestCon;
                        this.worstPWellEdge = pt;
                        continue;
                    }
                    if (!(closestDist > this.worstNWellDist)) continue;
                    this.worstNWellDist = closestDist;
                    this.worstNWellCon = closestCon;
                    this.worstNWellEdge = pt;
                }
            }
            timer.end();
            System.out.println("   Worst-case distance analysis took " + timer);
        }
    }

    private void findWellNetPoints(RTNode<ERCWellCheck.WellBound> rtree, Map<Integer, ERCWellCheck.WellNet> wellNets) {
        for (int j = 0; j < rtree.getTotal(); ++j) {
            Object child;
            if (rtree.getFlag()) {
                Integer netNUM;
                ERCWellCheck.WellNet wn;
                child = rtree.getChildLeaf(j);
                if (((ERCWellCheck.WellBound)child).getNetID() == null || (wn = wellNets.get(netNUM = new Integer(((ERCWellCheck.WellBound)child).getNetID().getIndex()))) == null) continue;
                wn.getPointsOnNet().add(new Point2D.Double(((ERCWellCheck.WellBound)child).getBounds().getMinX(), ((ERCWellCheck.WellBound)child).getBounds().getMinY()));
                wn.getPointsOnNet().add(new Point2D.Double(((ERCWellCheck.WellBound)child).getBounds().getMaxX(), ((ERCWellCheck.WellBound)child).getBounds().getMinY()));
                wn.getPointsOnNet().add(new Point2D.Double(((ERCWellCheck.WellBound)child).getBounds().getMaxX(), ((ERCWellCheck.WellBound)child).getBounds().getMaxY()));
                wn.getPointsOnNet().add(new Point2D.Double(((ERCWellCheck.WellBound)child).getBounds().getMinX(), ((ERCWellCheck.WellBound)child).getBounds().getMaxY()));
                continue;
            }
            child = rtree.getChildTree(j);
            this.findWellNetPoints((RTNode<ERCWellCheck.WellBound>)child, wellNets);
        }
    }
}

