/* jgiGene.c was originally generated by the autoSql program, which also 
 * generated jgiGene.h and jgiGene.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "jgiGene.h"


void jgiGeneStaticLoad(char **row, struct jgiGene *ret)
/* Load a row from jgiGene table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->jgiGeneId = row[6];
ret->jgiSymbol = row[7];
ret->jgiGc = sqlFloat(row[8]);
ret->jgiDescription = row[9];
}

struct jgiGene *jgiGeneLoad(char **row)
/* Load a jgiGene from row fetched with select * from jgiGene
 * from database.  Dispose of this with jgiGeneFree(). */
{
struct jgiGene *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->jgiGeneId = cloneString(row[6]);
ret->jgiSymbol = cloneString(row[7]);
ret->jgiGc = sqlFloat(row[8]);
ret->jgiDescription = cloneString(row[9]);
return ret;
}

struct jgiGene *jgiGeneLoadAll(char *fileName) 
/* Load all jgiGene from a whitespace-separated file.
 * Dispose of this with jgiGeneFreeList(). */
{
struct jgiGene *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileRow(lf, row))
    {
    el = jgiGeneLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct jgiGene *jgiGeneLoadAllByChar(char *fileName, char chopper) 
/* Load all jgiGene from a chopper separated file.
 * Dispose of this with jgiGeneFreeList(). */
{
struct jgiGene *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = jgiGeneLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct jgiGene *jgiGeneCommaIn(char **pS, struct jgiGene *ret)
/* Create a jgiGene out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new jgiGene */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->jgiGeneId = sqlStringComma(&s);
ret->jgiSymbol = sqlStringComma(&s);
ret->jgiGc = sqlFloatComma(&s);
ret->jgiDescription = sqlStringComma(&s);
*pS = s;
return ret;
}

void jgiGeneFree(struct jgiGene **pEl)
/* Free a single dynamically allocated jgiGene such as created
 * with jgiGeneLoad(). */
{
struct jgiGene *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->jgiGeneId);
freeMem(el->jgiSymbol);
freeMem(el->jgiDescription);
freez(pEl);
}

void jgiGeneFreeList(struct jgiGene **pList)
/* Free a list of dynamically allocated jgiGene's */
{
struct jgiGene *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    jgiGeneFree(&el);
    }
*pList = NULL;
}

void jgiGeneOutput(struct jgiGene *el, FILE *f, char sep, char lastSep) 
/* Print out jgiGene.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->jgiGeneId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->jgiSymbol);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->jgiGc);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->jgiDescription);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

