/* wabaCrude.c was originally generated by the autoSql program, which also 
 * generated wabaCrude.h and wabaCrude.sql.  This module links the database and the RAM 
 * representation of objects. */

#include "common.h"
#include "wabaCrude.h"

#define sqlUnsigned atoi
#define sqlSigned atoi

void wabaCrudeStaticLoad(char **row, struct wabaCrude *ret)
/* Load a row from wabaCrude table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{
int sizeOne,i;
char *s;

ret->score = sqlUnsigned(row[0]);
ret->qFile = row[1];
ret->qSeq = row[2];
ret->qStart = sqlUnsigned(row[3]);
ret->qEnd = sqlUnsigned(row[4]);
ret->strand = sqlSigned(row[5]);
ret->tFile = row[6];
ret->tSeq = row[7];
ret->tStart = sqlUnsigned(row[8]);
ret->tEnd = sqlUnsigned(row[9]);
}

struct wabaCrude *wabaCrudeLoad(char **row)
/* Load a wabaCrude from row fetched with select * from wabaCrude
 * from database.  Dispose of this with wabaCrudeFree(). */
{
struct wabaCrude *ret;
int sizeOne,i;
char *s;

AllocVar(ret);
ret->score = sqlUnsigned(row[0]);
ret->qFile = cloneString(row[1]);
ret->qSeq = cloneString(row[2]);
ret->qStart = sqlUnsigned(row[3]);
ret->qEnd = sqlUnsigned(row[4]);
ret->strand = sqlSigned(row[5]);
ret->tFile = cloneString(row[6]);
ret->tSeq = cloneString(row[7]);
ret->tStart = sqlUnsigned(row[8]);
ret->tEnd = sqlUnsigned(row[9]);
return ret;
}

void wabaCrudeFree(struct wabaCrude **pEl)
/* Free a single dynamically allocated wabaCrude such as created
 * with wabaCrudeLoad(). */
{
struct wabaCrude *el;

if ((el = *pEl) == NULL) return;
freeMem(el->qFile);
freeMem(el->qSeq);
freeMem(el->tFile);
freeMem(el->tSeq);
freez(pEl);
}

void wabaCrudeFreeList(struct wabaCrude **pList)
/* Free a list of dynamically allocated wabaCrude's */
{
struct wabaCrude *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    wabaCrudeFree(&el);
    }
*pList = NULL;
}

void wabaCrudeOutput(struct wabaCrude *el, FILE *f, char sep, char lastSep) 
/* Print out wabaCrude.  Separate fields with sep. Follow last field with lastSep. */
{
int i;
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->qFile);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->qSeq);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->qStart);
fputc(sep,f);
fprintf(f, "%u", el->qEnd);
fputc(sep,f);
fprintf(f, "%d", el->strand);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tFile);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tSeq);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->tStart);
fputc(sep,f);
fprintf(f, "%u", el->tEnd);
fputc(lastSep,f);
}

