/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jvm.internal;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.java.TargetJvmVersion;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.compile.HasCompileOptions;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.jvm.internal.DefaultJvmLanguageSourceDirectoryBuilder;
import org.gradle.api.plugins.jvm.internal.JvmLanguageSourceDirectoryBuilder;
import org.gradle.api.plugins.jvm.internal.JvmLanguageUtilities;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.internal.Cast;
import org.gradle.internal.instantiation.InstanceGenerator;

public class DefaultJvmLanguageUtilities
implements JvmLanguageUtilities {
    private final ProviderFactory providerFactory;
    private final ProjectInternal project;
    private final InstanceGenerator instanceGenerator;
    private final Map<ConfigurationInternal, Set<TaskProvider<?>>> configurationToCompileTasks;

    @Inject
    public DefaultJvmLanguageUtilities(ProviderFactory providerFactory, InstanceGenerator instanceGenerator, ProjectInternal project) {
        this.providerFactory = providerFactory;
        this.instanceGenerator = instanceGenerator;
        this.project = project;
        this.configurationToCompileTasks = new HashMap(5);
    }

    public <COMPILE extends AbstractCompile> void useDefaultTargetPlatformInference(Configuration configuration, TaskProvider<COMPILE> compileTask) {
        ConfigurationInternal configurationInternal = (ConfigurationInternal)configuration;
        Set compileTasks = (Set)Cast.uncheckedCast((Object)this.configurationToCompileTasks.computeIfAbsent(configurationInternal, key -> new HashSet()));
        compileTasks.add(compileTask);
        JavaPluginExtension java = (JavaPluginExtension)this.project.getExtensions().getByType(JavaPluginExtension.class);
        configurationInternal.getAttributes().attributeProvider(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE, this.providerFactory.provider(() -> DefaultJvmLanguageUtilities.getDefaultTargetPlatform(configuration, java, compileTasks)));
    }

    public void registerJvmLanguageSourceDirectory(SourceSet sourceSet, String name, Action<? super JvmLanguageSourceDirectoryBuilder> configuration) {
        DefaultJvmLanguageSourceDirectoryBuilder builder = (DefaultJvmLanguageSourceDirectoryBuilder)this.instanceGenerator.newInstance(DefaultJvmLanguageSourceDirectoryBuilder.class, new Object[]{name, this.project, sourceSet});
        configuration.execute((Object)builder);
        builder.build();
    }

    private static <COMPILE extends AbstractCompile> int getDefaultTargetPlatform(Configuration configuration, JavaPluginExtension java, Set<TaskProvider<COMPILE>> compileTasks) {
        assert (!compileTasks.isEmpty());
        if (!configuration.isCanBeConsumed() && java.getAutoTargetJvmDisabled()) {
            return Integer.MAX_VALUE;
        }
        return compileTasks.stream().map(provider -> {
            AbstractCompile compileTask = (AbstractCompile)provider.get();
            if (((HasCompileOptions)compileTask).getOptions().getRelease().isPresent()) {
                return (Integer)((HasCompileOptions)compileTask).getOptions().getRelease().get();
            }
            List compilerArgs = ((HasCompileOptions)compileTask).getOptions().getCompilerArgs();
            int flagIndex = compilerArgs.indexOf("--release");
            if (flagIndex != -1 && flagIndex + 1 < compilerArgs.size()) {
                return Integer.parseInt(String.valueOf(compilerArgs.get(flagIndex + 1)));
            }
            return Integer.parseInt(JavaVersion.toVersion((Object)compileTask.getTargetCompatibility()).getMajorVersion());
        }).max(Comparator.naturalOrder()).get();
    }
}

