/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.ResolveExceptionContextualizer;
import org.gradle.api.internal.artifacts.component.ComponentIdentifierFactory;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DefaultConsumableConfiguration;
import org.gradle.api.internal.artifacts.configurations.DefaultDependencyScopeConfiguration;
import org.gradle.api.internal.artifacts.configurations.DefaultResolvableConfiguration;
import org.gradle.api.internal.artifacts.configurations.DefaultUnlockedConfiguration;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.dsl.CapabilityNotationParserFactory;
import org.gradle.api.internal.artifacts.dsl.PublishArtifactNotationParserFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingProvider;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentMetadataBuilder;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.internal.Factory;
import org.gradle.internal.code.UserCodeApplicationContext;
import org.gradle.internal.event.AnonymousListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.work.WorkerThreadRegistry;

@ThreadSafe
public class DefaultConfigurationFactory {
    private final Instantiator instantiator;
    private final ConfigurationResolver resolver;
    private final ListenerManager listenerManager;
    private final DependencyMetaDataProvider metaDataProvider;
    private final ComponentIdentifierFactory componentIdentifierFactory;
    private final DependencyLockingProvider dependencyLockingProvider;
    private final DomainObjectContext domainObjectContext;
    private final FileCollectionFactory fileCollectionFactory;
    private final BuildOperationExecutor buildOperationExecutor;
    private final NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser;
    private final NotationParser<Object, Capability> capabilityNotationParser;
    private final ImmutableAttributesFactory attributesFactory;
    private final ResolveExceptionContextualizer exceptionContextualizer;
    private final UserCodeApplicationContext userCodeApplicationContext;
    private final ProjectStateRegistry projectStateRegistry;
    private final WorkerThreadRegistry workerThreadRegistry;
    private final DomainObjectCollectionFactory domainObjectCollectionFactory;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final TaskDependencyFactory taskDependencyFactory;

    @Inject
    public DefaultConfigurationFactory(Instantiator instantiator, ConfigurationResolver resolver, ListenerManager listenerManager, DependencyMetaDataProvider metaDataProvider, ComponentIdentifierFactory componentIdentifierFactory, DependencyLockingProvider dependencyLockingProvider, DomainObjectContext domainObjectContext, FileCollectionFactory fileCollectionFactory, BuildOperationExecutor buildOperationExecutor, PublishArtifactNotationParserFactory artifactNotationParserFactory, ImmutableAttributesFactory attributesFactory, ResolveExceptionContextualizer exceptionContextualizer, UserCodeApplicationContext userCodeApplicationContext, ProjectStateRegistry projectStateRegistry, WorkerThreadRegistry workerThreadRegistry, DomainObjectCollectionFactory domainObjectCollectionFactory, CalculatedValueContainerFactory calculatedValueContainerFactory, TaskDependencyFactory taskDependencyFactory) {
        this.instantiator = instantiator;
        this.resolver = resolver;
        this.listenerManager = listenerManager;
        this.metaDataProvider = metaDataProvider;
        this.componentIdentifierFactory = componentIdentifierFactory;
        this.dependencyLockingProvider = dependencyLockingProvider;
        this.domainObjectContext = domainObjectContext;
        this.fileCollectionFactory = fileCollectionFactory;
        this.buildOperationExecutor = buildOperationExecutor;
        this.artifactNotationParser = artifactNotationParserFactory.create();
        this.capabilityNotationParser = new CapabilityNotationParserFactory(true).create();
        this.attributesFactory = attributesFactory;
        this.exceptionContextualizer = exceptionContextualizer;
        this.userCodeApplicationContext = userCodeApplicationContext;
        this.projectStateRegistry = projectStateRegistry;
        this.workerThreadRegistry = workerThreadRegistry;
        this.domainObjectCollectionFactory = domainObjectCollectionFactory;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.taskDependencyFactory = taskDependencyFactory;
    }

    DefaultUnlockedConfiguration create(String name, ConfigurationsProvider configurationsProvider, Factory<ResolutionStrategyInternal> resolutionStrategyFactory, RootComponentMetadataBuilder rootComponentMetadataBuilder, ConfigurationRole role) {
        AnonymousListenerBroadcast dependencyResolutionListeners = this.listenerManager.createAnonymousBroadcaster(DependencyResolutionListener.class);
        DefaultUnlockedConfiguration instance = (DefaultUnlockedConfiguration)this.instantiator.newInstance(DefaultUnlockedConfiguration.class, new Object[]{this.domainObjectContext, name, configurationsProvider, this.resolver, dependencyResolutionListeners, this.metaDataProvider, this.componentIdentifierFactory, this.dependencyLockingProvider, resolutionStrategyFactory, this.fileCollectionFactory, this.buildOperationExecutor, this.instantiator, this.artifactNotationParser, this.capabilityNotationParser, this.attributesFactory, rootComponentMetadataBuilder, this.exceptionContextualizer, this.userCodeApplicationContext, this.projectStateRegistry, this.workerThreadRegistry, this.domainObjectCollectionFactory, this.calculatedValueContainerFactory, this, this.taskDependencyFactory, role});
        instance.addMutationValidator(rootComponentMetadataBuilder.getValidator());
        return instance;
    }

    DefaultResolvableConfiguration createResolvable(String name, ConfigurationsProvider configurationsProvider, Factory<ResolutionStrategyInternal> resolutionStrategyFactory, RootComponentMetadataBuilder rootComponentMetadataBuilder) {
        AnonymousListenerBroadcast dependencyResolutionListeners = this.listenerManager.createAnonymousBroadcaster(DependencyResolutionListener.class);
        DefaultResolvableConfiguration instance = (DefaultResolvableConfiguration)this.instantiator.newInstance(DefaultResolvableConfiguration.class, new Object[]{this.domainObjectContext, name, configurationsProvider, this.resolver, dependencyResolutionListeners, this.metaDataProvider, this.componentIdentifierFactory, this.dependencyLockingProvider, resolutionStrategyFactory, this.fileCollectionFactory, this.buildOperationExecutor, this.instantiator, this.artifactNotationParser, this.capabilityNotationParser, this.attributesFactory, rootComponentMetadataBuilder, this.exceptionContextualizer, this.userCodeApplicationContext, this.projectStateRegistry, this.workerThreadRegistry, this.domainObjectCollectionFactory, this.calculatedValueContainerFactory, this, this.taskDependencyFactory});
        instance.addMutationValidator(rootComponentMetadataBuilder.getValidator());
        return instance;
    }

    DefaultConsumableConfiguration createConsumable(String name, ConfigurationsProvider configurationsProvider, Factory<ResolutionStrategyInternal> resolutionStrategyFactory, RootComponentMetadataBuilder rootComponentMetadataBuilder) {
        AnonymousListenerBroadcast dependencyResolutionListeners = this.listenerManager.createAnonymousBroadcaster(DependencyResolutionListener.class);
        DefaultConsumableConfiguration instance = (DefaultConsumableConfiguration)this.instantiator.newInstance(DefaultConsumableConfiguration.class, new Object[]{this.domainObjectContext, name, configurationsProvider, this.resolver, dependencyResolutionListeners, this.metaDataProvider, this.componentIdentifierFactory, this.dependencyLockingProvider, resolutionStrategyFactory, this.fileCollectionFactory, this.buildOperationExecutor, this.instantiator, this.artifactNotationParser, this.capabilityNotationParser, this.attributesFactory, rootComponentMetadataBuilder, this.exceptionContextualizer, this.userCodeApplicationContext, this.projectStateRegistry, this.workerThreadRegistry, this.domainObjectCollectionFactory, this.calculatedValueContainerFactory, this, this.taskDependencyFactory});
        instance.addMutationValidator(rootComponentMetadataBuilder.getValidator());
        return instance;
    }

    DefaultDependencyScopeConfiguration createDependencyScope(String name, ConfigurationsProvider configurationsProvider, Factory<ResolutionStrategyInternal> resolutionStrategyFactory, RootComponentMetadataBuilder rootComponentMetadataBuilder) {
        AnonymousListenerBroadcast dependencyResolutionListeners = this.listenerManager.createAnonymousBroadcaster(DependencyResolutionListener.class);
        DefaultDependencyScopeConfiguration instance = (DefaultDependencyScopeConfiguration)this.instantiator.newInstance(DefaultDependencyScopeConfiguration.class, new Object[]{this.domainObjectContext, name, configurationsProvider, this.resolver, dependencyResolutionListeners, this.metaDataProvider, this.componentIdentifierFactory, this.dependencyLockingProvider, resolutionStrategyFactory, this.fileCollectionFactory, this.buildOperationExecutor, this.instantiator, this.artifactNotationParser, this.capabilityNotationParser, this.attributesFactory, rootComponentMetadataBuilder, this.exceptionContextualizer, this.userCodeApplicationContext, this.projectStateRegistry, this.workerThreadRegistry, this.domainObjectCollectionFactory, this.calculatedValueContainerFactory, this, this.taskDependencyFactory});
        instance.addMutationValidator(rootComponentMetadataBuilder.getValidator());
        return instance;
    }
}

