/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.Main;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.TextAttributesPanel;
import com.sun.electric.tool.user.dialogs.TextInfoPanel;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

public class Attributes
extends EDialog
implements HighlightListener,
DatabaseChangeListener {
    private static Attributes theDialog = null;
    private DefaultListModel listModel;
    private JList list;
    private ElectricObject selectedObject;
    private Cell selectedCell;
    private NodeInst selectedNode;
    private ArcInst selectedArc;
    private Export selectedExport;
    private PortInst selectedPort;
    private JRadioButton currentButton;
    private String initialName;
    private String initialValue;
    private TextAttributesPanel attrPanel;
    private TextInfoPanel textPanel;
    private VariableCellRenderer cellRenderer;
    private EditWindow wnd;
    private JPanel body;
    private JLabel cellName;
    private ButtonGroup corner;
    private JRadioButton currentArc;
    private JRadioButton currentCell;
    private JRadioButton currentExport;
    private JRadioButton currentNode;
    private JRadioButton currentPort;
    private JButton deleteButton;
    private JLabel evalLabel;
    private JLabel evaluation;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JScrollPane listPane;
    private JTextField name;
    private JButton newButton;
    private JButton ok;
    private JButton renameButton;
    private ButtonGroup size;
    private JButton updateButton;
    private JTextField value;
    private ButtonGroup which;

    public static void showDialog() {
        if (theDialog == null) {
            if (TopLevel.isMDIMode()) {
                TopLevel jf = TopLevel.getCurrentJFrame();
                theDialog = new Attributes((Frame)jf, false);
            } else {
                theDialog = new Attributes(null, false);
            }
        }
        theDialog.loadAttributesInfo();
        if (!theDialog.isVisible()) {
            theDialog.pack();
        }
        theDialog.setVisible(true);
    }

    public void highlightChanged(Highlighter which) {
        if (!this.isVisible()) {
            return;
        }
        this.loadAttributesInfo();
    }

    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
        if (!this.isVisible()) {
            return;
        }
        this.loadAttributesInfo();
    }

    public void databaseEndChangeBatch(Undo.ChangeBatch batch) {
        if (!this.isVisible()) {
            return;
        }
        boolean reload = false;
        Iterator it = batch.getChanges();
        while (it.hasNext()) {
            Undo.Change change = (Undo.Change)it.next();
            ElectricObject obj = change.getObject();
            if (obj != this.selectedObject) continue;
            reload = true;
            break;
        }
        if (reload) {
            this.loadAttributesInfo();
        }
    }

    public void databaseChanged(Undo.Change change) {
    }

    public boolean isGUIListener() {
        return true;
    }

    private Attributes(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocation(100, 50);
        this.wnd = null;
        Undo.addDatabaseChangeListener(this);
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.cellRenderer = new VariableCellRenderer(!Main.getDebug());
        this.list.setCellRenderer(this.cellRenderer);
        this.listPane.setViewportView(this.list);
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Attributes.this.listClick();
            }
        });
        this.currentCell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Attributes.this.objectSelectorActionPerformed(evt);
            }
        });
        this.currentNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Attributes.this.objectSelectorActionPerformed(evt);
            }
        });
        this.currentArc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Attributes.this.objectSelectorActionPerformed(evt);
            }
        });
        this.currentExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Attributes.this.objectSelectorActionPerformed(evt);
            }
        });
        this.currentPort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Attributes.this.objectSelectorActionPerformed(evt);
            }
        });
        this.currentPort.setEnabled(false);
        this.attrPanel = new TextAttributesPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.attrPanel, gridBagConstraints);
        this.textPanel = new TextInfoPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.textPanel, gridBagConstraints);
        this.pack();
        this.loadAttributesInfo();
        this.finishInitialization();
    }

    protected void escapePressed() {
        this.ok(null);
    }

    public void setShowAttrOnly(boolean b) {
        this.cellRenderer.setShowAttrOnly(b);
    }

    private void objectSelectorActionPerformed(ActionEvent evt) {
        this.currentButton = (JRadioButton)evt.getSource();
        if (this.currentButton == this.currentCell) {
            this.selectedObject = this.selectedCell;
        } else if (this.currentButton == this.currentNode) {
            this.selectedObject = this.selectedNode;
        } else if (this.currentButton == this.currentArc) {
            this.selectedObject = this.selectedArc;
        } else if (this.currentButton == this.currentExport) {
            this.selectedObject = this.selectedExport;
        } else if (this.currentButton == this.currentPort) {
            this.selectedObject = this.selectedPort;
        }
        this.updateList();
        this.checkName();
    }

    private void listClick() {
        this.showSelectedAttribute(null);
    }

    private void loadAttributesInfo() {
        this.selectedObject = null;
        this.selectedCell = null;
        this.selectedNode = null;
        this.selectedArc = null;
        this.selectedExport = null;
        this.selectedPort = null;
        Variable selectedVar = null;
        this.currentButton = this.currentCell;
        EditWindow curWnd = EditWindow.getCurrent();
        if (this.wnd != curWnd && curWnd != null) {
            if (this.wnd != null) {
                this.wnd.getHighlighter().removeHighlightListener(this);
            }
            curWnd.getHighlighter().addHighlightListener(this);
            this.wnd = curWnd;
        }
        this.selectedCell = WindowFrame.needCurCell();
        this.selectedObject = this.selectedCell;
        if (curWnd == null) {
            this.selectedCell = null;
        }
        if (this.selectedCell != null && this.wnd.getHighlighter().getNumHighlights() == 1) {
            Highlight high = (Highlight)this.wnd.getHighlighter().getHighlights().iterator().next();
            ElectricObject eobj = high.getElectricObject();
            selectedVar = high.getVar();
            if (high.getType() == Highlight.Type.EOBJ) {
                if (eobj instanceof ArcInst) {
                    this.selectedArc = (ArcInst)eobj;
                    this.selectedObject = this.selectedArc;
                    this.currentButton = this.currentArc;
                } else if (eobj instanceof NodeInst) {
                    this.selectedNode = (NodeInst)eobj;
                    this.selectedObject = this.selectedNode;
                    this.currentButton = this.currentNode;
                } else if (eobj instanceof PortInst) {
                    PortInst pi = (PortInst)eobj;
                    this.selectedNode = pi.getNodeInst();
                    this.selectedObject = this.selectedNode;
                    this.currentButton = this.currentNode;
                    this.selectedPort = pi;
                }
            } else if (high.getType() == Highlight.Type.TEXT) {
                if (selectedVar != null) {
                    if (eobj instanceof NodeInst) {
                        this.selectedNode = (NodeInst)eobj;
                        this.selectedObject = this.selectedNode;
                        this.currentButton = this.currentNode;
                    } else if (eobj instanceof ArcInst) {
                        this.selectedArc = (ArcInst)eobj;
                        this.selectedObject = this.selectedArc;
                        this.currentButton = this.currentArc;
                    } else if (eobj instanceof PortInst) {
                        this.selectedPort = (PortInst)eobj;
                        this.selectedObject = this.selectedPort;
                        this.currentButton = this.currentPort;
                        this.selectedNode = this.selectedPort.getNodeInst();
                    } else if (eobj instanceof Export) {
                        this.selectedExport = (Export)eobj;
                        this.selectedObject = this.selectedExport;
                        this.currentButton = this.currentExport;
                    }
                } else if (high.getName() != null) {
                    if (eobj instanceof NodeInst) {
                        this.selectedNode = (NodeInst)eobj;
                        this.selectedObject = this.selectedNode;
                        this.currentButton = this.currentNode;
                    } else if (eobj instanceof ArcInst) {
                        this.selectedArc = (ArcInst)eobj;
                        this.selectedObject = this.selectedArc;
                        this.currentButton = this.currentArc;
                    }
                } else if (eobj instanceof Export) {
                    this.selectedExport = (Export)eobj;
                    this.selectedObject = this.selectedExport;
                    this.currentButton = this.currentExport;
                }
            }
        }
        if (this.selectedCell == null) {
            this.currentCell.setEnabled(false);
            this.cellName.setText("NO CURRENT CELL");
            this.currentNode.setEnabled(false);
            this.currentArc.setEnabled(false);
            this.currentExport.setEnabled(false);
            this.currentPort.setEnabled(false);
            this.list.clearSelection();
            this.listModel.clear();
            this.name.setText("");
            this.name.setEditable(false);
            this.value.setText("");
            this.value.setEditable(false);
            this.evaluation.setText("");
            this.deleteButton.setEnabled(false);
            this.newButton.setEnabled(false);
            this.updateButton.setEnabled(false);
            this.renameButton.setEnabled(false);
            this.textPanel.setTextDescriptor(null, null, null);
            this.attrPanel.setVariable(null, null, null, null);
            return;
        }
        this.currentCell.setEnabled(true);
        this.currentNode.setEnabled(this.selectedNode != null);
        this.currentArc.setEnabled(this.selectedArc != null);
        this.currentExport.setEnabled(this.selectedExport != null);
        this.currentPort.setEnabled(this.selectedPort != null);
        this.currentButton.setSelected(true);
        this.cellName.setText(this.selectedCell.describe());
        this.name.setEditable(true);
        this.value.setEditable(true);
        this.updateList();
        if (selectedVar != null) {
            this.showSelectedAttribute(selectedVar);
        } else {
            this.checkName();
        }
    }

    private void checkName() {
        Variable var;
        String varName = this.name.getText().trim();
        if (varName.equals("")) {
            this.updateButton.setEnabled(false);
            this.newButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.renameButton.setEnabled(false);
            this.textPanel.setTextDescriptor(null, null, null);
            this.attrPanel.setVariable(null, null, null, null);
            return;
        }
        if (this.cellRenderer.getShowAttrOnly()) {
            varName = "ATTR_" + varName;
        }
        if ((var = this.selectedObject.getVar(varName)) != null) {
            this.showSelectedAttribute(var);
        } else {
            this.newButton.setEnabled(true);
            this.updateButton.setEnabled(false);
            this.renameButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.list.clearSelection();
            this.textPanel.setTextDescriptor(null, varName, this.selectedObject);
            this.attrPanel.setVariable(null, null, varName, this.selectedObject);
        }
    }

    private void updateList() {
        Variable var;
        this.list.clearSelection();
        this.listModel.clear();
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Iterator it = this.selectedObject.getVariables();
        while (it.hasNext()) {
            var = (Variable)it.next();
            if (this.cellRenderer.getShowAttrOnly() && !var.isAttribute()) continue;
            variables.add(var);
        }
        Collections.sort(variables, new TextUtils.VariablesByName());
        it = variables.iterator();
        while (it.hasNext()) {
            var = (Variable)it.next();
            String varName = var.getKey().getName();
            if (this.cellRenderer.getShowAttrOnly()) {
                if (!varName.startsWith("ATTR_")) continue;
                this.listModel.addElement(var);
                continue;
            }
            this.listModel.addElement(var);
        }
    }

    Variable getSelectedVariable() {
        int i = this.list.getSelectedIndex();
        if (i < 0) {
            return null;
        }
        return (Variable)this.list.getSelectedValue();
    }

    private Object getVariableObject(String text) {
        if (TextUtils.isANumber(text)) {
            double d;
            int i = TextUtils.atoi(text);
            if ((double)i == (d = TextUtils.atof(text))) {
                return new Integer(i);
            }
            return new Double(d);
        }
        return text;
    }

    void showSelectedAttribute(Variable selectThis) {
        Variable var;
        if (selectThis != null) {
            this.list.setSelectedValue(selectThis, true);
        }
        if ((var = this.getSelectedVariable()) == null) {
            return;
        }
        String pt = this.initialName = this.cellRenderer.getVariableText(var);
        this.name.setText(pt);
        this.initialValue = var.getPureValue(-1);
        this.value.setText(this.initialValue);
        if (var.getObject() instanceof Object[]) {
            this.value.setEditable(false);
        } else {
            this.value.setEditable(true);
        }
        if (var.isCode()) {
            Object eval = VarContext.globalContext.evalVar(var);
            if (eval == null) {
                this.evaluation.setText("");
            } else {
                this.evaluation.setText(eval.toString());
            }
        } else {
            this.evaluation.setText("");
        }
        this.textPanel.setTextDescriptor(var.getTextDescriptor(), null, this.selectedObject);
        this.attrPanel.setVariable(var, var.getTextDescriptor(), null, this.selectedObject);
        this.newButton.setEnabled(false);
        this.updateButton.setEnabled(true);
        this.renameButton.setEnabled(true);
        this.deleteButton.setEnabled(true);
    }

    private void initComponents() {
        this.which = new ButtonGroup();
        this.corner = new ButtonGroup();
        this.size = new ButtonGroup();
        this.ok = new JButton();
        this.currentCell = new JRadioButton();
        this.currentNode = new JRadioButton();
        this.currentExport = new JRadioButton();
        this.currentPort = new JRadioButton();
        this.currentArc = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        this.jLabel1 = new JLabel();
        this.body = new JPanel();
        this.jLabel10 = new JLabel();
        this.listPane = new JScrollPane();
        this.jLabel2 = new JLabel();
        this.name = new JTextField();
        this.jLabel11 = new JLabel();
        this.value = new JTextField();
        this.evaluation = new JLabel();
        this.evalLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.newButton = new JButton();
        this.jLabel3 = new JLabel();
        this.updateButton = new JButton();
        this.deleteButton = new JButton();
        this.renameButton = new JButton();
        this.cellName = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Attributes");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Attributes.this.closeDialog(evt);
            }
        });
        this.ok.setText("Done");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Attributes.this.ok(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.currentCell.setText("On Current Cell:");
        this.which.add(this.currentCell);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.currentCell, gridBagConstraints);
        this.currentNode.setText(" Node");
        this.which.add(this.currentNode);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)this.currentNode, gridBagConstraints);
        this.currentExport.setText(" Export");
        this.which.add(this.currentExport);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)this.currentExport, gridBagConstraints);
        this.currentPort.setText("Port on Node");
        this.which.add(this.currentPort);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)this.currentPort, gridBagConstraints);
        this.currentArc.setText(" Arc");
        this.which.add(this.currentArc);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)this.currentArc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jLabel1.setText("or Highlighted Object:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.body.setLayout(new GridBagLayout());
        this.jLabel10.setText("Attributes:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.body.add((Component)this.jLabel10, gridBagConstraints);
        this.listPane.setMinimumSize(new Dimension(400, 100));
        this.listPane.setPreferredSize(new Dimension(400, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.body.add((Component)this.listPane, gridBagConstraints);
        this.jLabel2.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.body.add((Component)this.jLabel2, gridBagConstraints);
        this.name.setText("");
        this.name.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                Attributes.this.nameKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.body.add((Component)this.name, gridBagConstraints);
        this.jLabel11.setText("Value:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.body.add((Component)this.jLabel11, gridBagConstraints);
        this.value.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.body.add((Component)this.value, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.body.add((Component)this.evaluation, gridBagConstraints);
        this.evalLabel.setText("Evaluation:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.body.add((Component)this.evalLabel, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.newButton.setText("Create New");
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Attributes.this.newButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 8, 4, 8);
        this.jPanel1.add((Component)this.newButton, gridBagConstraints);
        this.jLabel3.setText("Selected:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 12, 4, 4);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.updateButton.setText("Update");
        this.updateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Attributes.this.updateButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 8, 4, 8);
        this.jPanel1.add((Component)this.updateButton, gridBagConstraints);
        this.deleteButton.setText("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Attributes.this.deleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 8, 4, 8);
        this.jPanel1.add((Component)this.deleteButton, gridBagConstraints);
        this.renameButton.setText("Rename");
        this.renameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Attributes.this.renameButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.renameButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.body.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.body, gridBagConstraints);
        this.cellName.setText("clock{sch}");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.cellName, gridBagConstraints);
        this.pack();
    }

    private void renameButtonActionPerformed(ActionEvent evt) {
        Variable var;
        Object ret = JOptionPane.showInputDialog(this, "New name for " + this.name.getText(), "Rename Attribute", 3, null, null, this.name.getText());
        String newName = (String)ret;
        if ((newName = newName.trim()).equals("")) {
            JOptionPane.showMessageDialog(this, "Attribute name must not be empty", "Invalid Input", 0);
            return;
        }
        if (newName.equals(this.name.getText())) {
            return;
        }
        if (this.cellRenderer.getShowAttrOnly()) {
            newName = "ATTR_" + newName;
        }
        if ((var = this.selectedObject.getVar(newName)) != null) {
            JOptionPane.showMessageDialog(this, "Attribute of that name already exists", "No Action Taken", 0);
            return;
        }
        RenameAttribute job = new RenameAttribute(this.getSelectedVariable().getKey().getName(), newName, this.selectedObject);
        if (this.cellRenderer.getShowAttrOnly()) {
            newName = newName.substring(5);
        }
        this.initialName = newName;
        this.name.setText(newName);
    }

    private void nameKeyReleased(KeyEvent evt) {
        this.checkName();
    }

    private void ok(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        String varName = this.name.getText().trim();
        if (varName.trim().length() == 0) {
            JOptionPane.showMessageDialog(null, "Attribute name must not be empty", "Invalid Input", 2);
            return;
        }
        if (this.cellRenderer.getShowAttrOnly()) {
            varName = "ATTR_" + varName;
        }
        if (this.selectedObject.getVar(varName) != null) {
            JOptionPane.showMessageDialog(null, "Can't create new attribute " + varName + ", already exists", "Invalid Action", 2);
            return;
        }
        String val = this.value.getText().trim();
        CreateAttribute job = new CreateAttribute(varName, this.getVariableObject(val), this.selectedObject);
        this.textPanel.applyChanges();
        this.attrPanel.applyChanges();
        this.initialName = varName;
        this.initialValue = val;
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        DeleteAttribute job = new DeleteAttribute(this.getSelectedVariable(), this.selectedObject);
    }

    private void updateButtonActionPerformed(ActionEvent evt) {
        boolean changed = false;
        Variable selectedVar = this.getSelectedVariable();
        if (selectedVar == null) {
            return;
        }
        String varName = selectedVar.getKey().getName();
        String varValue = this.value.getText().trim();
        if (!varValue.equals(this.initialValue)) {
            changed = true;
        }
        if (changed) {
            ChangeAttribute job = new ChangeAttribute(varName, this.selectedObject, this.getVariableObject(varValue));
            this.initialValue = varValue;
        }
        this.textPanel.applyChanges();
        this.attrPanel.applyChanges();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    private static class VariableCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private boolean showAttrOnly;

        private VariableCellRenderer(boolean showAttrOnly) {
            this.showAttrOnly = showAttrOnly;
        }

        private void setShowAttrOnly(boolean b) {
            this.showAttrOnly = b;
        }

        private boolean getShowAttrOnly() {
            return this.showAttrOnly;
        }

        private String getVariableText(Variable var) {
            String varName = var.getKey().getName();
            if (this.showAttrOnly && varName.startsWith("ATTR_")) {
                return varName.substring(5);
            }
            String betterName = Variable.betterVariableName(varName);
            if (betterName != null) {
                return betterName;
            }
            return varName;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (!(value instanceof Variable)) {
                this.setText(value.toString());
            } else {
                Variable var = (Variable)value;
                this.setText(this.getVariableText(var));
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    protected static class ChangeAttribute
    extends Job {
        String varName;
        ElectricObject owner;
        Object newValue;

        protected ChangeAttribute(String varName, ElectricObject owner, Object newValue) {
            super("Change Attribute", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.varName = varName;
            this.owner = owner;
            this.newValue = newValue;
            this.startJob();
        }

        public boolean doIt() {
            Variable var = this.owner.getVar(this.varName);
            if (var == null) {
                System.out.println("Could not update Attribute " + this.varName + ": it does not exist");
                return false;
            }
            var = this.owner.updateVar(this.varName, this.newValue);
            if (var == null) {
                System.out.println("Error updating Attribute " + this.varName);
                return false;
            }
            Undo.redrawObject(this.owner);
            return true;
        }
    }

    protected static class RenameAttribute
    extends Job {
        String varName;
        String newVarName;
        ElectricObject owner;

        protected RenameAttribute(String varName, String newVarName, ElectricObject owner) {
            super("Rename Attribute", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.varName = varName;
            this.newVarName = newVarName;
            this.owner = owner;
            this.startJob();
        }

        public boolean doIt() {
            Variable var = this.owner.renameVar(this.varName, this.newVarName);
            if (var == null) {
                System.out.println("Rename of variable failed");
                return false;
            }
            return true;
        }
    }

    private static class CreateAttribute
    extends Job {
        private String newName;
        private Object newValue;
        private ElectricObject owner;

        private CreateAttribute(String newName, Object newValue, ElectricObject owner) {
            super("Create Attribute", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.newName = newName;
            this.newValue = newValue;
            this.owner = owner;
            this.startJob();
        }

        public boolean doIt() {
            if (this.owner.getVar(this.newName) != null) {
                JOptionPane.showMessageDialog(null, "Can't create new attribute " + this.newName + ", already exists", "Invalid Action", 2);
                return false;
            }
            this.owner.newVar(this.newName, this.newValue);
            if (this.owner instanceof Cell) {
                Variable var = this.owner.getVar(this.newName);
                if (var == null) {
                    return false;
                }
                TextDescriptor td = var.getTextDescriptor();
                td.setParam(true);
                td.setInherit(true);
            }
            return true;
        }
    }

    private static class DeleteAttribute
    extends Job {
        Variable var;
        ElectricObject owner;

        private DeleteAttribute(Variable var, ElectricObject owner) {
            super("Delete Attribute", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.var = var;
            this.owner = owner;
            this.startJob();
        }

        public boolean doIt() {
            if (this.var == null) {
                return false;
            }
            this.owner.delVar(this.var.getKey());
            return true;
        }
    }
}

