/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.variable;

import com.sun.electric.Main;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.User;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EvalJavaBsh {
    private static Method evalMethod;
    private static Method sourceMethod;
    private static Method setMethod;
    private static Method getTargetMethod;
    private static Class interpreterClass;
    private static Class targetErrorClass;
    private static final Pattern atPat;
    private static final Pattern pPat;
    private Object envObject = null;
    private Stack contextStack = new Stack();
    private Stack infoStack = new Stack();
    public static final EvalJavaBsh evalJavaBsh;
    private static boolean DEBUG;
    private static boolean DEBUGSTACKTRACE;

    private EvalJavaBsh() {
        this.initBSH();
        if (interpreterClass == null) {
            return;
        }
        try {
            this.envObject = interpreterClass.newInstance();
        }
        catch (Exception e) {
            System.out.println("Can't create an instance of the Bean Shell: " + e.getMessage());
            this.envObject = null;
            return;
        }
        this.setVariable("evalJavaBsh", this);
        try {
            this.doEval("Object P(String par) { return evalJavaBsh.P(par); }");
            this.doEval("Object PAR(String par) { return evalJavaBsh.PAR(par); }");
            this.doEval("import com.sun.electric.tool.user.menus.MenuCommands;");
            this.doEval("import com.sun.electric.database.hierarchy.*;");
            this.doEval("import com.sun.electric.database.prototype.*;");
            this.doEval("import com.sun.electric.database.topology.*;");
            this.doEval("import com.sun.electric.database.variable.ElectricObject;");
            this.doEval("import com.sun.electric.database.variable.FlagSet;");
            this.doEval("import com.sun.electric.database.variable.TextDescriptor;");
            this.doEval("import com.sun.electric.database.variable.VarContext;");
            this.doEval("import com.sun.electric.database.variable.Variable;");
            this.doEval("import com.sun.electric.tool.io.*;");
        }
        catch (VarContext.EvalException e) {
            e.printStackTrace(System.out);
        }
    }

    public synchronized VarContext getCurrentContext() {
        return (VarContext)this.contextStack.peek();
    }

    public synchronized Object getCurrentInfo() {
        return this.infoStack.peek();
    }

    protected static String replace(String expr) {
        StringBuffer sb = new StringBuffer();
        Matcher atMat = atPat.matcher(expr);
        while (atMat.find()) {
            atMat.appendReplacement(sb, "P(\"" + atMat.group(1) + "\")");
        }
        atMat.appendTail(sb);
        expr = sb.toString();
        sb = new StringBuffer();
        Matcher pMat = pPat.matcher(expr);
        while (pMat.find()) {
            if (pMat.group(2).startsWith("ATTR_")) {
                pMat.appendReplacement(sb, pMat.group(0));
                continue;
            }
            pMat.appendReplacement(sb, pMat.group(1) + "(\"ATTR_" + pMat.group(2) + "\")");
        }
        pMat.appendTail(sb);
        return sb.toString();
    }

    protected synchronized Object evalVarObject(Object obj, VarContext context, Object info) throws VarContext.EvalException {
        Object ret;
        if (obj instanceof String[]) {
            String[] strArray = (String[])obj;
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < strArray.length; ++i) {
                buf.append(strArray[i]);
            }
            obj = buf;
        }
        String expr = EvalJavaBsh.replace(obj.toString());
        if (context == null) {
            context = VarContext.globalContext;
        }
        for (int i = 0; i < this.contextStack.size(); ++i) {
            VarContext vc = (VarContext)this.contextStack.get(i);
            Object inf = this.infoStack.get(i);
            if (vc != context || inf != info) continue;
            throw new VarContext.EvalException("JavaBeanShell Eval recursion error");
        }
        this.contextStack.push(context);
        this.infoStack.push(info);
        try {
            ret = this.doEval(expr);
        }
        catch (VarContext.EvalException e) {
            this.contextStack.pop();
            this.infoStack.pop();
            throw e;
        }
        this.contextStack.pop();
        this.infoStack.pop();
        if (DEBUG) {
            System.out.println("BSH: " + expr.toString() + " --> " + ret);
        }
        return ret;
    }

    public synchronized Object P(String name) throws VarContext.EvalException {
        VarContext context = (VarContext)this.contextStack.peek();
        Object val = context.lookupVarEval(name);
        if (DEBUG) {
            System.out.println(name + " ---> " + val + " (" + val.getClass() + ")");
        }
        return val;
    }

    public synchronized Object PAR(String name) throws VarContext.EvalException {
        VarContext context = (VarContext)this.contextStack.peek();
        Object val = context.lookupVarFarEval(name);
        if (DEBUG) {
            System.out.println(name + " ---> " + val + " (" + val.getClass() + ")");
        }
        return val;
    }

    public static void runScript(String script) {
        runScriptJob job = new runScriptJob(script);
    }

    private void initBSH() {
        if (interpreterClass != null) {
            return;
        }
        try {
            interpreterClass = Class.forName("bsh.Interpreter");
            targetErrorClass = Class.forName("bsh.TargetError");
        }
        catch (ClassNotFoundException e) {
            System.out.println("GNU Release can't find the Bean Shell: " + e.getMessage());
            interpreterClass = null;
            return;
        }
        try {
            evalMethod = interpreterClass.getMethod("eval", String.class);
            sourceMethod = interpreterClass.getMethod("source", String.class);
            setMethod = interpreterClass.getMethod("set", String.class, Object.class);
            getTargetMethod = targetErrorClass.getMethod("getTarget", null);
        }
        catch (NoSuchMethodException e) {
            System.out.println("Can't find methods in the Bean Shell: " + e.getMessage());
            interpreterClass = null;
            return;
        }
    }

    public void setVariable(String name, Object value) {
        try {
            if (this.envObject != null) {
                setMethod.invoke(this.envObject, name, value);
            }
        }
        catch (Exception e) {
            EvalJavaBsh.handleInvokeException(e, "Bean shell error setting " + name + " to " + value + ": ");
        }
    }

    private Object doEval(String line) throws VarContext.EvalException {
        Object returnVal = null;
        try {
            if (this.envObject != null) {
                returnVal = evalMethod.invoke(this.envObject, line);
            }
        }
        catch (Exception e) {
            VarContext.EvalException ee;
            if (e instanceof InvocationTargetException && (ee = this.getEvalException((InvocationTargetException)e)) != null) {
                throw ee;
            }
            EvalJavaBsh.handleInvokeException(e, "Bean shell error evaluating " + line);
        }
        return returnVal;
    }

    private void doSource(String file) {
        try {
            if (this.envObject != null) {
                sourceMethod.invoke(this.envObject, file);
            }
        }
        catch (Exception e) {
            EvalJavaBsh.handleInvokeException(e, "Bean shell error sourcing '" + file + "'");
        }
    }

    private static Throwable doGetTarget(Object ex) {
        Throwable returnVal = null;
        if (interpreterClass != null) {
            try {
                returnVal = (Throwable)getTargetMethod.invoke(ex, (Object[])null);
            }
            catch (Exception e) {
                EvalJavaBsh.handleInvokeException(e, "Bean shell error getting exception target");
            }
        }
        return returnVal;
    }

    private VarContext.EvalException getEvalException(InvocationTargetException e) {
        Throwable t = e.getCause();
        if (t == null) {
            return null;
        }
        Throwable tt = EvalJavaBsh.doGetTarget(t);
        if (tt == null) {
            return null;
        }
        if (tt instanceof VarContext.EvalException) {
            return (VarContext.EvalException)tt;
        }
        return null;
    }

    private static void handleInvokeException(Exception e, String description) {
        if (e instanceof InvocationTargetException) {
            Throwable t = e.getCause();
            if (t != null) {
                EvalJavaBsh.handleBshError((Exception)t, description);
            }
        } else if (e instanceof IllegalArgumentException) {
            System.out.println(description + ": " + e.getMessage());
            if (DEBUG) {
                e.printStackTrace(System.out);
            }
        } else if (e instanceof IllegalAccessException) {
            System.out.println(description + ": " + e.getMessage());
            if (DEBUG) {
                e.printStackTrace(System.out);
            }
        } else {
            System.out.println("Unhandled Exception: ");
            System.out.println(description + ": " + e.getMessage());
            e.printStackTrace(System.out);
        }
        if (Main.BATCHMODE) {
            System.exit(1);
        }
    }

    private static void handleBshError(Exception e, String description) {
        if (targetErrorClass.isInstance(e)) {
            Throwable t = EvalJavaBsh.doGetTarget(e);
            if (t != null) {
                if (t instanceof VarContext.EvalException) {
                    if (DEBUG) {
                        System.out.println("EvalException: " + description + ": " + t.getMessage());
                        if (DEBUGSTACKTRACE) {
                            e.printStackTrace(System.out);
                        }
                    }
                } else {
                    if (t.getMessage() != null) {
                        System.out.println(description + ": " + t.getMessage());
                    } else if (t.getStackTrace() != null) {
                        System.out.println(description + ": ");
                        t.printStackTrace(System.out);
                    } else {
                        System.out.println(description + ": " + t);
                    }
                    if (DEBUGSTACKTRACE) {
                        e.printStackTrace(System.out);
                    }
                }
            }
        } else {
            System.out.println("Unhandled Bsh Exception: " + description + ": " + e.getMessage());
            if (DEBUGSTACKTRACE) {
                e.printStackTrace(System.out);
            }
        }
    }

    static {
        interpreterClass = null;
        atPat = Pattern.compile("@(\\w+)");
        pPat = Pattern.compile("(P|PAR)\\(\"(\\w+)\"\\)");
        evalJavaBsh = new EvalJavaBsh();
        DEBUG = false;
        DEBUGSTACKTRACE = false;
    }

    private static class runScriptJob
    extends Job {
        String script;
        EvalJavaBsh evaluator;

        protected runScriptJob(String script) {
            super("JavaBsh script: " + script, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.script = script;
            this.evaluator = new EvalJavaBsh();
            this.startJob();
        }

        public boolean doIt() {
            this.evaluator.doSource(this.script);
            return true;
        }
    }
}

