/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Port;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ncc.ExportMismatch;
import com.sun.electric.tool.user.ncc.ExportMismatchTable;
import com.sun.electric.tool.user.ncc.ExportTableModel;
import com.sun.electric.tool.user.ncc.HighlightTools;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

class MismatchTableModel
extends ExportTableModel {
    private boolean[] swapCells;
    private ExportMismatch[] mismatches;

    public MismatchTableModel(ExportMismatchTable parent) {
        super(parent);
        this.mismatches = parent.mismatches;
        int[][] cellPrefHeights = parent.cellPrefHeights;
        int[][] cellPrefWidths = parent.cellPrefWidths;
        this.swapCells = new boolean[this.height];
        int cellNdx = 0;
        Border border = BorderFactory.createEmptyBorder();
        StringBuffer html = new StringBuffer(64);
        for (int row = 0; row < this.height; ++row) {
            int swap;
            if (this.mismatches[row].getName(0).equals(parent.result.getNames()[0])) {
                swap = 0;
                this.swapCells[row] = false;
            } else {
                swap = 1;
                this.swapCells[row] = true;
            }
            int j = 0;
            while (j < 2) {
                Port port;
                html.setLength(0);
                html.append("<html><font size=3><font face=\"Helvetica, TimesRoman\">");
                int lineNdx = cellNdx * 10000;
                if (this.mismatches[row] instanceof ExportMismatch.MultiMatch) {
                    ArrayList ports = ((ExportMismatch.MultiMatch)this.mismatches[row]).getAll((j + swap) % 2);
                    Iterator it = ports.iterator();
                    while (it.hasNext()) {
                        this.appendNameOf((Port)it.next(), html, lineNdx, false, null);
                        if (it.hasNext()) {
                            html.append("<br>" + this.LSEP);
                        }
                        ++lineNdx;
                        int[] nArray = cellPrefHeights[row];
                        int n = j;
                        nArray[n] = nArray[n] + 17;
                    }
                } else if (this.mismatches[row] instanceof ExportMismatch.NameMismatch) {
                    if (j == swap) {
                        port = ((ExportMismatch.NameMismatch)this.mismatches[row]).getFirstExport();
                        this.appendNameOf(port, html, lineNdx, false, null);
                    } else {
                        NetObject no = ((ExportMismatch.NameMismatch)this.mismatches[row]).getSuggestion();
                        this.appendNameOf(no, html, lineNdx, true, "green");
                    }
                    ++lineNdx;
                    int[] nArray = cellPrefHeights[row];
                    int n = j;
                    nArray[n] = nArray[n] + 17;
                } else if (this.mismatches[row] instanceof ExportMismatch.TopologyMismatch) {
                    NetObject no;
                    if (j == swap) {
                        port = ((ExportMismatch.TopologyMismatch)this.mismatches[row]).getFirstExport();
                        this.appendNameOf(port, html, lineNdx, true, "red");
                    } else {
                        port = ((ExportMismatch.TopologyMismatch)this.mismatches[row]).getSecondExport();
                        this.appendNameOf(port, html, lineNdx, true, "red");
                    }
                    ++lineNdx;
                    if (j != swap && (no = ((ExportMismatch.TopologyMismatch)this.mismatches[row]).getSuggestion()) != null) {
                        html.append("<br>");
                        this.appendNameOf(no, html, lineNdx, true, "green");
                        ++lineNdx;
                        int[] nArray = cellPrefHeights[row];
                        int n = j;
                        nArray[n] = nArray[n] + 17;
                    }
                    int[] nArray = cellPrefHeights[row];
                    int n = j;
                    nArray[n] = nArray[n] + 17;
                }
                html.append("</font></html>");
                JEditorPane htmlPane = new JEditorPane();
                htmlPane.setEditable(false);
                htmlPane.addHyperlinkListener(this);
                htmlPane.setContentType("text/html");
                htmlPane.setText(html.toString());
                htmlPane.setMargin(this.insets);
                htmlPane.addMouseListener(this.mouseAdapter);
                htmlPane.moveCaretPosition(0);
                cellPrefWidths[row][j] = htmlPane.getPreferredSize().width + 11;
                if (cellPrefHeights[row][j] > 118) {
                    cellPrefHeights[row][j] = 118;
                }
                JPanel panel = new JPanel();
                panel.setBackground(Color.WHITE);
                panel.add(htmlPane);
                this.panes[row][j] = new JScrollPane(panel);
                this.panes[row][j].setBorder(border);
                ++j;
                ++cellNdx;
            }
        }
    }

    protected void appendNameOf(NetObject no, StringBuffer html, int lineNdx, boolean doColoring, String sugColor) {
        String href = "<a style=\"text-decoration: none\" href=\"";
        String text = null;
        boolean isImpl = false;
        if (no instanceof Port) {
            Port port = (Port)no;
            isImpl = this.isImplied(port);
            text = port.exportNamesString();
            if (doColoring) {
                html.append("<font COLOR=\"" + sugColor + "\">");
            }
            if (isImpl) {
                html.append(text);
                if (doColoring) {
                    html.append("</font>");
                }
                html.append("<font COLOR=\"gray\"> : implied</font>");
            } else {
                html.append(href + lineNdx + "\">" + text + "</a>");
                if (doColoring) {
                    html.append("</font>");
                }
            }
        } else if (no instanceof Wire) {
            text = no.getName();
            if (doColoring) {
                html.append("<font COLOR=\"" + sugColor + "\">");
            }
            html.append(href + lineNdx + "\">" + text + "</a></font>");
            if (doColoring) {
                html.append("</font>");
            }
        }
    }

    protected boolean isImplied(Port port) {
        Iterator it = port.getWire().getNameProxy().getNet().getExports();
        return !it.hasNext();
    }

    protected void highlight(int index) {
        VarContext context;
        ExportMismatch em;
        Cell cell;
        Highlighter highlighter;
        int line = index % 10000;
        int row = index / 10000 / 2;
        int col = index / 10000 % 2;
        if (this.swapCells[row]) {
            col = (col + 1) % 2;
        }
        if ((highlighter = HighlightTools.getHighlighter(cell = (em = this.mismatches[row]).getCell(col), context = em.getContext(col))) == null) {
            return;
        }
        if (em instanceof ExportMismatch.MultiMatch) {
            ArrayList ports = ((ExportMismatch.MultiMatch)em).getAll(col);
            Iterator it = ports.iterator();
            for (int i = 0; it.hasNext() && i < line; ++i) {
                it.next();
            }
            Port port = (Port)it.next();
            HighlightTools.highlightPortExports(highlighter, cell, port);
        } else if (em instanceof ExportMismatch.NameMismatch) {
            if (col == 0) {
                Port port = ((ExportMismatch.NameMismatch)em).getFirstExport();
                HighlightTools.highlightPortExports(highlighter, cell, port);
            } else {
                NetObject portOrWire = ((ExportMismatch.NameMismatch)em).getSuggestion();
                HighlightTools.highlightPortOrWire(highlighter, cell, portOrWire);
            }
        } else if (em instanceof ExportMismatch.TopologyMismatch) {
            if (col == 0) {
                Port port1 = ((ExportMismatch.TopologyMismatch)em).getFirstExport();
                HighlightTools.highlightPortExports(highlighter, cell, port1);
            } else if (line == 0) {
                Port port2 = ((ExportMismatch.TopologyMismatch)em).getSecondExport();
                HighlightTools.highlightPortExports(highlighter, cell, port2);
            } else if (line == 1) {
                NetObject portOrWire = ((ExportMismatch.TopologyMismatch)em).getSuggestion();
                HighlightTools.highlightPortOrWire(highlighter, cell, portOrWire);
            }
        }
        highlighter.finished();
    }

    public String getColumnName(int col) {
        return this.parent.result.getNames()[col];
    }
}

