/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.Equipment;
import com.sun.electric.tool.simulation.test.Infrastructure;

public class HP6624A
extends Equipment {
    String s = new String("null");
    public static final int NUM_CHANNELS = 4;
    private static final float VOLTAGE_RESOLUTION = 0.01f;

    protected HP6624A(String newName) {
        super(newName);
    }

    static void checkChannel(int channel) {
        if (channel < 1 || channel > 4) {
            throw new IllegalArgumentException("Channel " + channel + " outside allowed range 1.." + 4);
        }
    }

    public String getState(int channel) {
        HP6624A.checkChannel(channel);
        String result2 = "Set: " + this.getVoltageSetpoint(channel) + " V, " + this.getCurrentSetpoint(channel) + " A\n";
        result2 = result2 + "Got " + this.readVoltage(channel) + " V, " + this.readCurrent(channel) + " A";
        return result2;
    }

    public static float getVoltageResolution(int channel) {
        HP6624A.checkChannel(channel);
        return 0.01f;
    }

    public float readVoltage(int channel) {
        HP6624A.checkChannel(channel);
        this.write("VOUT ?" + channel);
        this.s = this.read(200);
        return Float.parseFloat(this.s);
    }

    public float getVoltageSetpoint(int channel) {
        HP6624A.checkChannel(channel);
        this.logOther("Reading voltage setpoint on HP6624A " + this.getName() + ", channel " + channel);
        this.write("VSET?" + channel);
        this.s = this.read(200).trim();
        return Float.parseFloat(this.s);
    }

    public void setVoltage(int channel, float voltage) {
        HP6624A.checkChannel(channel);
        this.write("VSET " + channel + " , " + voltage);
    }

    public float readCurrent(int channel) {
        HP6624A.checkChannel(channel);
        this.write("IOUT? " + channel);
        String s = this.read(200).trim();
        return Float.parseFloat(s);
    }

    public float getCurrentSetpoint(int channel) {
        HP6624A.checkChannel(channel);
        this.write("ISET? " + channel);
        String s = this.read(10);
        return Float.parseFloat(s);
    }

    public void setCurrent(int channel, float setAmps) {
        HP6624A.checkChannel(channel);
        this.write("ISET " + channel + ", " + setAmps);
    }

    public void setOverVoltageProtection(int channel, float setVolts) {
        HP6624A.checkChannel(channel);
        this.write("OVSET " + channel + ", " + setVolts);
    }

    public void setOverCurrentProtection(int channel, float setAmps) {
        HP6624A.checkChannel(channel);
        this.write("OCP " + channel + ", " + setAmps);
    }

    public static void main(String[] args) {
        Infrastructure.gpibControllers = new int[]{1};
        HP6624A supply = new HP6624A("hHP6624A");
        for (int chan = 1; chan <= 4; ++chan) {
            System.out.println(chan + ": " + supply.getState(chan));
        }
        supply.interactive();
    }
}

