/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEdit;

import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.tecEdit.Example;
import com.sun.electric.tool.user.tecEdit.Info;
import com.sun.electric.tool.user.tecEdit.Sample;
import com.sun.electric.util.TextUtils;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class TechConversionResult
implements Serializable {
    private boolean good = true;
    private String errorMessage;
    private NodeInst ni;
    private Cell cell;
    private List<Example> neList;
    private Sample ns;
    private double sampleCoord;
    private boolean xDir;

    public boolean failed() {
        return !this.good;
    }

    public void markError(NodeInst ni, Cell cell, String errorMessage) {
        this.good = false;
        this.cell = cell;
        this.ni = ni;
        this.errorMessage = errorMessage;
    }

    public void markStretchProblem(List<Example> neList, Sample ns, Cell cell, double sampleCoord, boolean xDir) {
        this.good = false;
        this.neList = neList;
        this.ns = ns;
        this.cell = cell;
        this.sampleCoord = sampleCoord;
        this.xDir = xDir;
    }

    public String getErrorMessage() {
        String fullErrorMsg = this.errorMessage;
        if (this.cell != null) {
            String prefixErrorMsg = "Cell " + this.cell.describe(false);
            if (this.ni != null) {
                prefixErrorMsg = prefixErrorMsg + ", node " + this.ni.describe(false);
            }
            fullErrorMsg = prefixErrorMsg + ": " + fullErrorMsg;
        }
        return fullErrorMsg;
    }

    public void showError() {
        if (this.errorMessage == null) {
            this.explainStretchProblem();
            return;
        }
        if (this.cell != null) {
            Job.getUserInterface().displayCell(this.cell);
            EditWindow_ wnd = Job.getUserInterface().getCurrentEditWindow_();
            if (wnd != null && this.ni != null) {
                wnd.clearHighlighting();
                wnd.addElectricObject(this.ni, this.cell);
                wnd.finishedHighlighting();
            }
        }
        String msg = this.getErrorMessage();
        Job.getUserInterface().showErrorMessage(msg, "Analysis Failure");
        System.out.println(msg);
    }

    private void explainStretchProblem() {
        Job.getUserInterface().displayCell(this.cell);
        EditWindow_ wnd = Job.getUserInterface().getCurrentEditWindow_();
        if (wnd == null) {
            return;
        }
        wnd.clearHighlighting();
        HashMap<Sample, double[]> factorList = new HashMap<Sample, double[]>();
        double[] factors = this.showSampleInExample(wnd, this.ns, this.neList.get(0), this.sampleCoord, this.xDir, true);
        factorList.put(this.ns, factors);
        for (int n = 1; n < this.neList.size(); ++n) {
            Example e = this.neList.get(n);
            for (Sample s : e.samples) {
                if (s.assoc != this.ns) continue;
                factors = this.showSampleInExample(wnd, s, e, this.sampleCoord, this.xDir, false);
                factorList.put(s, factors);
            }
        }
        Set allSamples = factorList.keySet();
        HashMap<Sample, Integer> offendingSample = new HashMap<Sample, Integer>();
        for (int i = 0; i < 4; ++i) {
            double v1 = 0.0;
            double v2 = 0.0;
            int v1Count = 0;
            int v2Count = 0;
            Sample s1 = null;
            Sample s2 = null;
            for (Sample s : allSamples) {
                factors = (double[])factorList.get(s);
                if (v1Count == 0) {
                    ++v1Count;
                    v1 = factors[i];
                    s1 = s;
                    continue;
                }
                if (v1 == factors[i]) {
                    ++v1Count;
                    continue;
                }
                if (v2Count == 0) {
                    ++v2Count;
                    v2 = factors[i];
                    s2 = s;
                    continue;
                }
                if (v2 != factors[i]) continue;
                ++v2Count;
            }
            if (v1Count + v2Count != allSamples.size()) continue;
            Sample offendingSamp = null;
            if (v1Count == 1) {
                offendingSamp = s1;
            }
            if (v2Count == 1) {
                offendingSamp = s2;
            }
            if (offendingSamp == null) continue;
            Integer prev = (Integer)offendingSample.get(offendingSamp);
            prev = prev == null ? new Integer(1) : new Integer(prev + 1);
            offendingSample.put(offendingSamp, prev);
        }
        Sample offendingSamp = null;
        int num = 0;
        for (Sample s : offendingSample.keySet()) {
            int numTimes = (Integer)offendingSample.get(s);
            if (numTimes <= num) continue;
            num = numTimes;
            offendingSamp = s;
        }
        String err2 = "Cannot determine " + (this.xDir ? "X" : "Y") + " stretching rule for layer " + Info.getSampleName(this.ns.layer) + " in " + this.cell;
        String additional = "\nOne of these stretching rules must be the same for every example:\nOut (the distance from the center to the point)\nIn (the distance from the edge to the point)\nPer (the percentage of the point from the center to the edge)\nOpp (the distance from the opposite edge to the point)";
        if (offendingSamp == null) {
            offendingSamp = this.ns;
            for (Sample s : allSamples) {
                wnd.addElectricObject(s.node, this.cell);
            }
        } else {
            wnd.addElectricObject(offendingSamp.node, this.cell);
            additional = additional + "\n\nThe error is probably with node " + offendingSamp.node.describe(false);
        }
        wnd.finishedHighlighting();
        Job.getUserInterface().showErrorMessage(err2 + additional, "Analysis Failure");
        System.out.println(err2);
    }

    private double[] showSampleInExample(EditWindow_ wnd, Sample ns, Example e, double sampleCoord, boolean xDir, boolean mainExample) {
        double distOut;
        Cell cell = ns.node.getParent();
        ERectangle exampleBounds = wnd.getCell().getBounds();
        double singleStep = Math.max(((RectangularShape)exampleBounds).getHeight(), ((RectangularShape)exampleBounds).getWidth()) / 45.0;
        double doubleStep = singleStep * 2.0;
        double halfStep = singleStep / 2.0;
        double exampleHalfSize = (xDir ? e.hx - e.lx : e.hy - e.ly) / 2.0;
        double exampleCtr = (xDir ? e.lx + e.hx : e.ly + e.hy) / 2.0;
        Point2D pt1 = this.makeDisplayPoint(e, 0.0, exampleCtr - exampleHalfSize, xDir);
        Point2D pt2 = this.makeDisplayPoint(e, singleStep, exampleCtr - exampleHalfSize, xDir);
        wnd.addHighlightLine(pt1, pt2, cell, true, false);
        pt1 = this.makeDisplayPoint(e, 0.0, exampleCtr + exampleHalfSize, xDir);
        pt2 = this.makeDisplayPoint(e, singleStep, exampleCtr + exampleHalfSize, xDir);
        wnd.addHighlightLine(pt1, pt2, cell, true, false);
        pt1 = this.makeDisplayPoint(e, 0.0, exampleCtr, xDir);
        pt2 = this.makeDisplayPoint(e, doubleStep, exampleCtr, xDir);
        wnd.addHighlightLine(pt1, pt2, cell, true, false);
        Rectangle2D mainSampleBounds = ns.assoc.node.getBounds();
        Rectangle2D sampleBounds = ns.node.getBounds();
        boolean adjusted = false;
        if (mainExample) {
            adjusted = true;
        } else if (xDir) {
            if (sampleCoord == mainSampleBounds.getMinX()) {
                adjusted = true;
                sampleCoord = sampleBounds.getMinX();
            }
            if (sampleCoord == mainSampleBounds.getMaxX()) {
                adjusted = true;
                sampleCoord = sampleBounds.getMaxX();
            }
        } else {
            if (sampleCoord == mainSampleBounds.getMinY()) {
                adjusted = true;
                sampleCoord = sampleBounds.getMinY();
            }
            if (sampleCoord == mainSampleBounds.getMaxY()) {
                adjusted = true;
                sampleCoord = sampleBounds.getMaxY();
            }
        }
        double[] factors = new double[4];
        double percentOut = Math.abs(sampleCoord - exampleCtr) / exampleHalfSize;
        factors[0] = distOut = Math.abs(sampleCoord - exampleCtr);
        factors[1] = exampleHalfSize - distOut;
        factors[2] = Math.round(percentOut * 100.0);
        factors[3] = distOut + exampleHalfSize;
        if (adjusted) {
            double farEnd;
            double closeEnd;
            double arrowCoord = sampleCoord;
            double arrowCoordInv = sampleCoord;
            if (sampleCoord > exampleCtr) {
                arrowCoord -= singleStep;
                arrowCoordInv += singleStep;
                closeEnd = exampleCtr + exampleHalfSize;
                farEnd = exampleCtr - exampleHalfSize;
            } else {
                arrowCoord += singleStep;
                arrowCoordInv -= singleStep;
                closeEnd = exampleCtr - exampleHalfSize;
                farEnd = exampleCtr + exampleHalfSize;
            }
            pt1 = this.makeDisplayPoint(e, halfStep, sampleCoord, xDir);
            pt2 = this.makeDisplayPoint(e, doubleStep + singleStep, sampleCoord, xDir);
            wnd.addHighlightLine(pt1, pt2, cell, false, false);
            if (sampleCoord != farEnd) {
                pt1 = this.makeDisplayPoint(e, singleStep, farEnd, xDir);
                pt2 = this.makeDisplayPoint(e, singleStep, sampleCoord, xDir);
                wnd.addHighlightLine(pt1, pt2, cell, false, false);
                pt1 = this.makeDisplayPoint(e, singleStep, sampleCoord, xDir);
                pt2 = this.makeDisplayPoint(e, singleStep - singleStep / 3.0, arrowCoord, xDir);
                wnd.addHighlightLine(pt1, pt2, cell, false, false);
                pt1 = this.makeDisplayPoint(e, singleStep, sampleCoord, xDir);
                pt2 = this.makeDisplayPoint(e, singleStep + singleStep / 3.0, arrowCoord, xDir);
                wnd.addHighlightLine(pt1, pt2, cell, false, false);
            }
            if (sampleCoord != exampleCtr) {
                pt1 = this.makeDisplayPoint(e, doubleStep, exampleCtr, xDir);
                pt2 = this.makeDisplayPoint(e, doubleStep, sampleCoord, xDir);
                wnd.addHighlightLine(pt1, pt2, cell, false, false);
                pt1 = this.makeDisplayPoint(e, doubleStep, sampleCoord, xDir);
                pt2 = this.makeDisplayPoint(e, doubleStep - singleStep / 3.0, arrowCoord, xDir);
                wnd.addHighlightLine(pt1, pt2, cell, false, false);
                pt1 = this.makeDisplayPoint(e, doubleStep, sampleCoord, xDir);
                pt2 = this.makeDisplayPoint(e, doubleStep + singleStep / 3.0, arrowCoord, xDir);
                wnd.addHighlightLine(pt1, pt2, cell, false, false);
            }
            if (sampleCoord != closeEnd) {
                pt1 = this.makeDisplayPoint(e, doubleStep, closeEnd, xDir);
                pt2 = this.makeDisplayPoint(e, doubleStep, sampleCoord, xDir);
                wnd.addHighlightLine(pt1, pt2, cell, false, false);
                pt1 = this.makeDisplayPoint(e, doubleStep, sampleCoord, xDir);
                pt2 = this.makeDisplayPoint(e, doubleStep - singleStep / 3.0, arrowCoordInv, xDir);
                wnd.addHighlightLine(pt1, pt2, cell, false, false);
                pt1 = this.makeDisplayPoint(e, doubleStep, sampleCoord, xDir);
                pt2 = this.makeDisplayPoint(e, doubleStep + singleStep / 3.0, arrowCoordInv, xDir);
                wnd.addHighlightLine(pt1, pt2, cell, false, false);
            }
            pt2 = this.makeDisplayPoint(e, doubleStep + halfStep, xDir ? exampleCtr : exampleCtr - halfStep, xDir);
            wnd.addHighlightMessage(cell, "Out=" + TextUtils.formatDouble(factors[0]) + " Per=" + (int)factors[2], pt2);
            pt2 = this.makeDisplayPoint(e, doubleStep - halfStep, xDir ? closeEnd + halfStep : closeEnd - halfStep, xDir);
            wnd.addHighlightMessage(cell, "In=" + TextUtils.formatDouble(factors[1]), pt2);
            pt2 = this.makeDisplayPoint(e, singleStep + halfStep, xDir ? farEnd : farEnd - halfStep, xDir);
            wnd.addHighlightMessage(cell, "Opp=" + TextUtils.formatDouble(factors[3]), pt2);
        }
        return factors;
    }

    private Point2D makeDisplayPoint(Example e, double offsetOrtho, double sampleCoord, boolean xDir) {
        if (xDir) {
            return new Point2D.Double(sampleCoord, e.hy + offsetOrtho);
        }
        return new Point2D.Double(e.hx + offsetOrtho, sampleCoord);
    }
}

