/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.Setting;
import com.sun.electric.technology.Layer;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SkillTab
extends PreferencePanel {
    private JList skillLayerList;
    private DefaultListModel skillLayerModel;
    private JLabel jLabel11;
    private JSeparator jSeparator1;
    private JPanel preferences;
    private JPanel projectSettings;
    private JCheckBox skillFlattenHierarchy;
    private JCheckBox skillGDSNameLimit;
    private JTextField skillLayerName;
    private JScrollPane skillLayerPane;
    private JCheckBox skillNoSubCells;
    private JLabel skillTechnology;

    public SkillTab(PreferencesFrame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.skillLayerName);
    }

    @Override
    public JPanel getUserPreferencesPanel() {
        return this.preferences;
    }

    @Override
    public JPanel getProjectPreferencesPanel() {
        return this.projectSettings;
    }

    @Override
    public String getName() {
        return "Skill";
    }

    private void loadLayers() {
        if (this.skillLayerModel == null) {
            return;
        }
        this.skillLayerModel.clear();
        this.skillTechnology.setText("Skill layers for technology: " + this.curTech.getTechName());
        List<Layer> list = this.curTech.getLayersSortedByUserPreference();
        for (Layer layer : list) {
            String skillLayerName = this.getString(layer.getSkillLayerSetting());
            this.skillLayerModel.addElement(layer.getName() + " (" + skillLayerName + ")");
        }
    }

    @Override
    public void init() {
        this.skillLayerModel = new DefaultListModel();
        this.skillLayerList = new JList(this.skillLayerModel);
        this.skillLayerList.setSelectionMode(0);
        this.skillLayerPane.setViewportView(this.skillLayerList);
        this.skillLayerList.clearSelection();
        this.skillLayerList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SkillTab.this.skillClickLayer();
            }
        });
        this.skillTechnology.setText("Skill layers for technology: " + this.curTech.getTechName());
        this.loadLayers();
        this.skillLayerList.setSelectedIndex(0);
        this.skillClickLayer();
        this.skillLayerName.getDocument().addDocumentListener(new LayerDocumentListener(this));
        this.skillNoSubCells.setSelected(IOTool.isSkillExcludesSubcells());
        this.skillFlattenHierarchy.setSelected(IOTool.isSkillFlattensHierarchy());
        this.skillGDSNameLimit.setSelected(IOTool.isSkillGDSNameLimit());
        if (!IOTool.hasSkill()) {
            this.skillNoSubCells.setEnabled(false);
            this.skillFlattenHierarchy.setEnabled(false);
            this.skillGDSNameLimit.setEnabled(false);
        }
    }

    @Override
    public void term() {
        boolean currBoolean = this.skillNoSubCells.isSelected();
        if (currBoolean != IOTool.isSkillExcludesSubcells()) {
            IOTool.setSkillExcludesSubcells(currBoolean);
        }
        if ((currBoolean = this.skillFlattenHierarchy.isSelected()) != IOTool.isSkillFlattensHierarchy()) {
            IOTool.setSkillFlattensHierarchy(currBoolean);
        }
        if ((currBoolean = this.skillGDSNameLimit.isSelected()) != IOTool.isSkillGDSNameLimit()) {
            IOTool.setSkillGDSNameLimit(currBoolean);
        }
    }

    @Override
    public void reset() {
        if (IOTool.isFactorySkillExcludesSubcells() != IOTool.isSkillExcludesSubcells()) {
            IOTool.setSkillExcludesSubcells(IOTool.isFactorySkillExcludesSubcells());
        }
        if (IOTool.isFactorySkillFlattensHierarchy() != IOTool.isSkillFlattensHierarchy()) {
            IOTool.setSkillFlattensHierarchy(IOTool.isFactorySkillFlattensHierarchy());
        }
        if (IOTool.isFactorySkillGDSNameLimit() != IOTool.isSkillGDSNameLimit()) {
            IOTool.setSkillGDSNameLimit(IOTool.isFactorySkillGDSNameLimit());
        }
        Iterator<Layer> it = this.curTech.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            Setting set = layer.getSkillLayerSetting();
            Object factoryObj = set.getFactoryValue();
            if (!(factoryObj instanceof String)) continue;
            this.setString(set, (String)factoryObj);
        }
    }

    @Override
    public void refresh() {
        this.loadLayers();
    }

    private void skillLayerChanged() {
        Layer layer;
        String str = (String)this.skillLayerList.getSelectedValue();
        int spacePos = str.indexOf(" ");
        if (spacePos >= 0) {
            str = str.substring(0, spacePos);
        }
        if ((layer = this.curTech.findLayer(str)) == null) {
            return;
        }
        String layerName = this.skillLayerName.getText();
        this.setString(layer.getSkillLayerSetting(), layerName);
        String newLine = layer.getName() + " (" + layerName + ")";
        int index = this.skillLayerList.getSelectedIndex();
        this.skillLayerModel.set(index, newLine);
    }

    private void skillClickLayer() {
        Layer layer;
        String str = (String)this.skillLayerList.getSelectedValue();
        if (str == null) {
            return;
        }
        int spacePos = str.indexOf(" ");
        if (spacePos >= 0) {
            str = str.substring(0, spacePos);
        }
        if ((layer = this.curTech.findLayer(str)) == null) {
            return;
        }
        this.skillLayerName.setText(this.getString(layer.getSkillLayerSetting()));
    }

    private void initComponents() {
        this.jSeparator1 = new JSeparator();
        this.projectSettings = new JPanel();
        this.skillLayerPane = new JScrollPane();
        this.skillLayerName = new JTextField();
        this.jLabel11 = new JLabel();
        this.skillTechnology = new JLabel();
        this.preferences = new JPanel();
        this.skillNoSubCells = new JCheckBox();
        this.skillFlattenHierarchy = new JCheckBox();
        this.skillGDSNameLimit = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("IO Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SkillTab.this.closeDialog(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.projectSettings.setLayout(new GridBagLayout());
        this.skillLayerPane.setMinimumSize(new Dimension(150, 150));
        this.skillLayerPane.setPreferredSize(new Dimension(150, 150));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.projectSettings.add((Component)this.skillLayerPane, gridBagConstraints);
        this.skillLayerName.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.projectSettings.add((Component)this.skillLayerName, gridBagConstraints);
        this.jLabel11.setText("SKILL Layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.projectSettings.add((Component)this.jLabel11, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.projectSettings.add((Component)this.skillTechnology, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.projectSettings, gridBagConstraints);
        this.preferences.setLayout(new GridBagLayout());
        this.skillNoSubCells.setText("Do not include subcells");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.preferences.add((Component)this.skillNoSubCells, gridBagConstraints);
        this.skillFlattenHierarchy.setText("Flatten hierarchy");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.preferences.add((Component)this.skillFlattenHierarchy, gridBagConstraints);
        this.skillGDSNameLimit.setText("GDS name limit (32 chars)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.preferences.add((Component)this.skillGDSNameLimit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.preferences, gridBagConstraints);
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class LayerDocumentListener
    implements DocumentListener {
        SkillTab dialog;

        LayerDocumentListener(SkillTab dialog) {
            this.dialog = dialog;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.dialog.skillLayerChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.dialog.skillLayerChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.dialog.skillLayerChanged();
        }
    }
}

