/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar3.concurrency;

import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarMapBase;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarNode;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarRegionNode;
import com.sun.electric.tool.routing.experimentalAStar3.concurrency.GlobalRouteJob;
import com.sun.electric.tool.routing.experimentalAStar3.concurrency.LocalRouteJob;
import com.sun.electric.tool.routing.experimentalAStar3.concurrency.LocalRouteJobComparator;
import com.sun.electric.tool.routing.experimentalAStar3.concurrency.RouteJob;
import com.sun.electric.tool.routing.experimentalAStar3.datastructures.Point3D;
import com.sun.electric.tool.routing.experimentalAStar3.map.FieldMap;
import com.sun.electric.tool.routing.experimentalAStar3.map.RegionBoundingBox;
import com.sun.electric.tool.routing.experimentalAStar3.memorymanager.AStarNodeObjectPool;
import com.sun.electric.tool.routing.experimentalAStar3.memorymanager.AStarRegionNodeObjectPool;
import com.sun.electric.tool.routing.experimentalAStar3.memorymanager.LinkedListObjectPool;
import com.sun.electric.tool.routing.experimentalAStar3.memorymanager.ObjectFactory;
import com.sun.electric.tool.routing.experimentalAStar3.memorymanager.ObjectPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingMain {
    private static Logger logger = LoggerFactory.getLogger(RoutingMain.class);
    public static final int MAX_REVOLUTIONS = 300000;
    private static final int MAX_RETRIES = 1;
    private int layerCount;
    private AStarMapBase<AStarRegionNode> regionGrid;
    private int numRegionsPerSide;
    private int regionWidth;
    private int regionHeight;
    private long maxRuntimeMillis;
    private ExecutorService threadPool;
    private ExecutorCompletionService<GlobalRouteJob> globalCompletionService;
    private ExecutorCompletionService<LocalRouteJob> localCompletionService;
    ObjectPool<GlobalRouteJob> globalRouteJobPool;
    private int routeJobCount;
    private int completedRouteJobCount;
    private List<RouteJob> waitingRouteJobs = new LinkedList<RouteJob>();

    public int getProgress() {
        return Math.min(this.completedRouteJobCount * 100 / this.routeJobCount, 100);
    }

    public void setMaxRuntimeMillis(long maxRuntimeMillis) {
        this.maxRuntimeMillis = maxRuntimeMillis;
    }

    public RoutingMain(int width, int height, int layerCount, int numRegionsPerSide, int threadPoolSize) {
        assert (width % numRegionsPerSide == 0 && height % numRegionsPerSide == 0);
        assert (layerCount > 0);
        this.layerCount = layerCount;
        this.numRegionsPerSide = Math.min(16, Math.max(1, threadPoolSize / 2));
        this.regionWidth = width / this.numRegionsPerSide;
        this.regionHeight = height / this.numRegionsPerSide;
        FieldMap<AStarRegionNode> newGrid = new FieldMap<AStarRegionNode>(this.numRegionsPerSide, this.numRegionsPerSide, layerCount, 0, 0, 0);
        newGrid.setObjectPool(new AStarRegionNodeObjectPool());
        this.regionGrid = newGrid;
        for (int x = 0; x < this.numRegionsPerSide; ++x) {
            for (int y = 0; y < this.numRegionsPerSide; ++y) {
                for (int z = 0; z < layerCount; ++z) {
                    FieldMap<AStarNode> newRoutingMap = new FieldMap<AStarNode>(this.regionWidth, this.regionHeight, 1, 0, 0, 0);
                    newRoutingMap.setObjectPool(new AStarNodeObjectPool());
                    AStarRegionNode node = new AStarRegionNode(newRoutingMap, this.regionWidth, this.regionHeight, x, y, z);
                    newGrid.setNode(x, y, z, node);
                }
            }
        }
        this.threadPool = Executors.newFixedThreadPool(threadPoolSize);
        this.localCompletionService = new ExecutorCompletionService(this.threadPool);
        this.globalCompletionService = new ExecutorCompletionService(this.threadPool);
        this.globalRouteJobPool = new LinkedListObjectPool<GlobalRouteJob>(50, new ObjectFactory<GlobalRouteJob>(){

            @Override
            public GlobalRouteJob create() {
                return new GlobalRouteJob();
            }
        });
        this.routeJobCount = 0;
        this.completedRouteJobCount = 0;
    }

    public void submitRouteJob(RouteJob job) {
        RegionBoundingBox boundingBox;
        Point3D from2 = job.from;
        Point3D to2 = job.to;
        this.setTerminalsAndBlockNeighbours(job);
        assert (this.regionGrid != null);
        job.boundingBox = boundingBox = new RegionBoundingBox(this.regionGrid, this.nodeToRegionX(from2.getX()), this.nodeToRegionY(from2.getY()), from2.getZ(), this.nodeToRegionX(to2.getX()), this.nodeToRegionY(to2.getY()), to2.getZ());
        ++this.routeJobCount;
        this.waitingRouteJobs.add(job);
    }

    private void setTerminalsAndBlockNeighbours(RouteJob job) {
        int x = job.from.getX();
        int y = job.from.getY();
        int z = job.from.getZ();
        double terminalPointX = job.routingSegment.getStartEnd().getLocation().getX();
        double terminalPointY = job.routingSegment.getStartEnd().getLocation().getY();
        this.addTerminalToGlobalNode(job.from, terminalPointX, terminalPointY, job);
        this.setTileBlockedTemporarily(x, y, z);
        this.setTileBlockedTemporarily(x + 1, y, z);
        this.setTileBlockedTemporarily(x - 1, y, z);
        this.setTileBlockedTemporarily(x, y + 1, z);
        this.setTileBlockedTemporarily(x, y - 1, z);
        x = job.to.getX();
        y = job.to.getY();
        z = job.to.getZ();
        terminalPointX = job.routingSegment.getFinishEnd().getLocation().getX();
        terminalPointY = job.routingSegment.getFinishEnd().getLocation().getY();
        this.addTerminalToGlobalNode(job.to, terminalPointX, terminalPointY, job);
        this.setTileBlockedTemporarily(x, y, z);
        this.setTileBlockedTemporarily(x + 1, y, z);
        this.setTileBlockedTemporarily(x - 1, y, z);
        this.setTileBlockedTemporarily(x, y + 1, z);
        this.setTileBlockedTemporarily(x, y - 1, z);
    }

    private void setTileBlockedTemporarily(int x, int y, int z) {
        AStarRegionNode region = this.nodeCoordsToRegion(x, y, z);
        AStarNode node = region.routingMap.nodeAt(this.nodeGlobalToLocalX(x), this.nodeGlobalToLocalY(y), 0);
        if (node.getTemporaryBlockingState() == 0) {
            if (region.isTileBlocked(node.getX(), node.getY())) {
                node.setTemporaryBlockingState(1);
            } else {
                node.setTemporaryBlockingState(2);
            }
        }
        region.routingMap.setTileBlocked(node.getX(), node.getY(), 0, true);
    }

    private void setTileUnblockedTemporarily(int x, int y, int z) {
        AStarRegionNode region = this.nodeCoordsToRegion(x, y, z);
        AStarNode node = region.routingMap.nodeAt(this.nodeGlobalToLocalX(x), this.nodeGlobalToLocalY(y), 0);
        if (node.getTerminalCount() == 0 && node.getTemporaryBlockingState() != 1) {
            region.routingMap.setTileBlocked(node.getX(), node.getY(), 0, false);
        }
    }

    private void unblockedTerminalNode(int x, int y, int z, int quadrant) {
        AStarRegionNode region = this.nodeCoordsToRegion(x, y, z);
        AStarNode node = region.routingMap.nodeAt(this.nodeGlobalToLocalX(x), this.nodeGlobalToLocalY(y), 0);
        if (node.getQuadrants()[quadrant] <= 1) {
            region.routingMap.setTileBlocked(node.getX(), node.getY(), 0, false);
        }
    }

    private void addTerminalToGlobalNode(Point3D terminalGlobalNodeCoords, double terminalGlobalCellX, double terminalGlobalCellY, RouteJob job) {
        int x = terminalGlobalNodeCoords.getX();
        int y = terminalGlobalNodeCoords.getY();
        int z = terminalGlobalNodeCoords.getZ();
        AStarRegionNode region = this.nodeCoordsToRegion(x, y, z);
        AStarNode terminalNode = region.routingMap.nodeAt(this.nodeGlobalToLocalX(x), this.nodeGlobalToLocalY(y), 0);
        int quadrantOfTerminal = this.getQuadrantOfTerminalInGlobalNode(terminalGlobalNodeCoords, terminalGlobalCellX, terminalGlobalCellY, job);
        if (quadrantOfTerminal >= 0) {
            terminalNode.addTerminal(quadrantOfTerminal);
        } else {
            System.out.println("Terminal Node has no terminal! ERROR!");
        }
    }

    private int getQuadrantOfTerminalInGlobalNode(Point3D terminalGlobalNodeCoords, double terminalGlobalCellX, double terminalGlobalCellY, RouteJob job) {
        double nodeMinX = job.astarrouter.nodeCoordXToCell(terminalGlobalNodeCoords.getX());
        double nodeMinY = job.astarrouter.nodeCoordYToCell(terminalGlobalNodeCoords.getY());
        double nodeCenterX = nodeMinX + job.astarrouter.getNodeSize() / 2.0;
        double nodeCenterY = nodeMinY + job.astarrouter.getNodeSize() / 2.0;
        int quadrantOfTerminal = -1;
        quadrantOfTerminal = terminalGlobalCellX >= nodeCenterX ? (terminalGlobalCellY >= nodeCenterY ? 3 : 1) : (terminalGlobalCellY >= nodeCenterY ? 2 : 0);
        return quadrantOfTerminal;
    }

    private void submitPossibleGlobalJobs() {
        Iterator<RouteJob> i = this.waitingRouteJobs.iterator();
        while (i.hasNext()) {
            RouteJob job = i.next();
            if (!job.boundingBox.isBoundingBoxFree()) continue;
            i.remove();
            job.boundingBox.occupyBoundingBox();
            GlobalRouteJob globalJob = this.globalRouteJobPool.acquire();
            this.getTerminalsAndUnblockNeighbours(job);
            Point3D from2 = new Point3D(this.nodeToRegionX(job.from.getX()), this.nodeToRegionY(job.from.getY()), job.from.getZ());
            Point3D to2 = new Point3D(this.nodeToRegionX(job.to.getX()), this.nodeToRegionY(job.to.getY()), job.to.getZ());
            Point3D fromInsideRegion = new Point3D(this.nodeGlobalToLocalX(job.from.getX()), this.nodeGlobalToLocalY(job.from.getY()), 0);
            Point3D toInsideRegion = new Point3D(this.nodeGlobalToLocalX(job.to.getX()), this.nodeGlobalToLocalY(job.to.getY()), 0);
            globalJob.initialize(job, from2, to2, fromInsideRegion, toInsideRegion);
            this.globalCompletionService.submit(globalJob);
        }
    }

    private void getTerminalsAndUnblockNeighbours(RouteJob job) {
        int x = job.from.getX();
        int y = job.from.getY();
        int z = job.from.getZ();
        AStarNode terminalNode = this.nodeCoordsToRegion((int)x, (int)y, (int)z).routingMap.nodeAt(this.nodeGlobalToLocalX(x), this.nodeGlobalToLocalY(y), 0);
        int quadrant = this.getQuadrantOfTerminalInGlobalNode(job.from, job.routingSegment.getStartEnd().getLocation().getX(), job.routingSegment.getStartEnd().getLocation().getY(), job);
        this.unblockedTerminalNode(x, y, z, quadrant);
        if (terminalNode.getTerminalCount() <= 1) {
            this.setTileUnblockedTemporarily(x + 1, y, z);
            this.setTileUnblockedTemporarily(x - 1, y, z);
            this.setTileUnblockedTemporarily(x, y + 1, z);
            this.setTileUnblockedTemporarily(x, y - 1, z);
        } else {
            this.unblockNeighboursTemporaryByQuadrant(x, y, z, terminalNode, quadrant);
        }
        x = job.to.getX();
        y = job.to.getY();
        z = job.to.getZ();
        terminalNode = this.nodeCoordsToRegion((int)x, (int)y, (int)z).routingMap.nodeAt(this.nodeGlobalToLocalX(x), this.nodeGlobalToLocalY(y), 0);
        quadrant = this.getQuadrantOfTerminalInGlobalNode(job.to, job.routingSegment.getFinishEnd().getLocation().getX(), job.routingSegment.getFinishEnd().getLocation().getY(), job);
        this.unblockedTerminalNode(x, y, z, quadrant);
        if (terminalNode.getTerminalCount() <= 1) {
            this.setTileUnblockedTemporarily(x + 1, y, z);
            this.setTileUnblockedTemporarily(x - 1, y, z);
            this.setTileUnblockedTemporarily(x, y + 1, z);
            this.setTileUnblockedTemporarily(x, y - 1, z);
        } else {
            this.unblockNeighboursTemporaryByQuadrant(x, y, z, terminalNode, quadrant);
        }
    }

    private void unblockNeighboursTemporaryByQuadrant(int x, int y, int z, AStarNode terminalNode, int quadrant) {
        int[] quadrants = terminalNode.getQuadrants();
        switch (quadrant) {
            case 0: {
                if (quadrants[0] > 1) {
                    return;
                }
                if (quadrants[2] == 0) {
                    this.setTileUnblockedTemporarily(x - 1, y, z);
                }
                if (quadrants[1] != 0) break;
                this.setTileUnblockedTemporarily(x, y - 1, z);
                break;
            }
            case 1: {
                if (quadrants[1] > 1) {
                    return;
                }
                if (quadrants[0] == 0) {
                    this.setTileUnblockedTemporarily(x, y - 1, z);
                }
                if (quadrants[3] != 0) break;
                this.setTileUnblockedTemporarily(x + 1, y, z);
                break;
            }
            case 2: {
                if (quadrants[2] > 1) {
                    return;
                }
                if (quadrants[0] == 0) {
                    this.setTileUnblockedTemporarily(x - 1, y, z);
                }
                if (quadrants[3] != 0) break;
                this.setTileUnblockedTemporarily(x, y + 1, z);
                break;
            }
            case 3: {
                if (quadrants[3] > 1) {
                    return;
                }
                if (quadrants[1] == 0) {
                    this.setTileUnblockedTemporarily(x + 1, y, z);
                }
                if (quadrants[2] != 0) break;
                this.setTileUnblockedTemporarily(x, y - 1, z);
            }
        }
    }

    public void handleLocalRouteJobFinished(LocalRouteJob finishedJob) {
        if (finishedJob.path != null) {
            for (Point3D pt : finishedJob.path) {
                pt.setZ(finishedJob.regionalNode.getZ());
            }
        }
        finishedJob.routeJob.localRouteJobsCompleted.add(finishedJob);
        if (finishedJob.routeJob.localRouteJobsList.size() != finishedJob.routeJob.localRouteJobsCompleted.size()) {
            return;
        }
        int x = finishedJob.routeJob.from.getX();
        int y = finishedJob.routeJob.from.getY();
        int z = finishedJob.routeJob.from.getZ();
        AStarRegionNode region = this.nodeCoordsToRegion(x, y, z);
        AStarNode terminalNode = region.routingMap.nodeAt(this.nodeGlobalToLocalX(x), this.nodeGlobalToLocalY(y), 0);
        if (terminalNode.getTerminalCount() <= 1) {
            this.setTileUnblockedTemporarily(x - 1, y, z);
            this.setTileUnblockedTemporarily(x + 1, y, z);
            this.setTileUnblockedTemporarily(x, y - 1, z);
            this.setTileUnblockedTemporarily(x, y + 1, z);
        } else {
            this.setTileBlockedTemporarily(x - 1, y, z);
            this.setTileBlockedTemporarily(x + 1, y, z);
            this.setTileBlockedTemporarily(x, y - 1, z);
            this.setTileBlockedTemporarily(x, y + 1, z);
        }
        x = finishedJob.routeJob.to.getX();
        y = finishedJob.routeJob.to.getY();
        z = finishedJob.routeJob.to.getZ();
        region = this.nodeCoordsToRegion(x, y, z);
        terminalNode = region.routingMap.nodeAt(this.nodeGlobalToLocalX(x), this.nodeGlobalToLocalY(y), 0);
        if (terminalNode.getTerminalCount() <= 1) {
            this.setTileUnblockedTemporarily(x - 1, y, z);
            this.setTileUnblockedTemporarily(x + 1, y, z);
            this.setTileUnblockedTemporarily(x, y - 1, z);
            this.setTileUnblockedTemporarily(x, y + 1, z);
        } else {
            this.setTileBlockedTemporarily(x - 1, y, z);
            this.setTileBlockedTemporarily(x + 1, y, z);
            this.setTileBlockedTemporarily(x, y - 1, z);
            this.setTileBlockedTemporarily(x, y + 1, z);
        }
        Collections.sort(finishedJob.routeJob.localRouteJobsCompleted, new LocalRouteJobComparator());
        ArrayList<Point3D> totalPath = new ArrayList<Point3D>();
        for (LocalRouteJob lrj : finishedJob.routeJob.localRouteJobsCompleted) {
            if (lrj.getPath() == null) {
                finishedJob.path = null;
                finishedJob.routeJob.path = null;
                ++this.completedRouteJobCount;
                finishedJob.routeJob.onCompletion();
                finishedJob.routeJob.boundingBox.releaseBoundingBox();
                this.submitPossibleGlobalJobs();
                return;
            }
            for (Point3D pt : lrj.getPath()) {
                Point3D pt2 = new Point3D(this.nodeLocalToGlobalX(pt.getX(), lrj.regionalNode), this.nodeLocalToGlobalY(pt.getY(), lrj.regionalNode), pt.getZ());
                totalPath.add(pt2);
            }
        }
        for (Point3D pt : totalPath) {
            this.setTileBlocked(pt.getX(), pt.getY(), pt.getZ(), true);
        }
        finishedJob.routeJob.path = totalPath;
        ++this.completedRouteJobCount;
        finishedJob.routeJob.boundingBox.releaseBoundingBox();
        this.submitPossibleGlobalJobs();
        finishedJob.routeJob.onCompletion();
    }

    public void handleGlobalRouteJobFinished(GlobalRouteJob finishedJob) {
        List<AStarRegionNode> path = finishedJob.resultPath;
        if (path == null) {
            if (finishedJob.routeJob.retries < 1) {
                ++finishedJob.routeJob.retries;
                finishedJob.routeJob.boundingBox.releaseBoundingBox();
                finishedJob.routeJob.boundingBox.enlarge();
                this.waitingRouteJobs.add(finishedJob.routeJob);
            } else {
                int x = finishedJob.routeJob.from.getX();
                int y = finishedJob.routeJob.from.getY();
                int z = finishedJob.routeJob.from.getZ();
                this.setTileBlockedTemporarily(x, y, z);
                this.setTileBlockedTemporarily(x + 1, y, z);
                this.setTileBlockedTemporarily(x - 1, y, z);
                this.setTileBlockedTemporarily(x, y + 1, z);
                this.setTileBlockedTemporarily(x, y - 1, z);
                x = finishedJob.routeJob.to.getX();
                y = finishedJob.routeJob.to.getY();
                z = finishedJob.routeJob.to.getZ();
                this.setTileBlockedTemporarily(x, y, z);
                this.setTileBlockedTemporarily(x + 1, y, z);
                this.setTileBlockedTemporarily(x - 1, y, z);
                this.setTileBlockedTemporarily(x, y + 1, z);
                this.setTileBlockedTemporarily(x, y - 1, z);
                ++this.completedRouteJobCount;
                finishedJob.routeJob.boundingBox.releaseBoundingBox();
                finishedJob.routeJob.path = null;
                finishedJob.routeJob.onCompletion();
            }
        } else {
            int i = 0;
            while (i < path.size()) {
                AStarRegionNode rn = path.get(i);
                if (i < path.size() - 1) {
                    AStarRegionNode nextRegion = path.get(i + 1);
                    AStarNode entryPoint = path.get(i + 1).getEntryPoint();
                    if (nextRegion.getX() < rn.getX()) {
                        rn.setExitPoint(rn.getMap(true).nodeAt(0, entryPoint.getY(), 0));
                    } else if (nextRegion.getX() > rn.getX()) {
                        rn.setExitPoint(rn.getMap(true).nodeAt(this.regionWidth - 1, entryPoint.getY(), 0));
                    } else if (nextRegion.getY() < rn.getY()) {
                        rn.setExitPoint(rn.getMap(true).nodeAt(entryPoint.getX(), 0, 0));
                    } else if (nextRegion.getY() > rn.getY()) {
                        rn.setExitPoint(rn.getMap(true).nodeAt(entryPoint.getX(), this.regionHeight - 1, 0));
                    } else if (nextRegion.getZ() != rn.getZ()) {
                        rn.setExitPoint(rn.getMap(true).nodeAt(entryPoint.getX(), entryPoint.getY(), 0));
                    }
                }
                LocalRouteJob localRoute = new LocalRouteJob();
                localRoute.from = new Point3D(rn.getEntryPoint().getX(), rn.getEntryPoint().getY(), rn.getEntryPoint().getZ());
                localRoute.to = new Point3D(rn.getExitPoint().getX(), rn.getExitPoint().getY(), rn.getExitPoint().getZ());
                localRoute.routeJob = finishedJob.getRouteJob();
                localRoute.regionalNode = rn;
                localRoute.numberInGlobalPath = i++;
                localRoute.routeJob.localRouteJobsList.add(localRoute);
                this.localCompletionService.submit(localRoute);
            }
        }
        this.globalRouteJobPool.release(finishedJob);
        this.submitPossibleGlobalJobs();
    }

    public void waitForCompletion() {
        long startTimeMillis;
        long currentTimeMillis = startTimeMillis = System.currentTimeMillis();
        this.submitPossibleGlobalJobs();
        while (this.completedRouteJobCount < this.routeJobCount) {
            if (currentTimeMillis - startTimeMillis > this.maxRuntimeMillis) {
                logger.debug("timeout ...");
                break;
            }
            try {
                Future<GlobalRouteJob> globalJob;
                Future<LocalRouteJob> localJob = this.localCompletionService.poll();
                if (localJob != null) {
                    this.handleLocalRouteJobFinished(localJob.get());
                }
                if ((globalJob = this.globalCompletionService.poll()) != null) {
                    this.handleGlobalRouteJobFinished(globalJob.get());
                }
                currentTimeMillis = System.currentTimeMillis();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        this.threadPool.shutdownNow();
    }

    public void setBlockage(int sx, int sy, int ex, int ey) {
        for (int x = sx; x <= ex; ++x) {
            this.setTileBlockedAllLayers(x, sy);
            this.setTileBlockedAllLayers(x, ey);
        }
        for (int y = sy; y <= ey; ++y) {
            this.setTileBlockedAllLayers(sx, y);
            this.setTileBlockedAllLayers(ex, y);
        }
    }

    public void setBlockage(int sx, int sy, int ex, int ey, int z) {
        for (int x = sx; x <= ex; ++x) {
            this.setTileBlocked(x, sy, z, true);
            this.setTileBlocked(x, ey, z, true);
        }
        for (int y = sy; y <= ey; ++y) {
            this.setTileBlocked(sx, y, z, true);
            this.setTileBlocked(ex, y, z, true);
        }
    }

    private void setTileBlocked(int x, int y, int z, boolean blockedStatus) {
        AStarRegionNode node = this.nodeCoordsToRegion(x, y, z);
        node.routingMap.setTileBlocked(this.nodeGlobalToLocalX(x), this.nodeGlobalToLocalY(y), 0, blockedStatus);
    }

    private void setTileBlockedAllLayers(int x, int y) {
        for (int z = 0; z < this.layerCount; ++z) {
            AStarRegionNode node = this.nodeCoordsToRegion(x, y, z);
            assert (node != null);
            node.routingMap.setTileBlocked(this.nodeGlobalToLocalX(x), this.nodeGlobalToLocalY(y), 0, true);
        }
    }

    public void placePortals() {
        int maxXNodes = this.regionGrid.getMaxXNodes();
        int maxYNodes = this.regionGrid.getMaxYNodes();
        int maxZNodes = this.regionGrid.getMaxZNodes();
        for (int x = 0; x < maxXNodes; ++x) {
            for (int y = 0; y < maxYNodes; ++y) {
                for (int z = 0; z < maxZNodes; ++z) {
                    int rX;
                    int rY;
                    AStarRegionNode neighbourRegion;
                    AStarRegionNode myRegion = this.regionGrid.nodeAt(x, y, z);
                    if (x + 1 < maxXNodes) {
                        neighbourRegion = this.regionGrid.nodeAt(x + 1, y, z);
                        for (rY = 0; rY < this.regionHeight; ++rY) {
                            if (myRegion.isTileBlocked(this.regionWidth - 1, rY) || neighbourRegion.isTileBlocked(0, rY)) continue;
                            myRegion.setPortal(this.regionWidth - 1, rY, false);
                            neighbourRegion.setPortal(0, rY, false);
                        }
                        if (x == 0) {
                            for (rY = 0; rY < this.regionHeight; ++rY) {
                                if (myRegion.isTileBlocked(0, rY)) continue;
                                myRegion.setPortal(0, rY, false);
                            }
                        }
                    } else {
                        for (rY = 0; rY < this.regionHeight; ++rY) {
                            if (myRegion.isTileBlocked(this.regionWidth - 1, rY)) continue;
                            myRegion.setPortal(this.regionWidth - 1, rY, false);
                        }
                    }
                    if (y > 0) {
                        neighbourRegion = this.regionGrid.nodeAt(x, y - 1, z);
                        for (rX = 0; rX < this.regionWidth; ++rX) {
                            if (myRegion.isTileBlocked(rX, 0) || neighbourRegion.isTileBlocked(rX, this.regionHeight - 1)) continue;
                            myRegion.setPortal(rX, 0, true);
                            neighbourRegion.setPortal(rX, this.regionHeight - 1, true);
                        }
                        if (y != maxYNodes - 1) continue;
                        for (rX = 0; rX < this.regionWidth; ++rX) {
                            if (myRegion.isTileBlocked(rX, this.regionHeight - 1)) continue;
                            myRegion.setPortal(rX, this.regionHeight - 1, true);
                        }
                        continue;
                    }
                    for (rX = 0; rX < this.regionWidth; ++rX) {
                        if (myRegion.isTileBlocked(rX, 0)) continue;
                        myRegion.setPortal(rX, 0, true);
                    }
                }
            }
        }
    }

    private int nodeToRegionX(int x) {
        return (int)Math.floor(x / this.regionWidth);
    }

    private int nodeToRegionY(int y) {
        return (int)Math.floor(y / this.regionHeight);
    }

    private int nodeGlobalToLocalX(int x) {
        return x % this.regionWidth;
    }

    private int nodeGlobalToLocalY(int y) {
        return y % this.regionHeight;
    }

    private int nodeLocalToGlobalX(int x, AStarRegionNode whichRegion) {
        return x + this.regionToNodeX(whichRegion.getX());
    }

    private int nodeLocalToGlobalY(int y, AStarRegionNode whichRegion) {
        return y + this.regionToNodeY(whichRegion.getY());
    }

    private int regionToNodeX(int x) {
        return x * this.regionWidth;
    }

    private int regionToNodeY(int y) {
        return y * this.regionHeight;
    }

    private AStarRegionNode nodeCoordsToRegion(int x, int y, int z) {
        return this.regionGrid.nodeAt(this.nodeToRegionX(x), this.nodeToRegionY(y), z);
    }
}

