/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.PrimitivePortId;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.HeadConnection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.TailConnection;
import com.sun.electric.database.topology.Topology;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.BoundsBuilder;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ArcInst
extends Geometric
implements Comparable<ArcInst> {
    public static final int DEFAULTANGLE = -1;
    public static final ArcInst[] NULL_ARRAY = new ArcInst[0];
    public static final int TAILEND = 0;
    public static final int HEADEND = 1;
    public static final Variable.Key ARC_NAME = Variable.newKey("ARC_name");
    static final double MINPORTDISTANCE = DBMath.getEpsilon() * 0.71;
    private final Topology topology;
    ImmutableArcInst d;
    private ERectangle visBounds;
    final PortInst tailPortInst;
    final PortInst headPortInst;

    public ArcInst(Topology topology, ImmutableArcInst d, PortInst headPort, PortInst tailPort) {
        this.topology = topology;
        assert (topology == headPort.getNodeInst().topology);
        assert (topology == tailPort.getNodeInst().topology);
        assert (d.headNodeId == headPort.getNodeInst().getNodeId());
        assert (d.tailNodeId == tailPort.getNodeInst().getNodeId());
        assert (d.headPortId == headPort.getPortProto().getId());
        assert (d.tailPortId == tailPort.getPortProto().getId());
        this.d = d;
        this.tailPortInst = tailPort;
        this.headPortInst = headPort;
    }

    private Object writeReplace() {
        return new ArcInstKey(this);
    }

    @Deprecated
    public static ArcInst makeInstance(ArcProto type, PortInst head, PortInst tail) {
        EditingPreferences ep = EditingPreferences.getInstance();
        ImmutableArcInst a = type.getDefaultInst(ep);
        return ArcInst.newInstanceBase(type, ep, type.getDefaultLambdaBaseWidth(ep), head, tail, null, null, null, -1, a.flags);
    }

    public static ArcInst makeInstance(ArcProto type, EditingPreferences ep, PortInst head, PortInst tail) {
        ImmutableArcInst a = type.getDefaultInst(ep);
        return ArcInst.newInstanceBase(type, ep, type.getDefaultLambdaBaseWidth(ep), head, tail, null, null, null, -1, a.flags);
    }

    public static ArcInst makeInstanceBase(ArcProto type, EditingPreferences ep, double baseWidth, PortInst head, PortInst tail) {
        ImmutableArcInst a = type.getDefaultInst(ep);
        return ArcInst.newInstanceBase(type, ep, baseWidth, head, tail, null, null, null, -1, a.flags);
    }

    public static ArcInst makeInstance(ArcProto type, EditingPreferences ep, PortInst head, PortInst tail, Point2D headPt, Point2D tailPt, String name) {
        ImmutableArcInst a = type.getDefaultInst(ep);
        return ArcInst.newInstanceBase(type, ep, type.getDefaultLambdaBaseWidth(ep), head, tail, headPt, tailPt, name, -1, a.flags);
    }

    public static ArcInst makeInstanceBase(ArcProto type, EditingPreferences ep, double baseWidth, PortInst head, PortInst tail, Point2D headPt, Point2D tailPt, String name) {
        ImmutableArcInst a = type.getDefaultInst(ep);
        return ArcInst.newInstanceBase(type, ep, baseWidth, head, tail, headPt, tailPt, name, -1, a.flags);
    }

    public static ArcInst newInstanceBase(ArcProto type, EditingPreferences ep, double baseWidth, PortInst head, PortInst tail) {
        return ArcInst.newInstanceBase(type, ep, baseWidth, head, tail, null, null, null, -1, ImmutableArcInst.DEFAULT_FLAGS);
    }

    public static ArcInst newInstanceBase(ArcProto type, EditingPreferences ep, double baseWidth, PortInst head, PortInst tail, Point2D headPt, Point2D tailPt, String name, int defAngle) {
        return ArcInst.newInstanceBase(type, ep, baseWidth, head, tail, headPt, tailPt, name, defAngle, ImmutableArcInst.DEFAULT_FLAGS);
    }

    public static ArcInst newInstanceBase(ArcProto type, EditingPreferences ep, double baseWidth, PortInst head, PortInst tail, Point2D headPt, Point2D tailPt, String name, int defAngle, int flags) {
        Name nameKey;
        long gridExtendOverMin = DBMath.lambdaToGrid(0.5 * baseWidth) - type.getBaseExtend().getGrid();
        EPoint headP = headPt == null ? head.getCenter() : EPoint.snap(headPt);
        EPoint tailP = tailPt == null ? tail.getCenter() : EPoint.snap(tailPt);
        Cell parent = head.getNodeInst().topology.cell;
        Poly headPoly = head.getPoly();
        if (!ArcInst.stillInPoly(headP, headPoly)) {
            System.out.println("Error in " + parent + ": head of " + type.getName() + " arc at (" + headP.getX() + "," + headP.getY() + ") does not fit in " + head + " which is centered at (" + headPoly.getCenterX() + "," + headPoly.getCenterY() + ")");
            return null;
        }
        Poly tailPoly = tail.getPoly();
        if (!ArcInst.stillInPoly(tailP, tailPoly)) {
            System.out.println("Error in " + parent + ": tail of " + type.getName() + " arc at (" + tailP.getX() + "," + tailP.getY() + ") does not fit in " + tail + " which is centered at (" + tailPoly.getCenterX() + "," + tailPoly.getCenterY() + ")");
            return null;
        }
        TextDescriptor nameDescriptor = ep.getArcTextDescriptor();
        Name name2 = nameKey = name != null ? Name.findName(name) : null;
        if (nameKey != null && !nameKey.isTempname()) {
            long gridBaseWidth = 2L * (gridExtendOverMin + type.getBaseExtend().getGrid());
            nameDescriptor = ArcInst.getSmartTextDescriptor(defAngle, DBMath.gridToLambda(gridBaseWidth), nameDescriptor, ep);
        }
        return ArcInst.newInstanceNoCheck(parent, type, name, nameDescriptor, head, tail, headP, tailP, gridExtendOverMin, defAngle, flags);
    }

    public static ArcInst newInstanceNoCheck(Cell parent, ArcProto protoType, String name, TextDescriptor nameDescriptor, PortInst headPort, PortInst tailPort, EPoint headPt, EPoint tailPt, long gridExtendOverMin, int angle, int flags) {
        int arcId;
        Name nameKey;
        parent.checkChanging();
        Topology topology = parent.getTopology();
        if (protoType == null || headPort == null || tailPort == null || !headPort.isLinked() || !tailPort.isLinked()) {
            return null;
        }
        if (headPt == null || tailPt == null) {
            return null;
        }
        if (topology != headPort.getNodeInst().topology || topology != tailPort.getNodeInst().topology) {
            System.out.println("ArcProto.newInst: the 2 PortInsts are in different Cells!");
            System.out.println("Cell " + parent.getName());
            System.out.println("Head " + headPort.getNodeInst().topology.cell.getName());
            System.out.println("Tail " + tailPort.getNodeInst().topology.cell.getName());
            return null;
        }
        PortProto headProto = headPort.getPortProto();
        PrimitivePort headPrimPort = headProto.getBasePort();
        if (!headPrimPort.connectsTo(protoType)) {
            System.out.println("Cannot create " + protoType + " from (" + headPt.getX() + "," + headPt.getY() + ") to (" + tailPt.getX() + "," + tailPt.getY() + ") in " + parent + " because the 'from' port (" + headProto.getName() + " on node " + headPort.getNodeInst().describe(false) + ") does not connect to " + protoType);
            return null;
        }
        PortProto tailProto = tailPort.getPortProto();
        PrimitivePort tailPrimPort = tailProto.getBasePort();
        if (!tailPrimPort.connectsTo(protoType)) {
            System.out.println("Cannot create " + protoType + " from (" + headPt.getX() + "," + headPt.getY() + ") to (" + tailPt.getX() + "," + tailPt.getY() + ") in " + parent + " because the 'to' port (" + tailProto.getName() + " on node " + tailPort.getNodeInst().describe(false) + ") does not connect to " + protoType);
            return null;
        }
        if (nameDescriptor == null) {
            throw new NullPointerException();
        }
        Name name2 = nameKey = name != null ? Name.findName(name) : null;
        if (nameKey == null || ArcInst.checkNameKey(nameKey, topology) || nameKey.isBus() && protoType != Schematics.tech().bus_arc) {
            nameKey = topology.getArcAutoname();
        }
        TechPool techPool = parent.getTechPool();
        if (!(tailProto.getId() instanceof PrimitivePortId) || !techPool.getPrimitivePort((PrimitivePortId)tailProto.getId()).isNegatable()) {
            flags = ImmutableArcInst.TAIL_NEGATED.set(flags, false);
        }
        if (!(headProto.getId() instanceof PrimitivePortId) || !techPool.getPrimitivePort((PrimitivePortId)headProto.getId()).isNegatable()) {
            flags = ImmutableArcInst.HEAD_NEGATED.set(flags, false);
        }
        if (protoType.getTechnology().isNoNegatedArcs()) {
            flags = ImmutableArcInst.TAIL_NEGATED.set(flags, false);
            flags = ImmutableArcInst.HEAD_NEGATED.set(flags, false);
        }
        if (angle < 0 && tailPt.equals(headPt)) {
            PrimitivePort hPort = headPort.getPortProto().getBasePort();
            PrimitivePort tPort = tailPort.getPortProto().getBasePort();
            if (hPort.getAngleRange() == 0) {
                ni = headPort.getNodeInst();
                nodeAngle = ni.getAngle();
                if (ni.isYMirrored()) {
                    nodeAngle = (3600 - nodeAngle) % 3600;
                }
                if (ni.isXMirrored()) {
                    nodeAngle = (1800 - nodeAngle + 3600) % 3600;
                }
                angle = (3600 - hPort.getAngle() * 10 + nodeAngle) % 3600;
            } else if (tPort.getAngleRange() == 0) {
                ni = tailPort.getNodeInst();
                nodeAngle = ni.getAngle();
                if (ni.isYMirrored()) {
                    nodeAngle = (3600 - nodeAngle) % 3600;
                }
                if (ni.isXMirrored()) {
                    nodeAngle = (1800 - nodeAngle + 3600) % 3600;
                }
                angle = (tPort.getAngle() * 10 + nodeAngle) % 3600;
            }
        }
        CellId parentId = parent.getId();
        while (parent.getArcById(arcId = parentId.newArcId()) != null) {
        }
        ImmutableArcInst d = ImmutableArcInst.newInst(arcId, protoType.getId(), nameKey, nameDescriptor, tailPort.getNodeInst().getNodeId(), tailProto.getId(), tailPt, headPort.getNodeInst().getNodeId(), headProto.getId(), headPt, gridExtendOverMin, angle, flags);
        ArcInst ai = new ArcInst(topology, d, headPort, tailPort);
        headPort.getNodeInst().redoGeometric();
        tailPort.getNodeInst().redoGeometric();
        topology.addArc(ai);
        Constraints.getCurrent().newObject(ai);
        return ai;
    }

    public void kill() {
        if (!this.isLinked()) {
            System.out.println("ArcInst already killed");
            return;
        }
        this.checkChanging();
        this.headPortInst.getNodeInst().redoGeometric();
        this.tailPortInst.getNodeInst().redoGeometric();
        this.topology.removeArc(this);
        Constraints.getCurrent().killObject(this);
    }

    public void modify(double dHeadX, double dHeadY, double dTailX, double dTailY) {
        ImmutableArcInst oldD = this.d;
        EPoint tail = this.d.tailLocation;
        if (dTailX != 0.0 || dTailY != 0.0) {
            tail = EPoint.fromLambda(tail.getX() + dTailX, tail.getY() + dTailY);
        }
        EPoint head = this.d.headLocation;
        if (dHeadX != 0.0 || dHeadY != 0.0) {
            head = EPoint.fromLambda(head.getX() + dHeadX, head.getY() + dHeadY);
        }
        this.lowLevelModify(this.d.withLocations(tail, head));
        Constraints.getCurrent().modifyArcInst(this, oldD);
    }

    public void setLambdaBaseWidth(double lambdaBaseWidth) {
        this.setGridBaseWidth(DBMath.lambdaToSizeGrid(lambdaBaseWidth));
    }

    public void setGridBaseWidth(long gridBaseWidth) {
        if (gridBaseWidth == this.getGridBaseWidth()) {
            return;
        }
        ImmutableArcInst oldD = this.d;
        this.lowLevelModify(this.d.withGridExtendOverMin(gridBaseWidth / 2L - this.getProto().getBaseExtend().getGrid()));
        Constraints.getCurrent().modifyArcInst(this, oldD);
    }

    public ArcInst replace(ArcProto ap, EditingPreferences ep) {
        if (!this.headPortInst.getPortProto().connectsTo(ap) || !this.tailPortInst.getPortProto().connectsTo(ap)) {
            System.out.println("Cannot replace " + this + " with one of type " + ap.getName() + " because the nodes cannot connect to it");
            return null;
        }
        ArcInst newar = ArcInst.newInstanceBase(ap, ep, this.getLambdaBaseWidth(), this.headPortInst, this.tailPortInst, this.d.headLocation, this.d.tailLocation, null, -1);
        if (newar == null) {
            System.out.println("Cannot replace " + this + " with one of type " + ap.getName() + " because the new arc failed to create");
            return null;
        }
        newar.copyPropertiesFrom(this);
        this.kill();
        newar.setName(this.getName(), ep);
        return newar;
    }

    @Override
    public ImmutableArcInst getD() {
        return this.d;
    }

    public boolean setD(ImmutableArcInst newD, boolean notify) {
        this.checkChanging();
        ImmutableArcInst oldD = this.d;
        if (newD == oldD) {
            return false;
        }
        this.topology.cell.setTopologyModified();
        this.d = newD;
        if (notify) {
            Constraints.getCurrent().modifyArcInst(this, oldD);
        }
        return true;
    }

    public void setDInUndo(ImmutableArcInst newD) {
        this.checkUndoing();
        this.d = newD;
    }

    @Override
    public void addVar(Variable var) {
        if (this.setD(this.d.withVariable(var), true)) {
            this.checkPossibleVariableEffects(var.getKey());
        }
    }

    public void checkPossibleVariableEffects(Variable.Key key) {
        if (key == ImmutableArcInst.ARC_RADIUS) {
            this.lowLevelModify(this.d);
        }
    }

    @Override
    public void delVar(Variable.Key key) {
        this.setD(this.d.withoutVariable(key), true);
    }

    public void copyVarsFrom(ArcInst other) {
        this.checkChanging();
        Iterator<Variable> it = other.getVariables();
        while (it.hasNext()) {
            this.addVar(it.next());
        }
    }

    public void lowLevelModify(ImmutableArcInst d) {
        boolean renamed;
        boolean bl = renamed = this.d.name != d.name;
        if (renamed) {
            this.topology.removeArc(this);
        }
        this.setD(d, false);
        if (renamed) {
            this.topology.addArc(this);
        }
        this.topology.setArcsDirty();
    }

    public long getGridFullWidth() {
        return 2L * (this.d.getGridExtendOverMin() + this.getProto().getMaxLayerExtend().getGrid());
    }

    public double getLambdaBaseWidth() {
        return DBMath.gridToLambda(this.getGridBaseWidth());
    }

    public long getGridBaseWidth() {
        return 2L * (this.d.getGridExtendOverMin() + this.getProto().getBaseExtend().getGrid());
    }

    public double getLambdaLength() {
        return this.d.getLambdaLength();
    }

    public double getGridLength() {
        return this.d.getGridLength();
    }

    public boolean isZeroLength() {
        return this.d.isZeroLength();
    }

    public int getAngle() {
        return this.d.getAngle();
    }

    public int getDefinedAngle() {
        int angle = this.d.getAngle();
        if (angle == -1) {
            return 0;
        }
        return angle;
    }

    public void setAngle(int angle) {
        this.checkChanging();
        ImmutableArcInst oldD = this.d;
        this.lowLevelModify(this.d.withAngle(angle));
        assert (this.topology != null);
        Constraints.getCurrent().modifyArcInst(this, oldD);
    }

    @Override
    public Iterator<Poly> getShape(Poly.Builder polyBuilder) {
        return polyBuilder.getShape(this);
    }

    @Override
    public ERectangle getBounds() {
        if (!this.topology.validArcBounds) {
            this.topology.computeArcBounds();
        }
        assert (this.visBounds != null);
        return this.visBounds;
    }

    void computeBounds(BoundsBuilder b, long[] gridCoords) {
        if (b.genBoundsEasy(this.d, gridCoords)) {
            long gridMinX = gridCoords[0];
            long gridMinY = gridCoords[1];
            long gridMaxX = gridCoords[2];
            long gridMaxY = gridCoords[3];
            if (this.visBounds != null && gridMinX == this.visBounds.getGridMinX() && gridMinY == this.visBounds.getGridMinY() && gridMaxX == this.visBounds.getGridMaxX() && gridMaxY == this.visBounds.getGridMaxY()) {
                return;
            }
            this.visBounds = ERectangle.fromGrid(gridMinX, gridMinY, gridMaxX - gridMinX, gridMaxY - gridMinY);
        } else {
            b.clear();
            b.genShapeOfArc(this.d);
            this.visBounds = b.makeBounds(null, this.visBounds);
        }
    }

    public Poly makeLambdaPoly(long gridWidth, Poly.Type style) {
        Poly.Builder polyBuilder = Poly.threadLocalLambdaBuilder();
        polyBuilder.setup(this.topology.cell);
        return polyBuilder.makePoly(this.getD(), gridWidth, style);
    }

    public Poly curvedArcLambdaOutline(Poly.Type style, long gridWidth, long gridRadius) {
        Poly.Builder polyBuilder = Poly.threadLocalLambdaBuilder();
        polyBuilder.setup(this.topology.cell);
        Variable radius = Variable.newInst(ImmutableArcInst.ARC_RADIUS, DBMath.gridToLambda(gridRadius), TextDescriptor.EMPTY);
        return polyBuilder.makePoly(this.getD().withVariable(radius), gridWidth, style);
    }

    @Override
    public void addDisplayableVariables(Rectangle2D rect, List<Poly> polys, EditWindow0 wnd, boolean multipleStrings, boolean showTempNames) {
        if (this.isUsernamed() && this.d.nameDescriptor.isDisplay()) {
            double cX = rect.getCenterX();
            double cY = rect.getCenterY();
            TextDescriptor td = this.d.nameDescriptor;
            double offX = td.getXOff();
            double offY = td.getYOff();
            AbstractTextDescriptor.Position pos = td.getPos();
            Poly.Type style = pos.getPolyType();
            PolyBase.Point[] pointList = style == Poly.Type.TEXTBOX ? Poly.makePoints(rect) : new PolyBase.Point[]{Poly.fromLambda(cX + offX, cY + offY)};
            Poly poly = new Poly(pointList);
            poly.setStyle(style);
            poly.setString(this.getNameKey().toString());
            poly.setTextDescriptor(td);
            poly.setLayer(null);
            poly.setDisplayedText(new DisplayedText(this, ARC_NAME));
            polys.add(poly);
        }
        super.addDisplayableVariables(rect, polys, wnd, multipleStrings, false);
    }

    public Poly[] getDisplayableVariables(EditWindow0 wnd, boolean showTempNames) {
        return this.getDisplayableVariables(this.getBounds(), wnd, true, false);
    }

    public TailConnection getTail() {
        return new TailConnection(this);
    }

    public HeadConnection getHead() {
        return new HeadConnection(this);
    }

    public Connection getConnection(int connIndex) {
        switch (connIndex) {
            case 0: {
                return new TailConnection(this);
            }
            case 1: {
                return new HeadConnection(this);
            }
        }
        throw new IllegalArgumentException("Bad end " + connIndex);
    }

    public PortInst getTailPortInst() {
        return this.tailPortInst;
    }

    public PortInst getHeadPortInst() {
        return this.headPortInst;
    }

    @Override
    public boolean isConnected(Geometric geom) {
        return this.tailPortInst.getNodeInst() == geom || this.headPortInst.getNodeInst() == geom;
    }

    public PortInst getPortInst(int connIndex) {
        switch (connIndex) {
            case 0: {
                return this.tailPortInst;
            }
            case 1: {
                return this.headPortInst;
            }
        }
        throw new IllegalArgumentException("Bad end " + connIndex);
    }

    public EPoint getTailLocation() {
        return this.d.tailLocation;
    }

    public EPoint getHeadLocation() {
        return this.d.headLocation;
    }

    public EPoint getLocation(int connIndex) {
        switch (connIndex) {
            case 0: {
                return this.d.tailLocation;
            }
            case 1: {
                return this.d.headLocation;
            }
        }
        throw new IllegalArgumentException("Bad end " + connIndex);
    }

    public boolean tailStillInPort(Point2D pt, boolean reduceForArc) {
        return this.stillInPort(0, pt, reduceForArc);
    }

    public boolean headStillInPort(Point2D pt, boolean reduceForArc) {
        return this.stillInPort(1, pt, reduceForArc);
    }

    public boolean stillInPort(int connIndex, Point2D pt, boolean reduceForArc) {
        PortInst pi = this.getPortInst(connIndex);
        Poly poly = pi.getPoly();
        if (reduceForArc) {
            double wid = this.getLambdaBaseWidth();
            poly.reducePortPoly(pi, wid, this.getAngle());
        }
        return ArcInst.stillInPoly(pt, poly);
    }

    private static boolean stillInPoly(Point2D pt, Poly poly) {
        return poly.isInside(pt) || poly.polyDistance(pt.getX(), pt.getY()) < MINPORTDISTANCE;
    }

    public String getName() {
        return this.d.name.toString();
    }

    public boolean isUsernamed() {
        return this.d.isUsernamed();
    }

    public Name getNameKey() {
        return this.d.name;
    }

    public boolean setName(String name, EditingPreferences ep) {
        Name key;
        assert (this.isLinked());
        boolean doSmart = false;
        if (name != null && name.length() > 0) {
            if (name.equals(this.getName())) {
                return false;
            }
            if (!this.isUsernamed()) {
                doSmart = true;
            }
            key = Name.findName(name);
        } else {
            if (!this.isUsernamed()) {
                return false;
            }
            key = this.topology.getArcAutoname();
        }
        if (ArcInst.checkNameKey(key, this.topology) || key.isBus() && this.getProto() != Schematics.tech().bus_arc) {
            return true;
        }
        ImmutableArcInst oldD = this.d;
        this.lowLevelModify(this.d.withName(key));
        if (doSmart) {
            TextDescriptor td = ep.getArcTextDescriptor();
            TextDescriptor smartDescriptor = ArcInst.getSmartTextDescriptor(this.getAngle(), this.getLambdaBaseWidth(), td, ep);
            this.setTextDescriptor(ARC_NAME, smartDescriptor);
        }
        Constraints.getCurrent().modifyArcInst(this, oldD);
        return false;
    }

    private static TextDescriptor getSmartTextDescriptor(int angle, double width, TextDescriptor prev, EditingPreferences ep) {
        if (angle == -1) {
            angle = 0;
        }
        if (angle % 1800 == 0) {
            int smart = ep.getSmartHorizontalPlacementArc();
            if (smart == 1) {
                return prev.withPos(AbstractTextDescriptor.Position.UP).withOff(0.0, width / 2.0);
            }
            if (smart == 2) {
                return prev.withPos(AbstractTextDescriptor.Position.DOWN).withOff(0.0, -width / 2.0);
            }
        } else if (angle % 1800 == 900) {
            int smart = ep.getSmartVerticalPlacementArc();
            if (smart == 1) {
                return prev.withPos(AbstractTextDescriptor.Position.LEFT).withOff(-width / 2.0, 0.0);
            }
            if (smart == 2) {
                return prev.withPos(AbstractTextDescriptor.Position.RIGHT).withOff(width / 2.0, 0.0);
            }
        }
        return prev;
    }

    private static boolean checkNameKey(Name name, Topology topology) {
        Cell parent = topology.cell;
        if (!name.isValid()) {
            System.out.println(parent + ": Invalid name \"" + name + "\" wasn't assigned to arc :" + Name.checkName(name.toString()));
            return true;
        }
        if (name.isBus()) {
            if (name.isTempname()) {
                System.out.println(parent + ": Temporary name \"" + name + "\" can't be bus");
                return true;
            }
            if (!parent.busNamesAllowed()) {
                System.out.println(parent + ": Bus name \"" + name + "\" can be in icons and schematics only");
                return true;
            }
        }
        if (name.isTempname() && name.getBasename() != ImmutableArcInst.BASENAME) {
            System.out.println(parent + ": Temporary arc name \"" + name + "\" must have prefix net@");
            return true;
        }
        if (name.hasEmptySubnames()) {
            if (name.isBus()) {
                System.out.println(parent + ": Name \"" + name + "\" with empty subnames wasn't assigned to arc");
            } else {
                System.out.println(parent + ": Cannot assign empty name \"" + name + "\" to arc");
            }
            return true;
        }
        if (topology.hasTempArcName(name)) {
            System.out.println(parent + " already has ArcInst with temporary name \"" + name + "\"");
            return true;
        }
        return false;
    }

    @Override
    public TextDescriptor getTextDescriptor(Variable.Key varKey) {
        if (varKey == ARC_NAME) {
            return this.d.nameDescriptor;
        }
        return super.getTextDescriptor(varKey);
    }

    @Override
    public void setTextDescriptor(Variable.Key varKey, TextDescriptor td) {
        if (varKey == ARC_NAME) {
            this.setD(this.d.withNameDescriptor(td), true);
            return;
        }
        super.setTextDescriptor(varKey, td);
    }

    @Override
    public boolean isDeprecatedVariable(Variable.Key key) {
        if (key == ARC_NAME) {
            return true;
        }
        return super.isDeprecatedVariable(key);
    }

    @Override
    public String describe(boolean withQuotes) {
        Object name;
        Object description = this.getProto().describe();
        Object object = name = withQuotes ? "'" + this.getName() + "'" : this.getName();
        if (name != null) {
            description = (String)description + "[" + (String)name + "]";
        }
        return description;
    }

    public String libDescribe() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getProto().getFullName());
        sb.append('[');
        sb.append(this.getName());
        sb.append(']');
        return sb.toString();
    }

    public String noLibDescribe() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getProto().getName());
        sb.append('[');
        sb.append(this.getName());
        sb.append(']');
        return sb.toString();
    }

    @Override
    public int compareTo(ArcInst that) {
        int cmp;
        if (this.topology != that.topology && (cmp = this.topology.cell.compareTo(that.topology.cell)) != 0) {
            return cmp;
        }
        cmp = this.getName().compareTo(that.getName());
        if (cmp != 0) {
            return cmp;
        }
        return this.d.arcId - that.d.arcId;
    }

    @Override
    public String toString() {
        return "arc " + this.describe(true);
    }

    private void setFlag(ImmutableArcInst.Flag flag, boolean state) {
        this.checkChanging();
        if (this.setD(this.d.withFlag(flag, state), true)) {
            this.topology.setArcsDirty();
        }
    }

    public void setRigid(boolean state) {
        this.setFlag(ImmutableArcInst.RIGID, state);
    }

    public boolean isRigid() {
        return this.d.isRigid();
    }

    public void setFixedAngle(boolean state) {
        this.setFlag(ImmutableArcInst.FIXED_ANGLE, state);
    }

    public boolean isFixedAngle() {
        return this.d.isFixedAngle();
    }

    public void setSlidable(boolean state) {
        this.setFlag(ImmutableArcInst.SLIDABLE, state);
    }

    public boolean isSlidable() {
        return this.d.isSlidable();
    }

    public boolean isArrowed(int connIndex) {
        return this.d.isArrowed(connIndex);
    }

    public boolean isTailArrowed() {
        return this.d.isTailArrowed();
    }

    public boolean isHeadArrowed() {
        return this.d.isHeadArrowed();
    }

    public boolean isBodyArrowed() {
        return this.d.isBodyArrowed();
    }

    public void setArrowed(int connIndex, boolean state) {
        switch (connIndex) {
            case 0: {
                this.setTailArrowed(state);
                break;
            }
            case 1: {
                this.setHeadArrowed(state);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad end " + connIndex);
            }
        }
    }

    public void setTailArrowed(boolean state) {
        this.setFlag(ImmutableArcInst.TAIL_ARROWED, state);
    }

    public void setHeadArrowed(boolean state) {
        this.setFlag(ImmutableArcInst.HEAD_ARROWED, state);
    }

    public void setBodyArrowed(boolean state) {
        this.setFlag(ImmutableArcInst.BODY_ARROWED, state);
    }

    public boolean isExtended(int connIndex) {
        return this.d.isExtended(connIndex);
    }

    public boolean isTailExtended() {
        return this.d.isTailExtended();
    }

    public boolean isHeadExtended() {
        return this.d.isHeadExtended();
    }

    public void setExtended(int connIndex, boolean e) {
        switch (connIndex) {
            case 0: {
                this.setTailExtended(e);
                break;
            }
            case 1: {
                this.setHeadExtended(e);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad end " + connIndex);
            }
        }
    }

    public void setTailExtended(boolean e) {
        this.setFlag(ImmutableArcInst.TAIL_EXTENDED, e);
    }

    public void setHeadExtended(boolean e) {
        this.setFlag(ImmutableArcInst.HEAD_EXTENDED, e);
    }

    public boolean isNegated(int connIndex) {
        return this.d.isNegated(connIndex);
    }

    public boolean isTailNegated() {
        return this.d.isTailNegated();
    }

    public boolean isHeadNegated() {
        return this.d.isHeadNegated();
    }

    public void setNegated(int connIndex, boolean n) {
        switch (connIndex) {
            case 0: {
                this.setTailNegated(n);
                break;
            }
            case 1: {
                this.setHeadNegated(n);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad end " + connIndex);
            }
        }
    }

    public void setTailNegated(boolean n) {
        if (!(this.d.tailPortId instanceof PrimitivePortId) || !this.getTechPool().getPrimitivePort((PrimitivePortId)this.d.tailPortId).isNegatable()) {
            n = false;
        }
        if (this.getProto().getTechnology().isNoNegatedArcs()) {
            n = false;
        }
        this.setFlag(ImmutableArcInst.TAIL_NEGATED, n);
    }

    public void setHeadNegated(boolean n) {
        if (!(this.d.headPortId instanceof PrimitivePortId) || !this.getTechPool().getPrimitivePort((PrimitivePortId)this.d.headPortId).isNegatable()) {
            n = false;
        }
        if (this.getProto().getTechnology().isNoNegatedArcs()) {
            n = false;
        }
        this.setFlag(ImmutableArcInst.HEAD_NEGATED, n);
    }

    public int checkAndRepair(boolean repair, List<Geometric> list, ErrorLogger errorLogger) {
        ArrayList<Object> errorList;
        String msg;
        Poly poly;
        int errorCount = 0;
        ArcProto ap = this.getProto();
        Cell parent = this.topology.cell;
        if (ap.isNotUsed()) {
            if (errorLogger != null) {
                String msg2 = "Prototype of arc " + this.getName() + " is unused";
                if (repair) {
                    Poly poly2 = this.makeLambdaPoly(this.getGridBaseWidth(), Poly.Type.CLOSED);
                    errorLogger.logError(msg2, poly2, parent, 1);
                } else {
                    errorLogger.logError(msg2, this, parent, null, 1);
                }
            }
            if (repair) {
                list.add(this);
            }
            return 1;
        }
        if (!this.headStillInPort(this.d.headLocation, false)) {
            poly = this.headPortInst.getPoly();
            msg = parent + ", " + this + ": head not in port, is at (" + this.d.headLocation.getX() + "," + this.d.headLocation.getY() + ") distance to port is " + TextUtils.formatDistance(poly.polyDistance(this.d.headLocation.getX(), this.d.headLocation.getY())) + " [port center is (" + poly.getCenterX() + "," + poly.getCenterY() + ")";
            if (DBMath.areEquals(this.d.headLocation.getX(), poly.getCenterX()) && DBMath.areEquals(this.d.headLocation.getY(), poly.getCenterY())) {
                msg = msg + " but it may be irregular in shape...has " + poly.getPoints().length + " points";
            }
            msg = msg + "]";
            System.out.println(msg);
            if (errorLogger != null) {
                errorList = new ArrayList<Object>(2);
                errorList.add(this.headPortInst.getNodeInst());
                errorList.add(this.makeLambdaPoly(this.getGridBaseWidth(), Poly.Type.CLOSED));
                if (repair) {
                    errorLogger.logMessage(msg, errorList, parent, 1, true);
                } else {
                    ArrayList<Geometric> geomList = new ArrayList<Geometric>();
                    geomList.add(this);
                    geomList.add(this.headPortInst.getNodeInst());
                    errorLogger.logMessage(msg, geomList, parent, 1, true);
                }
            }
            if (repair) {
                Constraints.getCurrent().modifyArcInst(this, this.getD());
            }
            ++errorCount;
        }
        if (!this.tailStillInPort(this.d.tailLocation, false)) {
            poly = this.tailPortInst.getPoly();
            msg = parent + ", " + this + ": tail not in port, is at (" + this.d.tailLocation.getX() + "," + this.d.tailLocation.getY() + ") distance to port is " + TextUtils.formatDistance(poly.polyDistance(this.d.tailLocation.getX(), this.d.tailLocation.getY())) + " [port center is (" + poly.getCenterX() + "," + poly.getCenterY() + ")";
            if (DBMath.areEquals(this.d.tailLocation.getX(), poly.getCenterX()) && DBMath.areEquals(this.d.tailLocation.getY(), poly.getCenterY())) {
                msg = msg + " but it may be irregular in shape...has " + poly.getPoints().length + " points";
            }
            msg = msg + "]";
            System.out.println(msg);
            if (errorLogger != null) {
                if (repair) {
                    errorList = new ArrayList(2);
                    errorList.add(this.tailPortInst.getNodeInst());
                    errorList.add(this.makeLambdaPoly(this.getGridBaseWidth(), Poly.Type.CLOSED));
                    errorLogger.logMessage(msg, errorList, parent, 1, true);
                } else {
                    ArrayList<Geometric> geomList = new ArrayList<Geometric>();
                    geomList.add(this);
                    geomList.add(this.tailPortInst.getNodeInst());
                    errorLogger.logMessage(msg, geomList, parent, 1, true);
                }
            }
            if (repair) {
                Constraints.getCurrent().modifyArcInst(this, this.getD());
            }
            ++errorCount;
        }
        return errorCount;
    }

    public void check(BoundsBuilder b) {
        b.clear();
        b.genShapeOfArc(this.d);
        assert (b.makeBounds(null, this.visBounds) == this.visBounds);
    }

    public final int getArcId() {
        return this.d.arcId;
    }

    @Override
    public boolean isLinked() {
        try {
            Cell parent = this.topology.cell;
            return parent.isLinked() && parent.getArcById(this.getArcId()) == this;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    @Override
    public Topology getTopology() {
        return this.topology;
    }

    @Override
    public void checkChanging() {
        this.topology.cell.checkChanging();
    }

    @Override
    public Cell whichCell() {
        return this.topology.cell;
    }

    @Override
    public EDatabase getDatabase() {
        return this.topology.cell.getDatabase();
    }

    public ArcProto getProto() {
        return this.getTechPool().getArcProto(this.d.protoId);
    }

    public void copyPropertiesFrom(ArcInst fromAi) {
        if (fromAi == null) {
            return;
        }
        this.copyVarsFrom(fromAi);
        this.copyConstraintsFrom(fromAi);
        this.copyTextDescriptorFrom(fromAi, ARC_NAME);
    }

    public void copyConstraintsFrom(ArcInst fromAi) {
        this.checkChanging();
        if (fromAi == null) {
            return;
        }
        ImmutableArcInst oldD = this.d;
        int flags = fromAi.d.flags;
        if (!(this.d.tailPortId instanceof PrimitivePortId) || !this.getTechPool().getPrimitivePort((PrimitivePortId)this.d.tailPortId).isNegatable()) {
            flags = ImmutableArcInst.TAIL_NEGATED.set(flags, false);
        }
        if (!(this.d.headPortId instanceof PrimitivePortId) || !this.getTechPool().getPrimitivePort((PrimitivePortId)this.d.headPortId).isNegatable()) {
            flags = ImmutableArcInst.HEAD_NEGATED.set(flags, false);
        }
        if (this.getProto().getTechnology().isNoNegatedArcs()) {
            flags = ImmutableArcInst.TAIL_NEGATED.set(flags, false);
            flags = ImmutableArcInst.HEAD_NEGATED.set(flags, false);
        }
        this.lowLevelModify(this.d.withFlags(flags).withAngle(fromAi.getAngle()));
        assert (this.topology != null);
        Constraints.getCurrent().modifyArcInst(this, oldD);
    }

    public void setHardSelect(boolean state) {
        this.setFlag(ImmutableArcInst.HARD_SELECT, state);
    }

    public boolean isHardSelect() {
        return this.d.isHardSelect();
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        Poly[] aPolyList;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArcInst a = (ArcInst)obj;
        if (this.getProto().getClass() != a.getProto().getClass()) {
            return false;
        }
        ArcProto arcType = a.getProto();
        Technology tech = arcType.getTechnology();
        if (this.getProto().getTechnology() != tech) {
            if (buffer != null) {
                buffer.append("No same technology for arcs " + this.getName() + " and " + a.getName() + "\n");
            }
            return false;
        }
        Poly[] polyList = this.getProto().getTechnology().getShapeOfArc(this);
        if (polyList.length != (aPolyList = tech.getShapeOfArc(a)).length) {
            if (buffer != null) {
                buffer.append("No same number of geometries in " + this.getName() + " and " + a.getName() + "\n");
            }
            return false;
        }
        ArrayList<Poly> noCheckAgain = new ArrayList<Poly>();
        for (int i = 0; i < polyList.length; ++i) {
            boolean found = false;
            for (int j = 0; j < aPolyList.length; ++j) {
                if (noCheckAgain.contains(aPolyList[j]) || !polyList[i].compare(aPolyList[j], buffer)) continue;
                found = true;
                noCheckAgain.add(aPolyList[j]);
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public Poly cropPerLayer(Poly poly) {
        Rectangle2D polyBounds = poly.getBox();
        if (polyBounds == null) {
            return poly;
        }
        polyBounds = new Rectangle2D.Double(((RectangularShape)polyBounds).getMinX(), ((RectangularShape)polyBounds).getMinY(), ((RectangularShape)polyBounds).getWidth(), ((RectangularShape)polyBounds).getHeight());
        for (int i = 0; i < 2; ++i) {
            PortInst pi = this.getPortInst(i);
            NodeInst ni = pi.getNodeInst();
            FixpTransform trans = ni.rotateOut();
            Technology tech = ni.getProto().getTechnology();
            for (Poly nPoly : tech.getShapeOfNode(ni)) {
                if (nPoly.getLayer() != poly.getLayer()) continue;
                nPoly.transform(trans);
                FixpRectangle nPolyBounds = nPoly.getBox();
                if (nPolyBounds == null) continue;
                int result = Poly.cropBoxComplete(polyBounds, nPolyBounds);
                if (result == 1) {
                    return null;
                }
                if (result == -2) {
                    System.out.println("When is this case?");
                }
                Poly newPoly = new Poly(polyBounds);
                newPoly.setLayer(poly.getLayer());
                newPoly.setStyle(poly.getStyle());
                return newPoly;
            }
        }
        return poly;
    }

    public boolean isDiffusionArc() {
        return this.getProto().getFunction().isDiffusion();
    }

    private static class ArcInstKey
    extends EObjectInputStream.Key<ArcInst> {
        public ArcInstKey() {
        }

        private ArcInstKey(ArcInst ai) {
            super(ai);
        }

        @Override
        public void writeExternal(EObjectOutputStream out, ArcInst ai) throws IOException {
            if (ai.getDatabase() != out.getDatabase() || !ai.isLinked()) {
                throw new NotSerializableException(ai + " not linked");
            }
            out.writeObject(ai.topology.cell);
            out.writeInt(ai.getArcId());
        }

        @Override
        public ArcInst readExternal(EObjectInputStream in) throws IOException, ClassNotFoundException {
            int arcId;
            Cell cell = (Cell)in.readObject();
            ArcInst ai = cell.getArcById(arcId = in.readInt());
            if (ai == null) {
                throw new InvalidObjectException("ArcInst from " + cell);
            }
            return ai;
        }
    }

    public static class ArcsByLength
    implements Comparator<ArcInst> {
        @Override
        public int compare(ArcInst a1, ArcInst a2) {
            double len2;
            double len1 = a1.getHeadLocation().distance(a1.getTailLocation());
            if (len1 == (len2 = a2.getHeadLocation().distance(a2.getTailLocation()))) {
                return 0;
            }
            if (len1 < len2) {
                return 1;
            }
            return -1;
        }
    }
}

