/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import gnu.mapping.Printable;
import java.io.PrintWriter;

public abstract class Expression
implements Printable {
    String filename;
    int position;
    public static final Expression[] noExpressions = new Expression[0];
    protected int flags;
    protected static final int NEXT_AVAIL_FLAG = 1;

    public Object eval(Environment environment) throws Throwable {
        throw new RuntimeException("internal error - " + this.getClass() + ".eval called");
    }

    public void eval(Environment environment, CallContext callContext) throws Throwable {
        Object object2 = this.eval(environment);
        callContext.writeValue(object2);
    }

    public final void print(PrintWriter printWriter) {
        if (printWriter instanceof OutPort) {
            this.print((OutPort)printWriter);
        } else {
            OutPort outPort = new OutPort(printWriter);
            this.print(outPort);
            outPort.flush();
        }
    }

    public abstract void print(OutPort var1);

    public void printLineColumn(OutPort outPort) {
        int n = this.getLine();
        if (n > 0) {
            outPort.print("line:");
            outPort.print(n);
            int n2 = this.getColumn();
            if (n2 != 0) {
                outPort.print(':');
                outPort.print(n2);
            }
            outPort.writeSpaceFill();
        }
    }

    public abstract void compile(Compilation var1, Target var2);

    public final void compileWithPosition(Compilation compilation, Target target) {
        int n = this.getLine();
        if (n > 0) {
            compilation.method.compile_linenumber(n);
            this.compileNotePosition(compilation, target, this);
        } else {
            this.compile(compilation, target);
        }
    }

    public final void compileWithPosition(Compilation compilation, Target target, Expression expression) {
        int n = expression.getLine();
        if (n > 0) {
            compilation.method.compile_linenumber(n);
            this.compileNotePosition(compilation, target, expression);
        } else {
            this.compile(compilation, target);
        }
    }

    public final void compileNotePosition(Compilation compilation, Target target, Expression expression) {
        String string = compilation.getFile();
        int n = compilation.getLine();
        int n2 = compilation.getColumn();
        compilation.setLine(expression.filename, expression.getLine(), expression.getColumn());
        this.compile(compilation, target);
        compilation.setLine(string, n, n2);
    }

    public final void compile(Compilation compilation, Type type) {
        this.compile(compilation, StackTarget.getInstance(type));
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkExpression(this);
    }

    protected void walkChildren(ExpWalker expWalker) {
    }

    public static Expression makeWhile(Object object2, Object object3, Compilation compilation) {
        Expression[] expressionArray = new Expression[1];
        LetExp letExp = new LetExp(expressionArray);
        String string = "%do%loop";
        Declaration declaration = letExp.addDeclaration(string);
        ApplyExp applyExp = new ApplyExp(new ReferenceExp(declaration), noExpressions);
        LambdaExp lambdaExp = new LambdaExp();
        compilation.push(lambdaExp);
        lambdaExp.body = new IfExp(compilation.parse(object2), new BeginExp(compilation.parse(object3), applyExp), QuoteExp.voidExp);
        lambdaExp.setName(string);
        compilation.pop(lambdaExp);
        expressionArray[0] = lambdaExp;
        declaration.noteValue(lambdaExp);
        letExp.setBody(new ApplyExp(new ReferenceExp(declaration), noExpressions));
        return letExp;
    }

    public final Expression setLine(Expression expression) {
        this.filename = expression.filename;
        this.position = expression.position;
        return this;
    }

    public final void setFile(String string) {
        this.filename = string;
    }

    public final void setLine(int n, int n2) {
        this.position = (n << 12) + n2;
    }

    public final void setLine(int n) {
        this.setLine(n, 0);
    }

    public final String getFile() {
        return this.filename;
    }

    public final int getLine() {
        return this.position >> 12;
    }

    public final int getColumn() {
        return this.position & 0xFFF;
    }

    public Type getType() {
        return Type.pointer_type;
    }

    public void setFlag(boolean bl, int n) {
        this.flags = bl ? (this.flags |= n) : (this.flags &= ~n);
    }

    public void setFlag(int n) {
        this.flags |= n;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean getFlag(int n) {
        return (this.flags & n) != 0;
    }
}

