/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.util;

import gnu.lists.Consumer;
import gnu.lists.FormatToConsumer;
import gnu.lists.PrintConsumer;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure1or2;
import gnu.mapping.Values;
import java.io.Writer;

public abstract class AbstractFormat
extends Procedure1or2
implements FormatToConsumer {
    protected void write(String string, Consumer consumer) {
        if (consumer instanceof OutPort) {
            ((OutPort)consumer).write(string);
        } else {
            consumer.writeChars(string);
        }
    }

    public void writeChar(int n, Consumer consumer) {
        consumer.writeChar(n);
    }

    public void writeBoolean(boolean bl, Consumer consumer) {
        this.write(bl ? "true" : "false", consumer);
    }

    public void beginGroup(String string, Object object2, Consumer consumer) {
        this.write("(", consumer);
        this.write(string, consumer);
    }

    public void endGroup(String string, Consumer consumer) {
        this.write(")", consumer);
    }

    public Object apply1(Object object2) {
        this.format(object2, OutPort.outDefault());
        return Values.empty;
    }

    public Object apply2(Object object2, Object object3) {
        this.format(object2, (Consumer)object3);
        return Values.empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void format(Object object2, Consumer consumer) {
        if (consumer instanceof OutPort) {
            OutPort outPort = (OutPort)consumer;
            FormatToConsumer formatToConsumer = outPort.objectFormat;
            try {
                outPort.objectFormat = this;
                consumer.writeObject(object2);
            }
            finally {
                outPort.objectFormat = formatToConsumer;
            }
        } else {
            consumer.writeObject(object2);
        }
    }

    public final void writeObject(Object object2, PrintConsumer printConsumer) {
        this.writeObject(object2, (Consumer)printConsumer);
    }

    public final void writeObject(Object object2, Writer writer) {
        if (writer instanceof Consumer) {
            this.writeObject(object2, (Consumer)((Object)writer));
        } else {
            OutPort outPort = new OutPort(writer, false, true, "<unknown>");
            this.writeObject(object2, (Consumer)((Object)writer));
            outPort.close();
        }
    }
}

