/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Interpreter;
import gnu.expr.Target;

public class ConditionalTarget
extends Target {
    public Label ifTrue;
    public Label ifFalse;
    Interpreter interpreter;
    public boolean trueBranchComesFirst = true;

    public ConditionalTarget(Label label, Label label2, Interpreter interpreter) {
        this.ifTrue = label;
        this.ifFalse = label2;
        this.interpreter = interpreter;
    }

    public Type getType() {
        return Type.boolean_type;
    }

    public void compileFromStack(Compilation compilation, Type type) {
        CodeAttr codeAttr = compilation.getCode();
        char c = type.getSignature().charAt(0);
        switch (c) {
            case 'J': {
                codeAttr.emitPushLong(0L);
                break;
            }
            case 'D': {
                codeAttr.emitPushDouble(0.0);
                break;
            }
            case 'F': {
                codeAttr.emitPushFloat(0.0f);
                break;
            }
            default: {
                if (this.trueBranchComesFirst) {
                    codeAttr.emitGotoIfIntEqZero(this.ifFalse);
                    codeAttr.emitGoto(this.ifTrue);
                } else {
                    codeAttr.emitGotoIfIntNeZero(this.ifTrue);
                    codeAttr.emitGoto(this.ifFalse);
                }
                return;
            }
            case 'L': 
            case '[': {
                compilation.compileConstant(this.interpreter == null ? Boolean.FALSE : this.interpreter.booleanObject(false));
            }
        }
        if (this.trueBranchComesFirst) {
            codeAttr.emitGotoIfEq(this.ifFalse);
        } else {
            codeAttr.emitGotoIfNE(this.ifTrue);
        }
        this.emitGotoFirstBranch(codeAttr);
    }

    public final void emitGotoFirstBranch(CodeAttr codeAttr) {
        codeAttr.emitGoto(this.trueBranchComesFirst ? this.ifTrue : this.ifFalse);
    }
}

