/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.util;

public class Util {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private Util() {
    }

    public static boolean areEqual(byte[] a, byte[] b) {
        if (a == null || b == null) {
            return false;
        }
        int aLength = a.length;
        if (aLength != b.length) {
            return false;
        }
        int i = 0;
        while (i < aLength) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String toString(byte[] ba) {
        return Util.toString(ba, 0, ba.length);
    }

    public static final String toString(byte[] ba, int offset, int length) {
        char[] buf = new char[length * 2];
        int i = 0;
        int j = 0;
        while (i < length) {
            byte k = ba[offset + i++];
            buf[j++] = HEX_DIGITS[k >>> 4 & 0xF];
            buf[j++] = HEX_DIGITS[k & 0xF];
        }
        return new String(buf);
    }

    public static byte[] toBytesFromString(String s) {
        int limit = s.length();
        byte[] result = new byte[(limit + 1) / 2];
        int i = 0;
        int j = 0;
        if (limit % 2 == 1) {
            result[j++] = (byte)Util.fromDigit(s.charAt(i++));
        }
        while (i < limit) {
            result[j++] = (byte)(Util.fromDigit(s.charAt(i++)) << 4 | Util.fromDigit(s.charAt(i++)));
        }
        return result;
    }

    public static int fromDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Invalid hexadecimal digit: " + c);
    }

    public static String toString(int n) {
        char[] buf = new char[8];
        int i = 7;
        while (i >= 0) {
            buf[i] = HEX_DIGITS[n & 0xF];
            n >>>= 4;
            --i;
        }
        return new String(buf);
    }

    public static String toString(int[] ia) {
        int length = ia.length;
        char[] buf = new char[length * 8];
        int i = 0;
        int j = 0;
        while (i < length) {
            int k = ia[i];
            buf[j++] = HEX_DIGITS[k >>> 28 & 0xF];
            buf[j++] = HEX_DIGITS[k >>> 24 & 0xF];
            buf[j++] = HEX_DIGITS[k >>> 20 & 0xF];
            buf[j++] = HEX_DIGITS[k >>> 16 & 0xF];
            buf[j++] = HEX_DIGITS[k >>> 12 & 0xF];
            buf[j++] = HEX_DIGITS[k >>> 8 & 0xF];
            buf[j++] = HEX_DIGITS[k >>> 4 & 0xF];
            buf[j++] = HEX_DIGITS[k & 0xF];
            ++i;
        }
        return new String(buf);
    }

    public static String toString(long n) {
        char[] b = new char[16];
        int i = 15;
        while (i >= 0) {
            b[i] = HEX_DIGITS[(int)(n & 0xFL)];
            n >>>= 4;
            --i;
        }
        return new String(b);
    }

    public static String toUnicodeString(byte[] ba) {
        return Util.toUnicodeString(ba, 0, ba.length);
    }

    public static final String toUnicodeString(byte[] ba, int offset, int length) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int j = 0;
        sb.append('\n').append("\"");
        while (i < length) {
            sb.append("\\u");
            byte k = ba[offset + i++];
            sb.append(HEX_DIGITS[k >>> 4 & 0xF]);
            sb.append(HEX_DIGITS[k & 0xF]);
            k = ba[offset + i++];
            sb.append(HEX_DIGITS[k >>> 4 & 0xF]);
            sb.append(HEX_DIGITS[k & 0xF]);
            if (++j % 8 != 0) continue;
            sb.append("\"+").append('\n').append("\"");
        }
        sb.append("\"").append('\n');
        return sb.toString();
    }

    public static String toUnicodeString(int[] ia) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int j = 0;
        sb.append('\n').append("\"");
        while (i < ia.length) {
            int k = ia[i++];
            sb.append("\\u");
            sb.append(HEX_DIGITS[k >>> 28 & 0xF]);
            sb.append(HEX_DIGITS[k >>> 24 & 0xF]);
            sb.append(HEX_DIGITS[k >>> 20 & 0xF]);
            sb.append(HEX_DIGITS[k >>> 16 & 0xF]);
            sb.append("\\u");
            sb.append(HEX_DIGITS[k >>> 12 & 0xF]);
            sb.append(HEX_DIGITS[k >>> 8 & 0xF]);
            sb.append(HEX_DIGITS[k >>> 4 & 0xF]);
            sb.append(HEX_DIGITS[k & 0xF]);
            if (++j % 4 != 0) continue;
            sb.append("\"+").append('\n').append("\"");
        }
        sb.append("\"").append('\n');
        return sb.toString();
    }

    public static byte[] toBytesFromUnicode(String s) {
        int limit = s.length() * 2;
        byte[] result = new byte[limit];
        int i = 0;
        while (i < limit) {
            char c = s.charAt(i >>> 1);
            result[i] = (i & 1) == 0 ? (byte)(c >>> 8) : (byte)c;
            ++i;
        }
        return result;
    }
}

