/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.prng;

import gnu.crypto.prng.ICMGenerator;
import gnu.crypto.prng.IRandom;
import gnu.crypto.prng.PRNGFactory;
import gnu.crypto.util.Util;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class TestOfICMGenerator
implements Testlet {
    private HashMap map = new HashMap();
    private byte[] key;
    private byte[] offset;
    private byte[] data;
    private ICMGenerator icm = new ICMGenerator();
    private IRandom rnd = PRNGFactory.getInstance((String)"icm");
    private String ks;
    private String computed;

    public void test(TestHarness harness) {
        harness.checkPoint("TestOfICMGenerator.testVectorOne");
        this.key = new byte[16];
        this.offset = new byte[16];
        int i = 0;
        while (i < 16) {
            this.key[i] = (byte)i;
            this.offset[i] = (byte)i;
            ++i;
        }
        this.map.clear();
        this.map.put("gnu.crypto.cipher.block.size", new Integer(16));
        this.map.put("gnu.crypto.cipher.key.material", this.key);
        this.map.put("gnu.crypto.prng.icm.segment.index.length", new Integer(4));
        this.map.put("gnu.crypto.prng.icm.offset", this.offset);
        this.map.put("gnu.crypto.prng.icm.segment.index", BigInteger.ZERO);
        this.data = new byte[16];
        try {
            this.icm.init((Map)this.map);
            this.ks = "0A940BB5416EF045F1C39458C653EA5A";
            this.icm.nextBytes(this.data, 0, 16);
            this.computed = Util.toString((byte[])this.data);
            harness.check(this.ks.equals(this.computed));
            this.ks = "0263EC94661872969ADAFD0F4BA40FDC";
            this.icm.nextBytes(this.data, 0, 16);
            this.computed = Util.toString((byte[])this.data);
            harness.check(this.ks.equals(this.computed));
            this.ks = "1A2D94B3111CA5F8BDC2C84DCC29EC47";
            this.icm.nextBytes(this.data, 0, 16);
            this.computed = Util.toString((byte[])this.data);
            harness.check(this.ks.equals(this.computed));
            this.ks = "4D0BABD2995F9F076223246847B5D30E";
            this.icm.nextBytes(this.data, 0, 16);
            this.computed = Util.toString((byte[])this.data);
            harness.check(this.ks.equals(this.computed));
            this.ks = "8D33F128463B88EFD3F8A52505020379";
            this.icm.nextBytes(this.data, 0, 16);
            this.computed = Util.toString((byte[])this.data);
            harness.check(this.ks.equals(this.computed));
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfICMGenerator.testVectorOne");
        }
        harness.checkPoint("TestOfICMGenerator.testVectorTwo");
        this.key = new byte[]{117, 56, 120, 36, -47, -15, -13, -127, 86, 65, -74, 93, 120, -43, 30, -37};
        this.offset = new byte[]{-106, -55, 120, 25, -127, 5, 60, -69, -53, 54, -110, 120, 68, -15, -109, 44};
        this.map.clear();
        this.map.put("gnu.crypto.cipher.block.size", new Integer(16));
        this.map.put("gnu.crypto.cipher.key.material", this.key);
        this.map.put("gnu.crypto.prng.icm.block.index.length", new Integer(2));
        this.map.put("gnu.crypto.prng.icm.offset", new BigInteger(1, this.offset));
        this.map.put("gnu.crypto.prng.icm.segment.index", new BigInteger("12345678", 16));
        this.data = new byte[16];
        try {
            this.rnd.init((Map)this.map);
            String ks = "EA0AA027BA6D56E44B28F43A7E3E5F58";
            this.rnd.nextBytes(this.data, 0, 16);
            String computed = Util.toString((byte[])this.data);
            harness.check(ks.equals(computed));
            ks = "CBDB3107EDA8D420D3EF7AB7FF290166";
            this.rnd.nextBytes(this.data, 0, 16);
            computed = Util.toString((byte[])this.data);
            harness.check(ks.equals(computed));
            ks = "AED6F7CB14ED49174336CC010AEB8780";
            this.rnd.nextBytes(this.data, 0, 16);
            computed = Util.toString((byte[])this.data);
            harness.check(ks.equals(computed));
            ks = "4C3A754AF027A5C8CCB40E0FE20AF246";
            this.rnd.nextBytes(this.data, 0, 16);
            computed = Util.toString((byte[])this.data);
            harness.check(ks.equals(computed));
            ks = "01A6D1CE983EF993E980CC9568587E3D";
            this.rnd.nextBytes(this.data, 0, 16);
            computed = Util.toString((byte[])this.data);
            harness.check(ks.equals(computed));
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfICMGenerator.testVectorTwo");
        }
    }
}

