//---------------------------------------------------------------------------
// GPGee - GNU Privacy Guard Explorer Extension
// GPGeePassPhrase.h - Passphrase dialog header
// Copyright 2005, Kurt Fitzner <kfitzner@excelcia.org>
//---------------------------------------------------------------------------
// This file is part of GPGee.
//
// GPGee is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License (Version 2) as
// published by the Free Software Foundation.
//
// GPGee is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------
#ifndef GPGeePassPhraseH
#define GPGeePassPhraseH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
//---------------------------------------------------------------------------
class TformGPGeePassPhrase : public TForm
{
__published:	// IDE-managed Components
  TPanel *pnlKeyId;
  TLabel *lblHeading;
  TLabel *lblUser;
  TEdit  *edtUser;
  TLabel *lblId;
  TEdit  *edtId;
  TLabel *lblType;
  TEdit  *edtType;
  TLabel *lblSize;
  TEdit  *edtSize;
  TLabel *lblDate;
  TEdit  *edtDate;
  TPanel *pnlPassPhrase;
  TLabel *lblPassphrase;
  TEdit  *edtPassphrase;
  TCheckBox *chbHideTyping;
  TButton *btnPPOk;
  TButton *btnPPCancel;
  TPanel *pnlSymmetric;
  TLabel *lblCaption;
  TPanel *pnlPIN;
  TLabel *lblPINHeading;
  TLabel *lblSerial;
  TEdit *edtSerial;

  void __fastcall FormShow(TObject *Sender);
  void __fastcall chbHideTypingClick(TObject *Sender);
  void __fastcall edtPassphraseChange(TObject *Sender);
private:	// User declarations
  void * MemoryLocked;
  AnsiString sKeyUser, sKeyId, sKeyType, sKeySize, sKeyCreationDate;
public:		// User declarations
  __fastcall TformGPGeePassPhrase(TComponent* Owner);
  __fastcall ~TformGPGeePassPhrase();
  int __fastcall GetPassphrase(AnsiString User, AnsiString Id, AnsiString Type, AnsiString Size, AnsiString Date);
  int __fastcall GetPassphrase(AnsiString Caption);
}; // class TformGPGeePassPhrase : public TForm
//---------------------------------------------------------------------------
extern PACKAGE TformGPGeePassPhrase *formGPGeePassPhrase;
//---------------------------------------------------------------------------
#endif
