/* clip.c
 *	Copyright (C) 2001, 2002, 2003 Timo Schulz
 *
 * This file is part of MyGPGME.
 *
 * MyGPGME is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MyGPGME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <windows.h>

#include "gpgme.h"
#include "util.h"


gpgme_error_t
gpgme_clip_istext_avail( int *r_rc )
{    
    HANDLE clipmem;
    char *clipdata;
    
    if( !r_rc )
	return mk_error( Invalid_Value );
    if( OpenClipboard( NULL ) == FALSE )
	return mk_error( Clip_Open );
    
    clipmem = GetClipboardData( CF_TEXT );
    if( !clipmem ) {
	*r_rc = 0;
	goto leave;
    }
    clipdata = (char *) GlobalLock( clipmem );
    if( !clipdata ) {
	*r_rc = 0;
	goto leave;
    }
    if( strlen( clipdata ) )
	*r_rc = 1;
    GlobalUnlock( clipmem );

leave:
    CloseClipboard();
    return 0;
} /* gpgme_clip_istext_avail */


gpgme_error_t
gpgme_clip_parse_pgpid( const char * data, gpgme_pgptype_t * r_type )
{
    gpgme_pgptype_t type;

    if( !data )
	return mk_error( Invalid_Value );
    if( strlen( data ) < 19 ) {
	*r_type = 0;
	return 0;
    }
    type = 0;
    if( strstr( data, "BEGIN PGP MESSAGE") )
	type |= GPGME_TYPE_MESSAGE;
    if( strstr( data, "BEGIN PGP SIGNED MESSAGE" ) )
	type |= GPGME_TYPE_CLEARSIG;
    if( strstr( data, "BEGIN PGP SIGNATURE" ) )
	type |= GPGME_TYPE_SIG;
    if( strstr( data, "BEGIN PGP PUBLIC KEY BLOCK" ) )
	type |= GPGME_TYPE_PUBKEY;
    if( strstr( data, "BEGIN PGP PRIVATE KEY BLOCK" )
	|| strstr( data, "BEGIN PGP SECRET KEY BLOCK" ) )
	type |= GPGME_TYPE_SECKEY;
    if( strstr( data, "- -----BEGIN" ) )
	type |= GPGME_TYPE_DASH_ESCAPED;
    *r_type = type;
    return 0;
} /* gpgme_clip_parse_pgpid */


gpgme_error_t
gpgme_clip_is_secured( gpgme_pgptype_t * r_type, int * r_rc )
{
    int rc = 0;
    HANDLE clipmem;
    char *clipdata;
    
    if( !r_rc )
	return mk_error( Invalid_Value );
    if( OpenClipboard( NULL ) == FALSE )
	return mk_error( Clip_Open );
    clipmem = GetClipboardData( CF_TEXT );
    if( !clipmem ) {
	*r_rc = 0;
	goto leave;
    }
    clipdata = (char *) GlobalLock( clipmem );
    if( !clipdata ) {
	*r_rc = 0;	
	goto leave;	
    }
    if( strstr( clipdata, "-----BEGIN PGP" ) 
	&& strstr( clipdata, "-----END PGP" ) )
	*r_rc = 1;
    GlobalUnlock( clipmem );
    gpgme_clip_parse_pgpid( clipdata, r_type );

leave:
    CloseClipboard();
    return rc;
} /* gpgme_clip_is_secured */


gpgme_error_t
gpgme_clip_do_check( int * r_rc )
{
    int has_data = 0;
    gpgme_error_t err;
    err = gpgme_clip_istext_avail( &has_data );
    if( err )
	return err;
    if( !has_data )
	return mk_error( Clip_Empty );
    gpgme_clip_is_secured( NULL, r_rc );
    return 0;
} /* gpgme_clip_do_check */


gpgme_error_t
gpgme_clip_get_pgptype( gpgme_pgptype_t * r_type )
{
    gpgme_error_t rc = 0;
    HANDLE clipmem;
    char * clipdata;
    
    if( OpenClipboard( NULL ) == FALSE )
	return mk_error( Clip_Open );
    clipmem = GetClipboardData( CF_TEXT );
    if( !clipmem ) {
	rc = mk_error( Clip_Get );
	goto leave;
    }
    clipdata = (char *)GlobalLock( clipmem );
    if( !clipdata ) {
	rc = mk_error( Clip_Get );
	goto leave;
    }    
    gpgme_clip_parse_pgpid( clipdata, r_type );
    GlobalUnlock( clipmem );
    
leave:
    CloseClipboard( );
    return rc;
} /* clip_get_pgp_type */

