//---------------------------------------------------------------------------
// GPGee - GNU Privacy Guard Explorer Extension
// GPGeeConfigure.cpp - Configuration dialog header
// Copyright 2005, Kurt Fitzner <kfitzner@excelcia.org>
//---------------------------------------------------------------------------
// This file is part of GPGee.
//
// GPGee is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License (Version 2) as
// published by the Free Software Foundation.
//
// GPGee is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------
#ifndef GPGeeConfigureH
#define GPGeeConfigureH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Buttons.hpp>
#include <Dialogs.hpp>
#include <ExtCtrls.hpp>
//---------------------------------------------------------------------------
class TformGPGeeConfigure : public TForm
{
__published:	// IDE-managed Components
        TGroupBox *gbGnuPG;
  TCheckBox     *chbGPGProgram;
  TEdit         *edtGPGProgram;
  TSpeedButton  *btnGPGProgram;
  TEdit         *edtOptfile;
  TCheckBox     *chbOptfile;
  TSpeedButton  *btnOptfile;
  TCheckBox     *chbKeyring;
  TEdit         *edtKeyring;
  TSpeedButton  *btnKeyring;
  TCheckBox     *chbSecretKeyring;
  TEdit         *edtSecretKeyring;
  TSpeedButton  *btnSecretKeyring;
  TCheckBox     *chbForceTrust;
  TCheckBox     *chbEncryptToSelf;
  TGroupBox     *gbGeneralOptions;
  TButton       *btnOk;
  TButton       *btnCancel;
  TButton       *btnHelp;
  TOpenDialog   *OpenDialog;
        TCheckBox *chbCacheKeys;
  TCheckBox *chbParentIds;
  TCheckBox *chbNotify;
  TBevel *Bevel1;
  TCheckBox *chbOverwrite;
  TCheckBox *chbRecurse;

  void __fastcall FormShow(TObject *Sender);
  void __fastcall btnOkClick(TObject *Sender);
  void __fastcall btnGPGProgramClick(TObject *Sender);
  void __fastcall chbGPGProgramClick(TObject *Sender);
  void __fastcall btnOptfileClick(TObject *Sender);
  void __fastcall chbOptfileClick(TObject *Sender);
  void __fastcall btnKeyringClick(TObject *Sender);
  void __fastcall chbKeyringClick(TObject *Sender);
  void __fastcall btnSecretKeyringClick(TObject *Sender);
  void __fastcall chbSecretKeyringClick(TObject *Sender);
  void __fastcall btnHelpClick(TObject *Sender);

private:	// User declarations
  AnsiString sBinDir;
  bool bFirstActivation;
  AnsiString sGPGProgram, sOptfile, sKeyring, sSecretKeyring;

  void __fastcall SanityCheck(void);

public:		// User declarations
  __fastcall TformGPGeeConfigure(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TformGPGeeConfigure *formGPGeeConfigure;
//---------------------------------------------------------------------------
#endif
