/* wptKeylist.h - Keylist element
 *	Copyright (C) 2001-2004 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation; either version 2 
 * of the License, or (at your option) any later version.
 *  
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */

#ifndef WPT_KEYLIST_H
#define WPT_KEYLIST_H

enum {	
    KEYLIST_ALL         =  0,	
    KEYLIST_LIST        =  1,	
    KEYLIST_ENCRYPT     =  2,
    KEYLIST_ENCRYPT_MIN =  4,	
    KEYLIST_SIGN        =  8,	
    KEYLIST_FLAG_FILE   = 16,
    KEYLIST_FLAG_SHORT  = 32,
};

enum {
    KEYFLAG_NONE     = 0,
    KEYFLAG_EXPIRED  = 1,
    KEYFLAG_REVOKED  = 2,
    KEYFLAG_DISABLED = 4
};


struct siglog_context_s {
    char file[1024];    
    gpgme_sig_t sig;
    unsigned use_uid:1;
    const char * user_id;
};
typedef struct siglog_context_s *siglog_context_t;

/*-- keylist.c --*/
const char * get_key_algo( gpgme_key_t key, int keyidx );
const char * get_key_created( long timestamp );
const char * get_key_expire_date( long timestamp );
const char * get_key_type( gpgme_key_t key );
const char * get_key_size( gpgme_key_t key, int keyidx );
const char * get_key_fpr( gpgme_key_t key );
const char * get_key_trust (gpgme_key_t key, int uididx, int listmode);
const char * get_key_trust_str (int val);
int find_secret_key( gpgme_key_t key );

listview_ctrl_t keylist_load( HWND ctrl, gpgme_keycache_t pubkc, gpgme_keycache_t seckc, 
			     int mode, int sortby );
int keylist_reload( listview_ctrl_t lv, gpgme_keycache_t c, int mode, int sortby );
void keylist_delete( listview_ctrl_t lv );
gpgme_recipients_t keylist_get_recipients( listview_ctrl_t lv, 
				        int *r_force_trust, int *r_count );
gpgme_recipients_t keylist_enum_recipients( listview_ctrl_t lv,  int listype );
int keylist_sort( listview_ctrl_t lv, int sortby );

/*-- wptImportList.cpp --*/
int  implist_build( listview_ctrl_t *lv, HWND ctrl );
int  implist_load( listview_ctrl_t lv, const char *file, 
		   int *r_revcerts, int *r_seckeys );
void implist_delete( listview_ctrl_t lv );

/*-- wptSigList.cpp --*/
listview_ctrl_t siglist_load( HWND ctrl, const char *keyid );
void siglist_delete( listview_ctrl_t lv );

/*-- wptVerifyList.cpp --*/
int verlist_build( listview_ctrl_t *lv, HWND ctrl, int fm_mode);
void verlist_delete( listview_ctrl_t lv );
void verlist_alloc( listview_ctrl_t lv, int nentries );
int verlist_add_sig( listview_ctrl_t lv, gpgme_sig_t sig );
int verlist_add_sig_log( listview_ctrl_t lv, siglog_context_t log );

/*-- seclist --*/
struct keylist_s {
    struct keylist_s * next;
    gpgme_key_t key;
};
typedef struct keylist_s * keylist_t;

void seclist_destroy (keylist_t * list);
void seclist_init (HWND dlg, int ctlid, int flags, keylist_t * ret_list);
int  seclist_select_key (HWND dlg, int ctlid, gpgme_key_t * ret_key);

#endif /* WPT_KEYLIST_H */