/* wptTypes.h - Common declarations
 *	Copyright (C) 2000-2005 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation; either version 2 
 * of the License, or (at your option) any later version.
 *  
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */

#ifndef WPT_TYPES_H
#define WPT_TYPES_H

/* Type shortcuts. */
typedef unsigned char	 byte;
typedef unsigned short	 u16;
typedef unsigned long	 u32;
typedef unsigned int	 ui32;
typedef unsigned __int64 ui64;

/* Crypto constants */
#define DFAULT_KEYSIZE 2048

/*
 * Message output
 */
#define MB_ERR		MB_OK | MB_ICONERROR
#define MB_INFO		MB_OK | MB_ICONINFORMATION
#define MB_WARN		MB_OK | MB_ICONWARNING
#define MB_ERR_ASK	MB_YESNO | MB_ICONERROR
#define MB_WARN_ASK	MB_YESNO | MB_ICONWARNING
#define MB_INFO_ASK	MB_YESNO | MB_ICONINFORMATION
#define MB_QUEST_ASK	MB_YESNO | MB_ICONQUESTION

/*
 * Maximal textsize for clipboard operations
 */
#define MAX_CLIPTEXT_SIZE 102400  /* max 100 KB data */

#define DIM(of) sizeof((of))/sizeof((of)[0])


#define safe_free(a) do { if ((a)) { free ((a)); (a) = NULL; } } while (0)

#define free_if_alloc(ptr) \
    do { \
	if ((ptr)) { \
	    delete [] (ptr); \
	    (ptr) = NULL; \
	} \
    } while (0)

#define sfree_if_alloc(ptr) \
    do { \
	if ((ptr)) \
	    memset (ptr, 0, strlen (ptr)); \
	free_if_alloc (ptr); \
    } while (0)


#define BUG(hwnd) \
    do { \
	char bug[512]; \
	_snprintf (bug, sizeof bug - 1, "Ohhh jeee; This is a BUG\n" \
					"%s: %d", __FILE__, __LINE__); \
	MessageBox (hwnd, bug, "FATAL ERROR", MB_ERR); \
	if (hwnd) \
	    EndDialog (hwnd, FALSE); \
	else \
	    exit (0); \
    } while (0)

#define dlg_fatal_error(dlg, msg) do { \
    MessageBox (dlg, msg, "FATAL ERROR", MB_ERR); \
    EndDialog (dlg, FALSE); \
    } while (0)

#endif /* WPT_TYPES_H */