# Makefile - gnupg.dsp

ifndef CFG
CFG=gnupg - Win32 Debug
endif
CC=gcc
CFLAGS=
CXX=g++
CXXFLAGS=$(CFLAGS)
RC=windres -O COFF
ifeq "$(CFG)"  "gnupg - Win32 Release"
CFLAGS+=-W -fexceptions -O2 -DWIN32 -DNDEBUG -D_MBCS -D_LIB
AR=ar
ARFLAGS=rus
else
ifeq "$(CFG)"  "gnupg - Win32 Debug"
CFLAGS+=-W -fexceptions -g -O0 -DWIN32 -D_DEBUG -D_MBCS -D_LIB
AR=ar
ARFLAGS=rus
endif
endif

ifndef TARGET
TARGET=libgnupg.a
endif

.PHONY: all
all: $(TARGET)

%.o: %.c
	$(CC) $(CFLAGS) $(CPPFLAGS) -o $@ -c $<

%.o: %.cc
	$(CXX) $(CXXFLAGS) $(CPPFLAGS) -o $@ -c $<

%.o: %.cpp
	$(CXX) $(CXXFLAGS) $(CPPFLAGS) -o $@ -c $<

%.o: %.cxx
	$(CXX) $(CXXFLAGS) $(CPPFLAGS) -o $@ -c $<

%.res: %.rc
	$(RC) $(CPPFLAGS) -o $@ -i $<

SRCS= \
	armor.c \
	iobuf.c \
	kbnode.c \
	md.c \
	md.h \
	md5.c \
	openpgp.h \
	packet.h \
	parse-packet.c \
	random.c \
	rmd160.c \
	rndw32.c \
	sha1.c \
	sha512.c

OBJS=$(patsubst %.rc,%.res,$(patsubst %.cxx,%.o,$(patsubst %.cpp,%.o,$(patsubst %.cc,%.o,$(patsubst %.c,%.o,$(filter %.c %.cc %.cpp %.cxx %.rc,$(SRCS)))))))

$(TARGET): $(OBJS)
	$(AR) $(ARFLAGS) $@ $(OBJS)

.PHONY: clean
clean:
	-rm -f $(OBJS) $(TARGET) gnupg.dep

.PHONY: depends
depends:
	-$(CXX) $(CXXFLAGS) $(CPPFLAGS) -MM $(filter %.c %.cc %.cpp %.cxx,$(SRCS)) > gnupg.dep

-include gnupg.dep

