# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a
Changelog](https://keepachangelog.com/en/1.0.0/), and this project
adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]
### Added
### Changed
### Deprecated
### Removed
### Fixed
### Security

----

## [v.13.1.0] - 2019-05-15
### Added
- Red colour background highlight in Data sheet for saturdays and
  sundays. Current day in red colour.
### Removed
- Removed 63p or, better, the (1 - 1/e) percentile, that is something
  like 63,21% and is a common easy approximation of the scale parameter
  (λ) of the Weibull distribution: see [How to Match to Weibull
  Distribution without
  Excel](https://connected-knowledge.com/2014/09/08/how-to-match-to-weibull-distribution-without-excel/)
  by Alexei Zheglov.
### Fixed
- Minor errors in WorkItems sheet with respect to dates.

## [v.13.0.0 'GSB84'] - 2019-04-18
### Added
- References about **[Kanban One](https://www.kanbanone.com)**.
- *Backlog Age Distribution* chart in
  [Distribution](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Distribution)
  sheet.
- New [CFD](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#CFD)
  dashboard sheet with CFD-related charts moved here: *Cumulative Flow
  Diagram*, *Daily Run Chart*, *Backlog Age Distribution*, *CoS Ratio*,
  *Flow Efficiency*.
- New [Lead Time](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Lead%20Time)
  dashboard sheet with Lead Time-related charts moved here: *Lead Times
  Scatterplot*, *Lead Times Distribution*, *Lead Times Detail*,
  *Approximate Average Lead Time*.
- New [Little's Law](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Little's%20Law)
  dashboard sheet with Little's Law-related charts moved here: *Little's
  Law*, *Little's Law (7 days)*, *I/O Speed*, *WIP Run Chart*,
  *Blockers*, *Effort Run Chart*.
- Added 63p or, better, the (1 - 1/e) percentile, that is something like
  63,21% and is a common easy approximation of the scale parameter (λ)
  of the Weibull distribution: see [How to Match to Weibull Distribution
  without Excel](https://connected-knowledge.com/2014/09/08/how-to-match-to-weibull-distribution-without-excel/)
  by Alexei Zheglov.
- Added mean, variance, median and mode for the **Weibull(LT)** and
  **Weibull(Backlog)** distributions.
### Changed
- New name for *Activities* sheet, now called
  [WorkItems](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#WorkItems).
  The word *activity* has been replaced in favour of *work item*, to
  better highlight the use of the **WIT** classification;
- New ordering of sheets: [Notes](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Notes),
  [WorkItems](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#WorkItems),
  [CFD](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#CFD)
  (charts dashboard), [Lead Time](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Lead%20Time)
  (charts dashboard), [Little's Law](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Little's%20Law)
  (charts dashboard), [Metrics](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Metrics),
  [Distribution](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Distribution),
  [Data](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Data).
- Review of text contents
  ([Usage](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md),
  [ReadMe](https://bitbucket.org/marcobresciani/aamfp/src/tip/README.md),
  …) to use the same naming conventions: [Sheet](#Sheet), *chart*,
  **Value**/**Column**.
- Renamed **Actual Effort** as **Computed Effort**.
- Review of work items data to have something more generic. But still
  not (yet) satisfied…
- New background colour for informational columns (CoS, WIT, Blocked
  Days, Deleted, and Labels) in
  [WorkItems](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#WorkItems)
  sheet.
### Removed
- *Charts*, *CFD*, *Scatterplot*, *StackedLT* older sheets.

## [v.12.0.0 'Medhelan'] - 2019-03-01
### Added
- Simple "codename" for each release, together with the version number.
  All major versions will have a codename.
- Daily throughput value and run chart.
- Email contact address added to code of conduct.
- Commented copyright notice added to all Markdown files.
- Visible copyright notice added to where it was missing in the Markdown
  files.
### Fixed
- Solve bug #15. Error in computing outgoing rate value.
- Solve bug #16. Use "Delivery Rate" instead of "Throughput".
- Solve bug #17. Error in computing mLT value.

## [v.11.0.7] - 2019-02-19
### Added
- Copyright notes added also as file properties.
- Added Free Cultural Works official recommendation icon to the Kanban
  board. See
  https://freedomdefined.org/Logos_and_buttons#AMYMADE.27s_buttons.
### Changed
- Small Creative Commons icon on the Kanban board has been replaced with
  the 88x31 pixels icon.

## [v.11.0.6] - 2019-02-15
### Changed
- Few minor improvements and modifications to the sheets (few dates,
  corrected chart colours, …).

## [v.11.0.5] - 2019-01-28
### Added
- Reference to **AAMfP_**
  (ring:2e5e3ab18b487d096464ed0a0b2c2af468a8838a) user on the [GNU
  Jami](https://jami.net) (former [GNU Ring](https://ring.cx), former
  SFLphone) distributed communication platform for further Q&A and
  contact needs. 

## [v.11.0.4] - 2019-01-25
### Added
- Reference to [@AAMfP@fosstodon.org](https://fosstodon.org/@AAMfP)
  user on [Mastodon](https://en.wikipedia.org/wiki/Mastodon_(software)
  federated social netowrk for all Q&A and contact needs.
### Changed
- Lock of charts position and dimension to improve usability and reduce
  errors

## [v.11.0.2] - 2019-01-14
### Added
- CC logo for "Free Cultural Works".
### Changed
- Updated
  [Usage](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md)
  to reflect latest improvements.

## [v.11.0.1] - 2019-01-12
### Changed
 - Better logic for sample data construction.
 - New layout and colouring for *Charts* sheet. Now each like keeps its
   unique colour and style through the sheet.

### Fixed
 - Better formula for expired deadlines in *Activities* sheet.  

## [v.11.0.0] - 2019-01-08
### Added
 - MAJOR: add
   [Usage](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md)
   file, now distributed together instead of an online wiki page.
 - MAJOR: add
   [Changelog](https://bitbucket.org/marcobresciani/aamfp/src/tip/CHANGELOG.md)
   file, now distributed together instead of an online wiki page.
 - MINOR: add lead time stacked bar chart.
 - MINOR: pie chart representing CoS ratios using colors defined in the
   [Kanban](https://leankanban.com/shop/kanban-book/) book.
 - MINOR: introduce "Keep a Changelog" format for
[Changelog](CHANGELOG.md) file. 

### Changed
 - MAJOR: Content of all sheets now better fitted to modern widescreens,
  now at 1920×1080.
 - MINOR: Represent ongoing activities with an asterisk (instead of a
  circle) in scatterplot to distiguish also through shapes with respect
  to completed activities.

## [v.10.2.5-beta] - 2019-01-04
### Changed
PATCH: Use proper copyright notice for Unifont.

## [v.10.2.4-beta] - 2019-01-03
### Fixed
PATCH: Fix #13

## [v.10.2.3-beta] - UNPUBLISHED
### Changed
PATCH: small rework of the Kanban board Draw/PDF, introducing Unifont.

## [v.10.2.2-beta] - 2019-01-02
### Changed
PATCH: add the original Code of Conduct.

## [v.10.2.1-beta] - 2018-12-18
### Changed
PATCH: update the layout of the Kanban board.

## [v.10.2.0-beta] - 2018-11-14
### Added
MINOR: add lead time stacked bar chart.

## [v.10.1.1] - 2018-11-10
### Changed
PATCH: Rework Activities samples to have more dynamic sample data.

## [v.10.1.0] - 2018-10-20
### Changed
MINOR: improve A3 board with WIP placeholder and Lead Time highlight.

## [v.10.0.0] - 2018-07-10
### Added
MAJOR: add Contributor Covenant Code of Conduct for possible
contributors.

## [v. 9.5.0] - 2018-07-09
### Changed
MINOR: improve Deadline column highlight showing all expired deadlines
with respect to current date.

## [v. 9.4.1] - 2018-07-09
### Changed
PATCH: unlock all previously locked sheets (easier to manage all updates
and versioning…)

## [v. 9.4.0] - 2018-07-09
### Added
MINOR: add "Labels" column to follow ActionableAgile™ Analitycs tool
DEMO source data, so providing more filtering opportunities.

## [v. 9.3.2] - 2018-06-26
### Changed
 - PATCH: blocks top rows for Activities, Metrics and Data sheets.
 - PATCH: blocks modifications on all sheets (except Activities) with
   empty password, to simply highlight the fact that Activities should
   be the only read/write sheet. Feel free to unlock the sheets if you
   prefer.

## [v. 9.3.0] - 2018-06-12
### Added
Add daily WIP and backlog run chart.

### Fixed
Solve issue #10.

## [v. 9.2.1] - 2018-06-12
### Fixed
Solve issue #9. Rename sheets with single word names.

## [v. 9.2.0] - 2018-06-01
### Added
Add Impact and Likelihood metrics as described in *Kanban Maturity
Model* book.

## [v. 9.0.1] - 2018-05-31
### Added
Add percentile colouring for Lead Times column showing which reference
percentile has been passed.

## [v. 9.0.0] - 2018-05-25
### Added
"Distribution" sheet added.

### Changed
- Reworked "LT Data" sheet,
- "Flow Efficiency" sheet deleted. 

### Fixed
Solve bug #5. Add "Effort" evaluation for single activity.

## [v. 8.0.1] - 2018-05-24
### Fixed
Solve bug #4. Rename columns to better fit KMM book.

## [v. 8.0.0] - 2018-05-21
### Added
Plus add Links column.

### Fixed
Solve bugs #2 and #3.

## [v. 7.2.1] - 2018-05-20
### Fixed
Bug #1 solved in the CFD. Now the column "Date" of the CFD Data starts
from the min - 1 day.

## [v. 7.2.0] - 2018-05-11
### Added
 - Add "Age" to scatterplot to represent deleted or WIP activities
   current LT.
 - Add "mLT" to scatterplot.

## [v. 7.0.0] - 2018-05-09
### Changed
Moving back basic statistics to "LT Data" folder in order to keep better
compatibility with ActionableAgile™ Analitycs tool.

## [v. 6.0.0] - UNPUBLISHED
### Changed
Moving basic statistics to "Activities" folder making easier filtering
scatterplot by CoS (or whatever).

## [v. 5.0.0] - UNPUBLISHED
### Changed
English translation.

## [v. 4.1.0] - PRIVATO
IN CORSO: aggiunta dati età in "Backlog".

### Changed
Grafico CFD fatto da cumulativo ("Dati CFD").

## [v. 4.0.0] - PRIVATO
### Changed
Ricalcolo medie Little.

### Fixed
Dati CFD da min(*) altrimenti i conti non tornano…

## [v.3.0.0] - 2017-08-05
### Changed
Rinominata "Opzioni" in "Backlog" per compatibilità col formato di
ActionableAgile™ Analitycs.

## [v.2.1.0] - 2017-08-05

## [v.2.0.0] - 2017-08-05
### Changed
Dati CFD da min("Fatto") invece che da min(*).

## [v. 1.4.1] - PRIVATO
### Removed
Rimosso il vincolo di inizio delle ascisse.

## [v. 1.4.0] - PRIVATO
### Changed
Massimo dell'ascissa dei grafici a massimo "Fatto", non più assoluto.

## [1.3.2] - PRIVATO|
### Changed
Arrotondamento (giorno) intero percentili e media.|

## [1.3.1] - PRIVATO
### Fixed
Correzione calcolo throughput.

## [1.3.0] - PRIVATO
### Added
Formattazione automatica per attività chiuse in ritardo.

## [1.2.0] - PRIVATO
### Added
Formattazione automatica per Scadenza.

## [1.1.0] - PRIVATO
### Added
 - CoS filtrate per classi standard.
 - Pagina dati efficienza (Flow Efficiency).

## [v.1.0.0] - 2017-06-10
### Changed
 - Moved computed data to "LT Data" sheet.
 - Renamed "Work Items" sheet as "Tasks".
 - Splitting LT and Age columns.
 - Added small Age chart.

## [v0.0.2] - UNPUBLISHED
- Added this History page.

## [Excel v.0.0.1] - 2017-06-10
### Added
First Microsoft Excel version.

## [v0.0.1] - 2017-06-05
### Added
First version.

----

Copyright © 2017, 2018, 2019 Marco Bresciani.	

[![Creative Commons 
License](https://i.creativecommons.org/l/by-sa/4.0/88x31.png)](http://creativecommons.org/licenses/by-sa/4.0/)
AAMfP: a simple (Personal) Kanban metrics spreadsheet by [Marco
Bresciani](https://bitbucket.org/marcobresciani/aamfp) is licensed under
a [Creative Commons Attribution-ShareAlike 4.0 International
License](http://creativecommons.org/licenses/by-sa/4.0/).

![Free Cultural
Works](https://freedomdefined.org/upload/6/63/CCBYSA_black.png)
This is a freely licensed work, as explained in the [Definition of Free
Cultural Works](https://freedomdefined.org/Licenses).
