<!--
AAMfP: a simple personal kanban metrics spreadsheet

Copyright (C)  2019  Marco Bresciani.

Copying and distribution of this file, with or without modification, are
permitted in any medium without royalty provided the copyright notice
and this notice are preserved. This file is offered as-is, without any
warranty.
-->
# AAMfP: a simple personal kanban metrics spreadsheet

[![standard-readme compliant](https://img.shields.io/badge/readme%20style-standard-brightgreen.svg?style=flat-square)](https://github.com/RichardLitt/standard-readme)
![Liberapay patrons](https://img.shields.io/liberapay/patrons/marcoXbresciani?style=plastic)
![Liberapay receiving](https://img.shields.io/liberapay/receives/marcoXbresciani?style=plastic)
![Mastodon Follow](https://img.shields.io/mastodon/follow/91124?domain=https%3A%2F%2Ffosstodon.org&style=plastic)
![Website](https://img.shields.io/website?style=plastic&url=https%3A%2F%2Fsavannah.nongnu.org%2Fprojects%2Faamfp%2F)
![Security Headers](https://img.shields.io/security-headers?style=plastic&url=https%3A%2F%2Fsavannah.nongnu.org%2Fprojects%2Faamfp%2F)
[![Donate using Liberapay](https://liberapay.com/assets/widgets/donate.svg)](https://liberapay.com/marcoXbresciani/donate)

> Use this spreadsheet to improve your activities using Personal
> Kanban concepts and applying Kanban method flow metrics.

Improve your daily workflow with this
[LibreOffice](https://www.libreoffice.org/) Calc spreadsheet using the
concepts of [Personal Kanban](http://personalkanban.com/pk/) and
applying some [Kanban
method](https://leankanban.com/project/what-is-km/) flow metrics as
described in the book [Actionable Agile Metrics for
Predictability](https://leanpub.com/actionableagilemetrics) (and
compatible with [Actionable Agile™
Analytics](https://www.actionableagile.com/) tool) by Dan Vacanti.

## Table of Contents
* [Background](#background)
  * [Visualize Your Work](#visualize-your-work)
  * [Limit Your Work-in-Progress](#limit-your-work-in-progress)
* [Install](#install)
* [Usage](#usage)
* [Maintainer](#maintainer)
* [Contributing](#contributing)
* [License](#license)
   * [Official GPL Logo](#official-gpl-logo)
   * [Official GFDL Logo](#official-gfdl-logo)
   * [AMYMADE's buttons](#amymades-buttons)
   * [GNU FreeFont](#gnu-freefont)

## Background
For **Kanban** method starts from here: [What is Kanban | Lean
Kanban](https://leankanban.com/project/wkanban/) and the [Essential
Kanban Condensed Guide](https://leankanban.com/guide/).

For **Personal Kanban** starts from here: [Map your work, control your
life: Personal Kanban](http://personalkanban.com/pk/) and [Personal
Kanban: The Book | Personal Kanban](http://personalkanban.com/pk/book/).

For more details and explanations on *metrics*, please see the book
[Actionable Agile Metrics for
Predictability](https://leanpub.com/actionableagilemetrics) by Vacanti,
Daniel S..

For more details and explanations on *flow* management, please see the
book [The Principles of Product Development Flow: Second Generation Lean
Product Development](http://reinertsenassociates.com/books/) by
Reinertsen, Donald G..

See also **[Kanban One](https://www.kanbanone.com)**, an online tool
aiming to cover the features of this spreadsheet (and more).

### Visualize Your Work
The project contains PDF and ODG (LibreOffice Draw) versions of an
[A3 format](https://en.wikipedia.org/wiki/ISO_216) printable kanban
board with **Backlog**, **Next**, **In-progress** and **Done** columns.
It's there for you to print, and use to visualize your workflow and work
items!

### Limit Your Work-in-Progress
On top of **Next** and **In-progress** columns of the printable board
above, there is a specific **WIP** area inside which you can write the
WIP limit for such columns: remember to write the limit in both columns,
to be sure to properly apply Kanban method concepts and obtain real
improvements.

## Install
Latest release is
v.[15.1.1](https://download.savannah.nongnu.org/releases/aamfp/15.1.1/).

See [Downloads](https://download.savannah.nongnu.org/releases/aamfp/)
page for all available releases.

For full versions history and details see the
[CHANGELOG.md](http://hg.savannah.nongnu.org/hgweb/aamfp/file/tip/CHANGELOG.md)
file.

The only requirement for this spreadsheet is, necessarily, to have
[LibreOffice](https://www.libreoffice.org/) installed or available.
Please see [LibreOffice](https://www.libreoffice.org/) reference site
for downloads and installation instructions.

## Usage
See [USAGE.md](USAGE.md) file.

## Maintainer
This project has been started by Marco Bresciani and is currently
maintained by Marco Bresciani.

For questions or requests, let's keep in touch:
* **[@AAMfP@fosstodon.org](https://fosstodon.org/@AAMfP)** on the
  [Mastodon](https://en.wikipedia.org/wiki/Mastodon_(software) federated
  social network).
* **[aamfp_](ring:2e5e3ab18b487d096464ed0a0b2c2af468a8838a)** user on
  the [GNU Jami](https://jami.net) (former GNU Ring, former SFLphone)
  distributed communication platform.

Feel free to open an
[issue](https://savannah.nongnu.org/support/?group=aamfp) for bugs,
enhancements, proposals or tasks.

## Thanks
Thanks to (in appearing order):

* [Gavi](https://bitbucket.org/classicPintus/) for having solved bug
[#1](https://web.archive.org/web/20190918131734/https://bitbucket.org/marcobresciani/aamfp/issues/1/wrong-cfd-counting)
and for creating **[Kanban One](https://www.kanbanone.com)** together
with Francesco.

* [Samuele Accordini](https://it.linkedin.com/in/samueleaccordini) for
citing this spreadsheet in his LinkedIn article (in Italian) [Personal
Kanban: il trainer del
tempo](https://www.linkedin.com/pulse/personal-kanban-il-trainer-del-tempo-samuele-accordini).

* [Rudiger Wolf](https://bitbucket.org/rnwolf/) for having creating his
  [Pandas Agile Metrics](https://github.com/rnwolf/pandas_agile_metrics)
  project "Inspired by https://bitbucket.org/marcobresciani/aamfp/".

## Contributing
It's technically difficult to work in multiple people on a spreadsheet,
so I'm working alone on this. Examples, suggestions, hints, issues are
very welcome, anyway.

If you know your LibreOffice macro programming or UNO, please drop me a
line! We'll try to share work on the spreadsheet.

## License
GNU General Public License v3.0 or later Marco Bresciani

This section also lists all the copyright notes for third parties
components used in this project.
```
 ,' ,-_-. '.
((_/)o o(\_))
 `-'(. .)`-'
     \_/

Copyright (C)  2019  Marco Bresciani.

Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.3 or
any later version published by the Free Software Foundation; with no
Invariant Sections, no Front-Cover Texts, and no Back-Cover Texts. A
copy of the license is included in the section entitled "GNU Free
Documentation License".
```

### Official GPL Logo
These images are in the public domain. See
https://www.gnu.org/graphics/license-logos.html.en.

### Official GFDL Logo
Copyright © 2007, 2008, 2011, 2018 Free Software Foundation, Inc.
Available under the GNU Free Documentation License v1.3. See
https://www.gnu.org/graphics/license-logos.html.en.

### AMYMADE's buttons
AMYMADE's buttons for Definition of Free Cultural Works are in the
public domain as described in
https://freedomdefined.org/Logos_and_buttons#AMYMADE.27s_buttons

### GNU FreeFont
Both spreadsheet and the printable kanban board use and include **GNU
FreeFont 20120503**.
```
Free UCS scalable fonts is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 3 of the License, or (at
your option) any later version.

The fonts are distributed in the hope that they will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

As a special exception, if you create a document which uses this font,
and embed this font or unaltered portions of this font into the
document, this font does not by itself cause the resulting document to
be covered by the GNU General Public License. This exception does not
however invalidate any other reasons why the document might be covered
by the GNU General Public License. If you modify this font, you may
extend this exception to your version of the font, but you are not
obligated to do so.  If you do not wish to do so, delete this exception
statement from your version.
```
