<?php

/* Appora server
 * Copyright (C) 2011 Appora contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/** Included file for browse action service */
require_once(dirname(__FILE__) . "/../env.php");
require_once(dirname(__FILE__) . "/AService.php");
require_once($_MODELS_DIR . "/Category.php");
require_once($_MODELS_DIR . "/ApplicationDescriptor.php");
require_once($_MODELS_DIR . "/AttributesMask.php");

class BrowseService extends AService {

	public function __construct() {
		$this->name = "browse";
	}

	public function run() {
		global $server, $header, $response, $input, $aLocales;
		// Check and get category id, use root if not set
		$catId = NULL;
		if (isset($input['id']) && strlen($input['id']) > 0) {
			$catId = $input['id'];
		}
		// Set attributes mask, use ALL if not set
		$iAttrMask = NULL;
		if (!isset($input['attributes'])) {
			$iAttrMask = AttributesMask::ATTR_ALL;
		} else {
			$iAttrMask = AttributesMask::getMask($input['attributes']);
		}

		// Get decriptor service
		$appDescGetter = $server->getDescriptorsModule();
		if ($appDescGetter === NULL) {
			$this->reportInternalError("Unable to get descriptors service",
					NULL);
			return;
		}
		// Get category
		try {
			$category = $appDescGetter->getCategory($catId, $iAttrMask,
					$aLocales);
		} catch (Exception $e) {
			$this->reportInternalError("Exception while getting data", $e);
			return;
		}
		if ($category === NULL) {
			// Category was not found
			$this->reportNoData("No data found for this id.");
			return;
		}
		// Send data
		$response = CategoryJSONDTO::toJSON($category, $iAttrMask);
		$header = "HTTP/1.0 200 Ok; Content-Type: application/json;"
				. " Content-Length: " . strlen($response);
	}

}

$browse_service = new BrowseService();
$browse_service->run();
?>
