<?php

/* Appora server
 * Copyright (C) 2011 Appora contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/** Interface for all application descriptors modules. */
interface IAppDescGetter {

	/** Get an application descriptor from its identifier.
	 * @param undefined $appIdentifier The application identifier.
	 * Type is sever dependant.
	 * @param int $iAttributesMask Mask detailing which attributes
	 * should be retreived. Implementation can still give more than requested.
	 * @param array $aLocales Array of locales in preference order. Can
	 * be NULL or empty, server default one always applies.
	 * @return Application The application or NULL if not found.
	 */
	public function getApplication($appIdentifier, $iAttributesMask,
			$aLocales = NULL);

	/** Get a category with subcategories and applications short descriptors
	 * @param undefined $categoryIdentifier The category identifier.
	 * Type is server dependant.
	 * @param int $iAppAttributesMask Mask detailing which attributes
	 * should be retreived for children applications. Implementation can still
	 * give more than requested.
	 * @param array $aLocales Array of locales in preference order. Can be
	 * NULL or empty, server default one always apply.
	 * @return Category The requested category. Recursion on subcategories is
	 * left to implementation.
	 */
	public function getCategory($categoryIdentifier, $iAppAttributesMask,
			$aLocales = NULL);
}

?>
