<?php

/* Appora server
 * Copyright (C) 2011 Appora contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/* Get the given POST or GET parameters and give them to the right service.
 * Each service is covered on a separate file and must store server response
 * in $response variable and header in the $header variable.
 *
 * The server configuration is set into the $server variable to access inner
 * services. See config/Config.php for details.
 * Locales are stored as an array in $aLocales.
 *
 * The input data (either through GET or POST is redirected to the $input
 * variable. Set to GET unless POST action is provided. GET and POST cannot
 * be mixed for input.
 */

require_once(dirname(__FILE__) . "/env.php");
// Setup environment
require_once($_CONFIG_DIR . "/IniConfigLoader.php");
require_once($_CONFIG_DIR . "/Config.php");
$confLoader = new IniConfigLoader($_SETUP_FILE);
$server = new Config($confLoader);

// Check minimal input
if (!isset($_POST['action']) && !isset($_GET['action'])) {
	$header = "HTTP/1.0 400 Bad request";
	$response = "Action required, check your input data.";
	header($header);
	echo($response);
	exit();
}
// Set input to GET or POST
$input = $_GET;
if (isset($_POST['action'])) {
	$input = $_POST;
}
$action = $input['action'];

// -- Do pre-service stuff here
// Check server status
if ($server->getServerStatus() == Config::STATUS_OFFLINE && $action != "hello") {
	$header = "HTTP/1.0 503 Service unavailable";
	$response = "Server is temporarily not accepting actions.";
	header($header);
	echo($response);
	exit();
}


// Get locales and add default one if non strict locales
// or if no locales where given
$aLocales = NULL;
if (isset($input['locales'])) {
	$aLocales = explode(",", $input['locales']);
}
if (!isset($input['strict_locales']) || !$input['strict_locales']
		|| $aLocales === NULL || count($aLocales) == 0) {
	if ($aLocales === NULL) {
		$aLocales = array();
	}
	array_push($aLocales, $server->getDefaultLocale());
}

// Run service
if ($action == 'get') {
	// Declare configuration as global for dynamic script inclusion
	global $_DESC_SERVICES_DIR, $_APP_SERVICES_DIR, $_MODELS_DIR, $_TOOLS_DIR;
	// Get action
	require_once($_SERVICES_DIR . "/GetService.php");
} else if ($action == "browse") {
	// Browse action
	global $_DESC_SERVICES_DIR, $_APP_SERVICES_DIR, $_MODELS_DIR, $_TOOLS_DIR;
	require_once($_SERVICES_DIR . "/BrowseService.php");
} else if ($action == "info") {
	// Info action
	global $_DESC_SERVICES_DIR, $_APP_SERVICES_DIR, $_MODELS_DIR, $_TOOLS_DIR;
	require_once($_SERVICES_DIR . "/InfoService.php");
} else if ($action == "hello") {
	// Hello action
	global $_DESC_SERVICES_DIR, $_APP_SERVICES_DIR, $_MODELS_DIR, $_TOOLS_DIR;
	require_once($_SERVICES_DIR . "/HelloService.php");
} else if ($action == "update") {
	// Update action
	require_once($_SERVICES_DIR . "/UpdateService.php");
} else {
	// Unsupported or unrecognized action
	$header = "HTTP/1.0 400 Bad request";
	$response = "Unsupported action, check your input data.";
}

// -- Do post-service stuff here


// Set header and send answer
header($header);
echo($response);
?>
