<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "blog";

include_once ("config/blg.config.php");
include_once ("inc/blg_initiate.inc.php");


// select set tags
require_once('components/core/class/Tag.class.php');
$tag = new Tag($db, $core_config['module_id']['blog'], $blog_config['tag']['blg']['blog']);
$tag->level_id = $core_config['tag']['level']['item'];

$output_blog_tags = $tag->selTags(1);				

if (!empty($output_blog_tags)) {
	$body->set('blog_tags', $output_blog_tags);
}

// page tags
unset ($tag->level_id);

$output_tags = $tag->selTags(1);				

if (!empty($output_tags)) {
	$body->set('tags', $output_tags);
}

// get highest rated wiki sets
require_once('components/core/class/Rate.class.php');
$rate = new Rate($db, $core_config['module_id']['blog']);

$output_rating = $rate->selRating(1);				

if (!empty($output_rating)) {
	// get the pages for each rating
	foreach ($output_rating as $key => $i):
		$blog->entry_ids[] = $i['inner_item_id'];
	endforeach;
	
	$blog->entry_ids = array_unique($blog->entry_ids);
				
	if (!empty($blog->entry_ids)) {
		$output_rated_entries = $blog->selEntries();
	}
	
	// apply the totals to the entries
	if (!empty($output_rated_entries)) {
		foreach ($output_rated_entries as $keyp => $p):
			foreach ($output_rating as $keyi => $i):
				if ($p['entry_id'] == $i['inner_item_id']) {
					$output_rated_entries[$keyp]['total'] = $i['total'];
					break;
				}
			endforeach;
		endforeach;
	}

	$body->set('rated_entries', $output_rated_entries);
}

// get the highest recommendations
require_once('components/core/class/Bookmark.class.php');
$bookmark = new Bookmark($db, $core_config['module_id']['blog']);
$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];

$output_recommendations = $bookmark->selBookmarks(null, 1);				

unset ($blog->blog_ids);

if (!empty($output_recommendations)) {
	// get the pages for each recommendation
	foreach ($output_recommendations as $key => $i):
		$blog->blog_ids[] = $i['item_id'];
	endforeach;
	
	$blog->blog_ids = array_unique($blog->blog_ids);
				
	if (!empty($blog->blog_ids)) {
		$output_recommended_blogs = $blog->selBlogs();
	}
	
	// apply the totals to the pages
	if (!empty($output_recommended_blogs)) {
		foreach ($output_recommended_blogs as $keyp => $p):
			foreach ($output_recommendations as $keyi => $i):
				if ($p['blog_id'] == $i['item_id']) {
					$output_recommended_blogs[$keyp]['total'] = $i['total'];
					break;
				}
			endforeach;
		endforeach;
	}

	$body->set('recommended_blogs', $output_recommended_blogs);
}
	
	
?>
