<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "blog";

include_once ("config/blg.config.php");
include_once ("inc/blg_initiate.inc.php");


if (isset($_POST['update_ownership'])) {
	$query = "
		SELECT * 
		FROM " . $db->prefix . "_blog  
		WHERE 
		blog_id=" . $_POST['blog_id']
	;
	
	$result = $db->Execute($query);
	
	if (isset($result->fields)) {
		$rec = array();
		$rec['user_id'] = $_POST['user_id'];
		
		$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $db->Execute($query);
	}
	
	header("Location: index.php?amn=blg_item&blog_id=" . $_POST['blog_id'] . "&" . strip_tags(SID));
	exit;
}


if (!empty($_REQUEST['blog_id'])) {
	$output_blog = $blog->selBlog($_REQUEST['blog_id']);
}


if (!empty($output_blog)) {
	// are we the owner of this blog?
	if ($_SESSION['user_id'] == $output_blog['user_id']) {
		// obtain any roles
		$query = "
			SELECT * 
			FROM " . $db->prefix . "_mem_type_access 
			WHERE 
			module_id=" . $core_config['module_id']['blog'] . " AND 
			item_id=" . $output_blog['blog_id']
		;
	
		$result = $db->Execute($query);
	
		if (isset($result->fields)) {
			$membership_type_ids = array();

			while (!$result->EOF) {
				array_push($membership_type_ids, $result->fields);
				$result->MoveNext();
			}
			
			$output_blog['membership_type_ids'] = $membership_type_ids;
		}
		
		
		$body->set('blog', $output_blog);
	
		// get entries
		$output_entries = $blog->selEntries($output_blog['blog_id']);
		$body->set('entries', $output_entries);
	}
	else {
		header("Location: index.php?amn=blg_item&blog_id=" . $output_blog['blog_id'] . "&" . strip_tags(SID));
		exit;
	}



	// get coordinators
	$output_authors = $participation->selParticipants(null, $blog_config['role']['author']);
		
	if (!empty($output_authors)) {
		foreach ($output_authors as $key => $i):
			$user->identity_ids[] = $i['identity_id'];
		endforeach;
		
		$user->identity_ids = array_unique($user->identity_ids);
		
		if (!empty($user->identity_ids)) {
			$output_authors = $user->selUserIdentities();
			$body->set('authors', $output_authors);
		}
	}


	// select tags
	require_once('components/core/class/Tag.class.php');
	$tag = new Tag($db, $core_config['module_id']['blog'], $blog_config['tag']['blg']['blog']);
	$tag->item_id = $output_blog['blog_id'];
	$tag->level_id = $core_config['tag']['level']['item'];
	
	if (isset($_POST['insert_tag'])) {
		if (empty($_POST['tag_id'])) { // we insert
			$tag->insertTag($_POST['tag_body']);
		}
		elseif (!empty($_POST['tag_id']) && empty($_POST['tag_body'])) { // we delete
			$tag->deleteTag($_POST['tag_id']);
		}
		else { // we update tag
			$tag->updateTag($_POST['tag_id'], $_POST['tag_body']);
		}
	}
	elseif (isset($_POST['delete_tag'])) {
		$tag->deleteTag($_POST['tag_id']);
	}
	elseif (isset($_REQUEST['edit_tag'])) {
		$output_tag = $tag->selTag($_REQUEST['edit_tag']);
	
		if (!empty($output_tag)) {
		$body->set('tag', $output_tag);
		}
	}
	
	$output_tags = $tag->selTags();
	
	if (!empty($output_tags)) {
		$body->set('tags', $output_tags);
	}
	
	
	if (isset($_POST['add_blogroll'])) {
		
		if (!empty($_POST['blog_ids'])) {
		
			$table = $db->prefix . "_blog_roll";
			
			foreach($_POST['blog_ids'] as $key => $i):
				$rec = array();
				$rec['blog_id'] = $output_blog['blog_id'];
				$rec['related_blog_id'] = $i;
				$rec['user_id'] = $_SESSION['user_id'];
				
				$query = $db->getInsertSQL($table, $rec, get_magic_quotes_gpc());
				$result = $db->Execute($query);
			endforeach;
		}		
	}
	elseif (isset($_POST['remove_blogroll'])) {
		
		if (!empty($_POST['blog_ids'])) {
			foreach($_POST['blog_ids'] as $key => $i):
			
				$query = "
					DELETE FROM " . $db->prefix . "_blog_roll 
					WHERE
					blog_id=" . $output_blog['blog_id'] . " AND 
					related_blog_id=" . $i
				;
				
				$result = $db->Execute($query);
			endforeach;
		}
	}	
	
	
	// blogroll
	$output_blogroll = $blog->selBlogRoll($output_blog['blog_id']);
	
	if (!empty($output_blogroll)) {
		$body->set('blogroll', $output_blogroll);
	}
	
	// my bookmarks
	require_once('components/core/class/Bookmark.class.php');
	$bookmark = new Bookmark($db, $core_config['module_id']['blog']);
	
	$bookmark->bookmark_type = $core_config['bookmark']['type']['watch'];
	$output_bookmarks = $bookmark->selBookmarks(1);
	
	if (!empty($output_bookmarks)) {
		// we get item_id's and we get the sets from that
		foreach ($output_bookmarks as $key => $i):
			$blog->blog_ids[] = $i['item_id'];
		endforeach;
		
		if (!empty($blog->blog_ids)) {
			$output_my_bookmarks = $blog->selBlogs();
		}
		
		if (!empty($output_my_bookmarks)) {
			$body->set('my_bookmarks', $output_my_bookmarks);
		}
	}
}

$body->set("module_prefix", $core_config['module'][$core_config['module_id']['blog']]['prefix']);

?>
