<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "event";

include_once ($language_path . 'inc/evt_common.inc.php');

// Setup Event -----------------------------------------------------------
include_once ("config/evt.config.php");
require_once ("class/Event.class.php");
$evt                = new Event($db, $core_config);
$evt->event_config  = $event_config;
$evt->status_id     = $event_config['event']['status']['live'];
$evt->user_id       = $_SESSION['user_id'];
$evt->language_id   = $_SESSION['language_id'];
$evt->location_id   = $_SESSION['location_id'];
$evt->my_attendance = true;
$evt->date          = new Date;
$evt->allEvents();

if (empty($_SESSION['md5'])) {
	$evt->level_id = $event_config['level']['public'];
	$evt->membership_type_id = 0;
}
else {
	$evt->membership_type_id = $_SESSION['membership_type_id'];
}

$output_events = $evt->selEvents(true, true);

$query = "
	SELECT e.event_id, e.event_end_datetime, e.event_title
	FROM " . $db->prefix . "_event e
	INNER JOIN " . $db->prefix . "_participation p
	ON (p.module_id=" . $core_config['module_id']['event'] . " AND p.item_id=e.event_id)
	LEFT JOIN " . $db->prefix . "_event_feedback f
	ON e.event_id=f.event_id
	WHERE p.user_id=" . $_SESSION['user_id'] . " AND e.event_end_datetime < now() AND 
	p.status_id=" . $core_config['participation']['status']['active'] . " AND f.feedback_id IS NULL AND
	e.status_id = " . $event_config['event']['status']['live'] . "
	ORDER BY e.event_end_datetime"
;

$result = $db->Execute($query);

if (isset($result->fields)) {
	$output_event_feedbacks = array();
	while(!$result->EOF) {
		array_push($output_event_feedbacks, $result->fields);
		$result->moveNext();
	}
	$result->Close();
	
}
else {
	// error-code here
}
// EO Feedbacks ------------------------------------------------------------------------------

// whats are my respected network up to? ----------------------------------------------------------
$query = "
	select DISTINCT e.event_id, e.event_title, p.identity_id, 
	e.event_start_datetime, p.user_id
	FROM " . $db->prefix . "_participation p 
	INNER JOIN " . $db->prefix . "_event e 
	ON (e.event_id=p.item_id AND p.module_id=" . $core_config['module_id']['event'] . ")
	INNER JOIN " . $db->prefix . "_relation r
	ON (p.identity_id=r.identity_id_relation)
	WHERE e.event_start_datetime > now() AND
	p.user_id != " . $_SESSION['user_id'] . " AND
	e.status_id = " . $event_config['event']['status']['live'] . "
	ORDER BY e.event_start_datetime DESC"
;

$result = $db->Execute($query);
$portable_network = array();

if (isset($result->fields)) {
	while(!$result->EOF) {
		array_push($portable_network, $result->fields);
		$result->moveNext();
	}
	$result->Close();
}



// Selecting recommendations ---------------------------------------------

$query = "
	SELECT DISTINCT r.identity_id_relation,  
	i.identity_nic, b.item_id, e.event_title 
	FROM " . $db->prefix . "_relation r 
	INNER JOIN " . $db->prefix . "_user_identity i 
	ON i.identity_id=r.identity_id_relation 
	INNER JOIN " . $db->prefix . "_bookmark b
	ON (b.user_id=i.user_id AND b.module_id=" . $core_config['module_id']['event'] . ")
	INNER JOIN " . $db->prefix . "_event e
	ON e.event_id=b.item_id
	WHERE r.module_id=" . $core_config['module_id']['event'] . " AND r.user_id=" . $_SESSION['user_id'] . ""
;
// echo $query; exit;
$result = $db->Execute($query);

if (isset($result->fields)) {
	$output_recommended = array();
	while(!$result->EOF) {
		array_push($output_recommended,$result->fields );
		$result->moveNext();
	}
	$result->Close();
}


// Setup Bookmark --------------------------------------------------------
require_once ('components/core/class/Bookmark.class.php');
$bookmark = new Bookmark($db, $core_config['module_id']['event']);
$bookmark->user_id = $_SESSION['user_id'];
$bookmark->bookmark_type = $core_config['bookmark']['type']['watch'];
$output_bookmarks = $bookmark->selBookmarks(true);

foreach($output_bookmarks as $key => $b) {
	$evt->event_id = $b['item_id'];
	$output_bookmarks[$key]['event'] = $evt->selEvent();
}


// Setup File -------------------------------------------------------------
require_once ('components/core/class/File.class.php');
$file = new File($db, $core_config['file']);
$file->module_id = 0;
$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
$user->file = $file;

if (!empty($output_events)) {
	
	foreach($output_events as $key => $e) {
		$output_events[$key]['file'] = $file->selFile($e['file_id'], 't2');
	}
	$body->set('events', $output_events);
}

if (!empty($output_event_feedbacks)) {
	$body->set('event_feedbacks', $output_event_feedbacks);
}

foreach($portable_network as $key => $p) {
	$portable_network[$key]['identity'] = $user->selUserIdentity(null, $p['identity_id'], null);
}

if (!empty($portable_network)) {
	$body->set('portable_network', $portable_network);
}

if (!empty($output_bookmarks)) {
	$body->set('bookmark', $output_bookmarks);
}

if (!empty($output_recommended)) {
	$body->set('recommended', $output_recommended);
}

?>