<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "group";

include_once ("config/grp.config.php");
include_once ("inc/grp_initiate.inc.php");


// select set tags
require_once('components/core/class/Tag.class.php');
$tag = new Tag($db, $core_config['module_id']['group'], $group_config['tag']['grp']['group']);
$tag->level_id = $core_config['tag']['level']['item'];

$output_group_tags = $tag->selTags(1);				

if (!empty($output_group_tags)) {
	$body->set('group_tags', $output_group_tags);
}

// page tags
unset ($tag->level_id);

$output_tags = $tag->selTags(1);				

if (!empty($output_tags)) {
	$body->set('tags', $output_tags);
}

// get highest rated wiki sets
require_once('components/core/class/Rate.class.php');
$rate = new Rate($db, $core_config['module_id']['group']);

$output_rating = $rate->selRating(1);				

if (!empty($output_rating)) {
	// get the pages for each rating
	foreach ($output_rating as $key => $i):
		$group->subject_ids[] = $i['inner_item_id'];
	endforeach;
	
	$group->subject_ids = array_unique($group->subject_ids);
	
	if (!empty($group->subject_ids)) {
		$output_rated_subjects = $group->selSubjects(null, 1);
	}
	
	// apply the totals to the pages
	if (!empty($output_rated_subjects)) {
		foreach ($output_rated_subjects as $keyp => $p):
			foreach ($output_rating as $keyi => $i):
				if ($p['subject_id'] == $i['inner_item_id']) {
					$output_rated_subjects[$keyp]['total'] = $i['total'];
					break;
				}
			endforeach;
		endforeach;

		$body->set('rated_subjects', $output_rated_subjects);
	}
}

// get the highest recommendations
require_once('components/core/class/Bookmark.class.php');
$bookmark = new Bookmark($db, $core_config['module_id']['group']);
$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];

$output_recommendations = $bookmark->selBookmarks(null, 1);				

unset ($group->subject_ids);

if (!empty($output_recommendations)) {
	// get the pages for each recommendation
	foreach ($output_recommendations as $key => $i):
		$group->subject_ids[] = $i['inner_item_id'];
	endforeach;
	
	$group->subject_ids = array_unique($group->subject_ids);
			
	if (!empty($group->subject_ids)) {
		$output_recommended_subjects = $group->selSubjects(null, 1);
	}
	
	// apply the totals to the pages
	if (!empty($output_recommended_subjects)) {
		foreach ($output_recommended_subjects as $keyp => $p):
			foreach ($output_recommendations as $keyi => $i):
				if ($p['subject_id'] == $i['inner_item_id']) {
					$output_recommended_subjects[$keyp]['total'] = $i['total'];
					break;
				}
			endforeach;
		endforeach;
		
		$body->set('recommended_subjects', $output_recommended_subjects);
	}
}
	
	
?>
