<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

if (isset($_SESSION['md5'])) {
	$menu_section = "group";
	
	include_once ("config/grp.config.php");
	include_once ("inc/grp_initiate.inc.php");
	
	if (isset($_POST['accept_invite'])) { 
		$query = "
			SELECT user_id, identity_id, role_id, status_id, 
			participation_permission 
			FROM " . $db->prefix . "_participation 
			WHERE 
			item_id=" . $output_group['group_id'] . " AND 
			module_id=" . $core_config['module_id']['group'] . " AND 
			user_id=" . $_SESSION['user_id']
		;
			
		$result = $db->Execute($query);
				
		if (isset($result->fields)) {
			$rec = array();
			$rec['identity_id'] = $_POST['identity_id'];
			$rec['status_id'] = $group_config['user']['status']['active'];
			
			$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $db->Execute($query);
			
			header("Location: index.php?amn=grp_item&group_id=" . $_POST['group_id'] . "&" . strip_tags(SID));
			exit;
		}
	
	}
	elseif (isset($_POST['my_participation_insert'])) { // we are joining
		if (empty($_POST['identity_id'])) {
			$GLOBALS['am_error_log'][] = array('identity_empty');
		}
	
		if (empty($GLOBALS['am_error_log'])) {
			$participation->item_id = $_POST['group_id'];
			
			if ($output_group['group_type'] == $group_config['type']['approved']) {
				$_POST['status_id'] = $group_config['user']['status']['pending'];
			}
			else {
				$_POST['status_id'] = $group_config['user']['status']['active'];
			}
			
			$_POST['participation_permission'] = $output_group['default_user_permission'];
			
			$participation->user_id = $_SESSION['user_id'];
			
			$participation->insertParticipant($_POST);
			
			header("Location: index.php?amn=grp_item&group_id=" . $_POST['group_id'] . "&" . strip_tags(SID));
			exit;
		}
		
	
	
	}
	elseif (isset($_POST['my_participation_withdraw'])) {
		
		$participation->deleteParticipant($_SESSION['user_id']);
		
		header("Location: index.php?amn=grp_item&group_id=" . $_POST['group_id'] . "&" . strip_tags(SID));
		exit;
	
	}
	elseif (isset($_POST['remove_relations'])) {
		$participation->deleteRelations($_POST['identity_ids'], $output_participation['identity_id']);
	}
	
	
	require_once ("components/core/class/File.class.php");
	$file = new File($db, $core_config['file']);
	$file->user_id = $_SESSION['user_id'];
	$file->module_id = 0; // core
	$user->file = $file;
	$user->file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
	$user->file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];
	
	
	// INVITATION
	if (isset($output_participation) && $output_participation['status_id'] == $group_config['user']['status']['invite']) {
		
		if ($output_group['group_type'] == $group_config['type']['invitation'] && empty($output_participation['invitee_user_id'])) {
			header("Location: index.php?amn=grp_item&group_id=" . $output_group['group_id'] . "&" . strip_tags(SID));
			exit;
		}
		
		unset ($body->vars['participation']);
		
		$body->set('invite', 1);
	
		// get user identities for join dropdown
	
		$output_identities = $user->selUserIdentities($_SESSION['user_id'], 1);
		$body->set('identities', $output_identities);
		
		if (!empty($output_participation['invitee_user_id'])) {
			$output_invitee = $user->selUserIdentity($output_participation['invitee_user_id']);
			$body->set('invitee_identity', $output_invitee);
		}
	
	}
	elseif (!isset($output_participation)) { // we display join screen
		// SELECT PARTICIPANTS --------------------------------------------------------
		$output_participants = $participation->selParticipants($group_config['user']['status']['active']);
		
		// SELECT PARTICIPANTS IDENTITIES ---------------------------------------------
		if (!empty($output_participants)) {
			// get their ids
			if (!empty($output_participants)) {
				foreach ($output_participants as $key => $i):
					$user->identity_ids[] = $i['identity_id'];
				endforeach;
				
				$user->identity_ids = array_unique($user->identity_ids);
				
				if (!empty($user->identity_ids)) {
					$output_identities = $user->selUserIdentities();
					
					// we place the identities against the participants
					if (!empty($output_identities)) {
						foreach ($output_participants as $keyp => $p):
							foreach ($output_identities as $keyi => $i):
								if ($p['identity_id'] == $i['identity_id']) {
									$output_participants[$keyp]['identity'] = $i;
									break;
								}
							endforeach;
						endforeach;
					}
					
					$body->set('participants', $output_participants);
				}
			}
		}
	
	
		// Setup Tie -------------------------------------------------------------
		require_once ("components/core/class/Tie.class.php");
		$tie = new Tie($db, $core_config);
		$tie->module_id = $core_config['module_id']['group'];
		$tie->item_id = $output_group['group_id'];
	
		// SELECT RELATIONS --------------------------------------------------------
	
		unset($user->identity_ids);
		
		$output_relations = $participation->selRelations(null, $_SESSION['user_id']);
		
		// SELECT PARTICIPANTS IDENTITIES ---------------------------------------------
		if (!empty($output_relations)) {
			// get their ids
			if (!empty($output_relations)) {
				foreach ($output_relations as $key => $i):
					$user->identity_ids[] = $i['identity_id_relation'];
				endforeach;
				
				$user->identity_ids = array_unique($user->identity_ids);
				
				if (!empty($user->identity_ids)) {
					$output_identities = $user->selUserIdentities();
					
					// we place the identities against the participants
					if (!empty($output_identities)) {
						foreach ($output_relations as $keyp => $p):
							// is this relationship mutual?
							if ($tie->isMutual($p['identity_id_relation'], $output_participation['identity_id'])) {
								$output_relations[$keyp]['mutual'] = 1;
							}
									
							foreach ($output_identities as $keyi => $i):
								if ($p['identity_id_relation'] == $i['identity_id']) {
									$output_relations[$keyp]['identity'] = $i;
									
									break;
								}
							endforeach;
						endforeach;
					}
					
					$body->set('relations', $output_relations);
				}
			}
		}
	
		// get user identities for join dropdown
	
		$output_identities = $user->selUserIdentities($_SESSION['user_id'], 1);
		$body->set('identities', $output_identities);
	}
}
else {
	header("Location: index.php&" . strip_tags(SID));
	exit;
}

?>
