<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<div class="col_main">
	<div class="box">
		<div class="box_top">
			<div class="content">
				<span style="float:left;">
				<a href="#" style="float:left;" onClick="javascript:launchPopupWindow('components/core/help.php?help=grp_index');" style="cursor:help;"><img src="<?php echo $template_path_core;?>img/help.png" alt="<?php echo $lang['alt_help'];?>" border="0" /></a>
				<?php
				if (!empty($group['group_unix_title'])) {
				?>
				&nbsp;
				<a href="index.php?amn=grp_item&amp;group_id=<?php echo $group['group_id'];?>&amp;enter_fullscreen=1"><img src="<?php echo $template_path_core;?>img/enter_fs.png"  title="<?php echo $lang['txt_enter_fullscreen'];?>" hspace="2" alt="<?php echo $lang['alt_full_screen'];?>" border="0" /></a>
				<?php }?>
				</span>
				<h1><?php echo $group['group_title'];?></h1>
			</div>
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php echo $group['group_body'];?><br />
			</div>
		</div>
	</div>
	
	<?php
	if (isset($subjects)) {
	?>
	<div class="box">
		<div class="box_top">
			<div class="content">
				<h1><?php echo $lang['hdr_subjects'];?></h1>
			</div>
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table cellspacing="1" cellpadding="4" border="0" width="100%">
					<?php
					foreach ($subjects as $key => $i):
					?>
					<tr>
						<td valign="middle" width="32">	
							<a href="index.php?amn=grp_forum_subject&amp;group_id=<?php echo $i['group_id'];?>&amp;subject_id=<?php echo $i['subject_id'];?>"><img src="get_file.php?file=<?php echo $i['image']['file_md5_name_view'];?>" border="0" class="picture" alt="<?php echo isset($i['image']['file_save_name']) ? $i['image']['file_save_name'] : $lang['alt_no_image']; ?>" /></a><br />
						</td>
						<td valign="top">
							<a href="index.php?amn=grp_forum_subject&amp;group_id=<?php echo $i['group_id'];?>&amp;subject_id=<?php echo $i['subject_id'];?>"><b><?php echo $i['subject_title'];?></b></a><br />
							<?php echo $i['subject_synopsis'];?><br />
						</td>
						<td valign="top" align="center">
							<a href="index.php?amn=core_profile&amp;module_id=<?php echo $core_config['module_id']['group'];?>&amp;identity_id=<?php echo $i['identity']['identity_id'];?>&amp;group_id=<?php echo $group['group_id'];?>">
							<?php echo $i['identity']['identity_nic'];?></a><br />
							<?php echo $this->date->formatDate($i['subject_create_datetime'], 1);?><br />				
						</td>
						<td valign="top" align="center">
							<?php echo $i['total_comments'];?>&nbsp;replies<br />
							
							<?php
							if (!empty($i['latest_comment'])) {
							?>
							<a href="index.php?amn=grp_forum_subject&amp;group_id=<?php echo $i['group_id'];?>&amp;subject_id=<?php echo $i['subject_id'];?>#comment_body_id_<?php echo $i['latest_comment'][0]['comment_id'];?>">latest</a><br />
							<?php echo $this->date->formatDate($i['latest_comment'][0]['comment_create_datetime'], 1);?><br />
							<?php }?>
						</td>
						<td valign="top">
							<?php
							if (!empty($i['subject_locked'])) {
							?>
								<img src="<?php echo $template_path;?>img/locked.png" vspace="2" alt="<?php echo $lang['txt_alt_locked'];?>" border="0" title="<?php echo $lang['txt_locked'];?>" /><br />
							<?php }?>
								
							<?php
							if (!empty($i['subject_sticky'])) {
							?>
								<img src="<?php echo $template_path;?>img/sticky.png" vspace="2" alt="<?php echo $lang['txt_alt_sticky'];?>" border="0" title="<?php echo $lang['txt_sticky'];?>" /><br />
							<?php }?>
						</td>
					</tr>
					<tr>
						<td colspan="5">
							<img src="<?php echo $template_path_core;?>img/pixel.png" alt="" border="0" height="6" width="1" /><br />
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
				<br />
			</div>
		</div>
	</div>
	<?php }?>
	
	<div class="box">
		<div class="box_top">
			<div class="content">
				<h1><?php echo $lang['hdr_recommended'];?></h1>
			</div>
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php 
				if (!empty($recommendations)) { 
				?>
				<table cellspacing="1" cellpadding="4" border="0" width="100%">
					<?php 
					foreach($recommendations as $i): 
					?>
					<tr>
						<td valign="top">
							recommended by 
							<a href="index.php?amn=core_profile&amp;module_id=<?php echo $core_config['module_id']['group'];?>&amp;identity_id=<?php echo $i['identity_id'];?>&amp;group_id=<?php echo $group['group_id'];?>">
							<?php echo $i['identity_nic'];?></a>, 
							<?php echo $this->date->formatDate($i['recommend_create_datetime']);?><br />
							<?php
							if (!empty($i['recommend_note'])) {
							?>
								<i>"<?php echo $i['recommend_note'];?>"</i><br />
							<?php }?>					
						</td>
						<td valign="top">
							<a href="<?php echo $i['item']['item_url'];?>"><b><?php echo $i['item']['item_title'];?></b></a><br />
						</td>
						<td valign="top" align="right">
							<?php
							if (!empty($i['subject_id'])) {
							?>
								<a href="index.php?amn=grp_forum_subject&amp;group_id=<?php echo $group['group_id'];?>&amp;subject_id=<?php echo $i['subject_id'];?>">
								<img src="<?php echo $template_path;?>img/discuss.png" alt="<?php echo $lang['txt_discuss'];?>" border="0" title="<?php echo $lang['txt_discuss'];?>" /></a><br />
							<?php }?>
							<br />
						</td>
					</tr>
					<?php endforeach; ?>
				</table>
				<?php
				}
				else {
					echo $lang['template_error']['err_no_items'];
				}
				?>
				<br />
				
				<table cellspacing="1" cellpadding="4" border="0" width="100%">
					<tr>
						<td align="right">
							<a href="index.php?amn=grp_recommend&amp;group_id=<?php echo $group['group_id'];?>"><?php echo $lang['href_add'];?></a><br />
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
	
	<?php
	if (isset($comments)) {
	?>
	<div class="box">
		<div class="box_top">
			<div class="content">
				<h1><?php echo $lang['hdr_comments'];?></h1>
			</div>
		</div>
		
		<div class="box_mid">
			<div class="content">
					<table cellspacing="1" cellpadding="4" border="0" width="100%">
						<?php
						foreach ($comments as $key => $i):
						?>
						<tr>
							<td valign="top">
								<span class="comment_author">
									<b><?php echo $lang['txt_dated'];?></b> -&#62; 
									<?php echo $this->date->formatDate($i['comment_create_datetime'], 1);?><br />
									<b><?php echo $lang['txt_from'];?></b> -&#62;
									<a href="index.php?amn=core_profile&amp;module_id=<?php echo $core_config['module_id']['group'];?>&amp;identity_id=<?php echo $i['identity_id'];?>&amp;group_id=<?php echo $group['group_id'];?>"><?php echo $i['identity_nic'];?></a>, 
									<?php echo $lang['txt_joined'] . ": " . $this->date->formatDate($i['participation_create_datetime']);?>, 
									<?php 
									if (isset($i['location_name'])) {
										echo $lang['txt_location'] . ": " . $i['location_name'];
									}
									?><br />
								</span>
							</td>
							<td valign="top" align="right">
								<a href="index.php?amn=grp_forum_subject&amp;group_id=<?php echo $i['item_id'];?>&amp;subject_id=<?php echo $i['inner_item_id'];?>#comment_body_id_<?php echo $i['comment_id'];?>">
								<img src="<?php echo $template_path;?>img/discuss.png" alt="<?php echo $lang['txt_discuss'];?>" border="0" title="<?php echo $lang['alt_discuss'];?>" /></a><br />
							</td>
						</tr>
						<tr>
							<td valign="top" colspan="2">
								<div style="overflow: auto; width:490px;" id="comment_body_id_<?php echo $i['comment_id'];?>">
									<?php echo $i['comment_body'];?><br />
								</div>
							</td>
						</tr>
						<?php
						endforeach;
						?>
					</table>
			</div>
		</div>
	</div>
	<?php }?>
</div>

<div class="col_side">
	<?php
	if (isset($_SESSION['user_id'])) {
	?>
	<div class="box">
		<div class="box_top">
			<div class="content">
				<h1><?php echo $lang['hdr_my_participation'];?></h1>
			</div>
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (!empty($participation)) {
				?>
				<table cellspacing="2" cellpadding="2" border="0">
					<tr>
						<td valign="top">
							<?php echo $lang['txt_joined'];?><br />
						</td>
						<td valign="top">
							<?php echo $this->date->formatDate($participation['participation_create_datetime']);?><br />
						</td>
					</tr>
					<?php
					if (isset($participation['role_id'])) {
					?>
					<tr>
						<td valign="top">
							<?php echo $lang['txt_role'];?><br />
						</td>
						<td valign="top">
							<?php echo $lang['user_role'][$participation['role_id']];?><br />
						</td>
					</tr>
					<?php }?>
					
					<?php
					if (isset($participation['status_id'])) {
					?>
					<tr>
						<td valign="top">
							<?php echo $lang['txt_status'];?><br />
						</td>
						<td valign="top">
							<?php echo $lang['user_participation_status'][$participation['status_id']];?><br />
						</td>
					</tr>
					<?php }?>
				</table>
				<?php
				}
				else {
				?>
				<p>
					<?php echo $lang['group_type'][$group['group_type']];?>
				
					<?php
					if (($group['group_type'] == $group_config['type']['membership_type']) || ($group['group_type'] == $group_config['type']['approved']) || ($group['group_type'] == $group_config['type']['open'])) {
					?>
					: <a href="index.php?amn=core_participation&amp;module_id=<?php echo $core_config['module_id']['group'];?>&amp;item_id=<?php echo $group['group_id'];?>" class="href_button"><?php echo $lang['href_join'];?></a><br />
					<?php }?>
				</p>
				<?php }?>
			</div>
		</div>
	</div>
	<?php }?>
	
	
	<div class="box">
		<div class="box_top">
			<div class="content">
				<a href="#" style="float:left;" onClick="javascript:launchPopupWindow('components/core/help.php?help=grp_index#topics');" style="cursor:help;"><img src="<?php echo $template_path_core;?>img/help.png" alt="<?php echo $lang['alt_help'];?>" border="0" /></a>
				
				<h1><?php echo $lang['hdr_topics'];?></h1>
			</div>
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($topics)) {
				foreach ($topics as $key => $i):
				?>
				<p>
					<a href="index.php?amn=grp_forum_topic&amp;group_id=<?php echo $group['group_id'];?>&amp;topic_id=<?php echo $i['topic_id'];?>"><?php echo $i['topic_title'];?></a>
					<?php
					if (!empty($i['subject_count'])) {
						echo "&nbsp;(" . $i['subject_count'] . ")";
					}
					?>
					<br />
				</p>
				
				<?php
				endforeach;
				}
				else {
					if (isset($_SESSION['user_id']) && isset($participation) && ($participation['role_id'] == $group_config['role']['coordinator']) || $_SESSION['user_id'] == $group['user_id']) { // coordinator
						echo $lang['err_no_topics'];
					}
					else {
					echo $lang['template_error']['err_no_items'];
					}
				}
				?>
				<br />
			</div>
		</div>
	</div>
	
	<?php
	if (isset($bookmarks)) {
	?>
	<div class="box">
		<div class="box_top">
			<div class="content">
				<h1><?php echo $lang['hdr_bookmarked_subjects'];?></h1>
			</div>
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				foreach ($bookmarks as $key => $i):
				?>
				<p>
					<a href="index.php?amn=grp_forum_subject&amp;group_id=<?php echo $i['group_id'];?>&amp;subject_id=<?php echo $i['subject_id'];?>"><?php echo $i['subject_title'];?></a><br />
				</p>
				
				<?php
				endforeach;
				?>
			</div>
		</div>
	</div>
	<?php }?>
</div>