<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<?php
if (isset($recommendations)) {
?>
<div class="box">
	<div class="box_top">
		<?php echo $lang['hdr_recommending'];?><br />
	</div>
	
	<div class="box_mid">
		<div class="content">
			<table border="0" cellspacing="0" cellpadding="2" width="100%">
			<?php
			foreach($recommendations as $key => $i):
			?>
			<tr>
				<td valign="top">
					<a href="index.php?amn=lbr_page&amp;page_id=<?php echo $i['page_id'];?>"><b><?php echo $i['page_title'];?></b></a><br />
				</td>
				<td valign="top">
					<?php echo $i['page_synopsis'];?><br />
				</td>
			</tr>
			<?php
			endforeach;
			?>
			</table>
		</div>
	</div>
</div>
<?php }?>

<div class="box">
	<div class="box_top">
		<?php echo $lang['hdr_participation'];?><br />
	</div>
	
	<div class="box_mid">
		<div class="content">
			<?php
			if (isset($user_sets)) {
			?>
			<table border="0" cellspacing="0" cellpadding="2" width="100%">
			<?php
			foreach($user_sets as $key => $i):
			?>
			<tr>
				<td width="32">
					<a href="index.php?amn=lbr_page&amp;set_id=<?php echo $i['set_id'];?>"><img src="get_file.php?file=<?php echo $i['image']['file_md5_name_view'];?>" border="0" alt="<?php echo isset($i['image']['file_save_name']) ? $i['image']['file_save_name'] : $lang['alt_no_image']; ?>" /></a><br />
				</td>
				<td>
					<a href="index.php?amn=lbr_page&amp;set_id=<?php echo $i['set_id'];?>"><b><?php echo $i['set_title'];?></b></a><br />
					<?php echo $i['set_synopsis'];?>
				</td>
			</tr>
			<?php
			endforeach;
			?>
			</table>
			<?php
			} else {
			?>
				<p>
					<?php echo $lang['template_error']['err_no_items'];?><br />
				</p>
			<?php }?>
		</div>
	</div>
</div>

<div class="box">
	<div class="box_top">
		<?php echo $lang['hdr_contributions'];?><br />
	</div>
	
	<div class="box_mid">
		<div class="content">
			<table width="100%" border="0" cellspacing="0" cellpadding="4">
				<tr>
					<td valign="top" width="50%">
						<b><?php echo $lang['txt_latest_revisions'];?></b><br />
						<?php
						if (isset($revisions)) {
						?>
						<table border="0" cellspacing="" cellpadding="2" width="100%">
						<?php
						foreach($revisions as $key => $i):
						?>
						<tr>
							<td valign="top">
								<a href="index.php?amn=lbr_page&amp;page_id=<?php echo $i['page_id'];?>"><b><?php echo $i['page_title'];?></b></a><br />
								<?php echo $this->date->formatDate($i['revision_create_datetime'],1);?><br />
								<?php echo $i['page_synopsis'];?>
							</td>
						</tr>
						<?php
						endforeach;
						?>
						</table>
						<?php
						} else {
						?>
							<p>
								<?php echo $lang['template_error']['err_no_items'];?><br />
							</p>
						<?php }?>
					</td>
					<td valign="top">
						<b><?php echo $lang['txt_latest_comments'];?></b><br />
						<?php
						if (isset($latest_comments)) {
						?>
						<table border="0" cellspacing="0" cellpadding="2" width="100%">
						<?php
						foreach($latest_comments as $key => $i):
						?>
						<tr>
							<td>
								<a href="index.php?amn=lbr_page&amp;page_id=<?php echo $i['item_id'];?>&amp;revision_id=<?php echo $i['inner_item_id'];?>#comment_id<?php echo $i['comment_id'];?>"><?php echo $this->date->formatDate($i['comment_create_datetime']);?></a><br />
								<?php echo $i['comment_body'];?>
							</td>
						</tr>
						<?php
						endforeach;
						?>
						</table>
						<?php
						} else {
						?>
							<p>
								<?php echo $lang['template_error']['err_no_items'];?><br />
							</p>
						<?php }?>
					</td>
				</tr>
			</table>
		</div>
	</div>
</div>