<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_my.inc.php";
require_once($c_node['dir']['class_path'] . 'Library.class.php');
require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');


if (isset($_REQUEST['page'])) {
	$page = $_REQUEST['page'];
}

if (isset($_REQUEST['page_id'])) {
	$page_id = $_REQUEST['page_id'];
}

if (isset($_REQUEST['history_library_id'])) {
	$history_library_id = $_REQUEST['history_library_id'];
}


//append language setup
require_once($languageArrayPath . 'arr_user.lang.php');


//library setup
$library = new Library($db, $c_acs['arr_section']['user'], $date, $file);
$library->section_item_id = $user_id;


//wiki setup
$wiki =& new Text_Wiki();
$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', 'sn_library.php?user_id=' . $user_id . '&page=');
$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', 'sn_library_edit.php?user_id=' . $user_id . '&page=');
$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'user/');
$wiki->setRenderConf('xhtml', 'shockwaveflash', 'base', $c_node['dir']['asset_path'] . 'user/');


// set an array of pages that exist in the library
$pages = $library->getPages();
$wiki->setRenderConf('xhtml', 'wikilink', 'pages', $pages);



if (isset($_REQUEST['contents'])) {
	$output_contents = $library->getContents();

	$display = "contents";

}
elseif (isset($history_library_id)) {
	$output_history = $library->getHistory($history_library_id);

	$display = "history";
}
elseif (isset($page_id)) {
	$output_library = $library->getPageID($page_id);

	//find out if this is the newest article
	$newest_doc = $library->getPageName($output_library['library_page_name']);

	if ($output_library['library_id'] == $newest_doc['library_id']) {
	    $newest = true;
	}

}
elseif (isset($page)) {
	$output_library = $library->getPageName($page);
	$newest = true;
}
else {
	$output_library = $library->getPageDefault();
	$newest = true;
}




if (isset($output_library['library_id'])) {

	$library_id = $output_library['library_id'];

	//Parser library
	$output_library['library_body'] = $wiki->transform($output_library['library_body'], 'Xhtml');
	
	
	//setup comment
	require_once($c_node['dir']['class_path'] . 'Comment.class.php');
	$comment = new Comment($db, $c_node['cms']['item_type']['user_library'], $date);
	$comment->item_id = $library_id;
	
	$output_comments = $comment->getComments();
}


//get library image
if (isset($output_library['file_id'])) {
	$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
	$file->file_id = $output_library['file_id'];
	$output_library['image'] = $file->getFileRecord();
}


//move to template
if (!empty($output_contents)) {
	$body->set('contents', $output_contents);
}

if (!empty($output_history)) {
	$body->set('history', $output_history);
}

if (!empty($newest)) {
	$body->set('newest', $newest);
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_library)) {
	$body->set('library', $output_library);
	$template_pageLink = $lang['txt_library'];
	$template_pageLinkNote = $output_library['library_title'];
}
elseif (empty($display)) { // we will display a button to allow the user to create a first library item
	$body->set('library_first_page', $lang['txt_wiki_default']);
}


if (isset($display)) {
	$body->set('display', $display);
}

if (!empty($output_user)) {
    $body->set('user', $output_user);
}

if (!empty($output_relationship)) {
    $body->set('relationship', $output_relationship);
}

include "inc/footer.inc.php";

?>
