<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";

//ACS check
if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['administration'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['s_homepage'] . "?" . SID);
	exit;
}


require_once($c_node['dir']['class_path'] . 'Acs.class.php');
$acs = new Acs();
$acs->db = $db;
$section_id = $c_acs['arr_section']['user'];
$acs->section_id = $section_id;

//append language setup
require_once($languageArrayPath . 'arr_acs.lang.php');


//ROLES
//get role_id's from config and build the roles array
$config_roles = $c_acs['section_role'][$section_id];
if (!empty($config_roles)) {
	$output_roles = array();
	
	//loop through the array and get the name from the language file
	foreach($config_roles as $key => $i):
		$temp1['role_name'] = $lang['arr_acs']['role'][$i];
		$temp1['role_id'] = $i;
		array_push($output_roles, $temp1);
	endforeach;
}


//RESOURCES
//get resource_id's from config and build the resources array
$config_resources   = $c_acs['section_resource'][$section_id];
$arr_acs            = $lang['arr_acs'];
$resource_privilege = $c_acs['resource_privilege'];
$output_resources = $acs->getResources($config_resources, $resource_privilege, $arr_acs, $output_roles);

	
if(isset($_POST["update_permissions"])){

	$acs->deletePermissions();                          // Resets all the permissions
	
	
	if(!empty($_POST['data']['ids'])){
		foreach($_POST['data']['ids'] as $key => $value){
			$ind = explode("-", $key);
			
			$resource_id  = $ind[0];		// resource_id
			$privilege_id = $ind[1];		// privilege_id
			$role_id      =  $output_roles[$ind[2]]["role_id"];		// role_id
			$acs->insertPermission($role_id, $resource_id, $privilege_id);  // insert privileges
		}
	}

	$output_resources = $acs->getResources($config_resources, $resource_privilege, $arr_acs, $output_roles);
}
	


//move to template
if (!empty($output_roles)) {
    $body->set('roles', $output_roles);
}

if (isset($display)) {
    $body->set('display', $display);
}

if (!empty($output_resources)) {
    $body->set('resources', $output_resources);
}

include "inc/footer.inc.php";

?>
