<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

class Blog {
	// CLASS FUNCTIONS
	// Blog
	// getBlog
	// updateBlog
	// insertBlog
	// getBlogs
	// deleteBlogs
	// getBlogCount
	
	
	
	// Blog --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 6th December 2004
	//
	function Blog($db, $section_id, $date, $file = null) {
		$this->db = $db;
		$this->section_id = $section_id;
		$this->date = $date;
		
		if (isset($file)) {
		    $this->file = $file;
		}
	}//EO Blog



	// getBlog --------------------------------------------------------------------
	// gets a single record from the DB
	// tom calthrop - 22nd May 2004
	//
	function getBlog() {
		$query = "
			SELECT b.blog_id, b.blog_title, b.blog_synopsis, b.blog_create_datetime,
			b.user_id, b.file_id, b.blog_body, b.genre_id, b.section_id, 
			b.level_id, b.degree_id, b.blog_allow_comments  
			FROM " . $this->db->prefix . "_blog b 
			where "
		;
		
		if (isset($this->blog_id)) {
		    $query .= "b.blog_id=" . $this->blog_id . " and ";
		}
		
		$query .= "1=1";
		
		$result = $this->db->SelectLimit($query, 1); //returns last 1 rows
		
		if (isset($result->fields)) {
		
			$temp = $result->fields;
			$this->blog_id = $temp['blog_id'];
			$temp['blog_create_datetime'] = $this->date->formatDate($temp['blog_create_datetime'], 1);

			$result->Close();

			return $temp;
		}
		else {
			$error_info = "function=getBlog class=Blog.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO getBlog


	
	// updateBlog --------------------------------------------------------------------
	// updates a single blog record in DB
	// tom calthrop - 22nd May 2004
	//
	function updateBlog($data) {

		if(empty($data['blog_title'])) {
			$GLOBALS['am_error_log'][] = array(11, null, null);
		}

		if(empty($data['blog_synopsis'])) {
			$GLOBALS['am_error_log'][] = array(21, null, null);
		}

		if(empty($data['blog_body'])) {
			$GLOBALS['am_error_log'][] = array(12, null, null);
		}

		if (empty($this->log)) {
			
			if (empty($data['degree_id'])) {
			    $data['degree_id'] = "null";
			}
			
			if (empty($data['level_id'])) {
			    $data['level_id'] = "null";
			}
			
			if (empty($data['blog_allow_comments'])) {
			    $data['blog_allow_comments'] = "null";
			}
			
			//stops sql errors when backslashes are removed - \"
			$data['blog_title'] = str_replace("'", "\'", $data['blog_title']);
			$data['blog_synopsis'] = str_replace("'", "\'", $data['blog_synopsis']);
			$data['blog_body'] = str_replace("'", "\'", $data['blog_body']);

			$query = "
				UPDATE " . $this->db->prefix . "_blog set
				blog_title='" . $data['blog_title'] . "',
				blog_synopsis='" . $data['blog_synopsis'] . "',
				blog_body='" . $data['blog_body'] . "',
				language_id=" . $data['language_id'] . ", 
				genre_id=" . $data['genre_id'] . ",
				file_id=" . $data['file_id'] . ",
				degree_id=" . $data['degree_id'] . ",
				level_id=" . $data['level_id'] . ", 
				blog_allow_comments=" . $data['blog_allow_comments'] . " 
				WHERE 
				blog_id=" . $data['blog_id']
			;

			$result = $this->db->Execute($query);

			if (empty($result)) {
				$GLOBALS['am_error_log'][] = array(1, 1, $query . "-" . $this->db->ErrorMsg());
			}
		}

	} //EO updateBlog


	
	// insertBlog --------------------------------------------------------------------
	// inserts a single blog in the DB
	// tom calthrop - 22nd May 2004
	//
	function insertBlog($data) {

		if(empty($data['blog_title'])) {
			$GLOBALS['am_error_log'][] = array(11, null, null);
		}

		if(empty($data['blog_synopsis'])) {
			$GLOBALS['am_error_log'][] = array(21, null, null);
		}

		if(empty($data['blog_body'])) {
			$GLOBALS['am_error_log'][] = array(12, null, null);
		}

		if (empty($GLOBALS['am_error_log'])) {
			$datetime = date("Y-m-d H:i:s");
			$datetime = $this->db->DBDate($datetime);

			//stops sql errors when backslashes are removed - \"
			$data['blog_title'] = str_replace("'", "\'", $data['blog_title']);
			$data['blog_synopsis'] = str_replace("'", "\'", $data['blog_synopsis']);
			$data['blog_body'] = str_replace("'", "\'", $data['blog_body']);

			if (empty($data['file_id'])) {
			    $data['file_id'] = "null";
			}
			
			if (empty($data['genre_id'])) {
			    $data['genre_id'] = "null";
			}
			
			if (empty($data['language_id'])) {
			    $data['language_id'] = "null";
			}
			
			if (empty($data['degree_id'])) {
			    $data['degree_id'] = "null";
			}
			
			if (empty($data['level_id'])) {
			    $data['level_id'] = "null";
			}
			
			if (empty($data['blog_allow_comments'])) {
			    $data['blog_allow_comments'] = "null";
			}

			$query = "
				INSERT INTO " . $this->db->prefix . "_blog (
				section_id, 
				section_item_id, 
				blog_title, 
				blog_synopsis, 
				blog_body,
				language_id, 
				file_id, 
				blog_create_datetime, 
				user_id,
				level_id,
				degree_id,
				blog_allow_comments, 
				genre_id
				) values (
				" . $this->section_id . ",
				" . $this->section_item_id . ",
				'" . $data['blog_title'] . "',
				'" . $data['blog_synopsis'] . "',
				'" . $data['blog_body'] . "',
				" . $data['language_id'] . ", 
				" . $data['file_id'] . ",
				" . $datetime . ",
				" . $this->user_id . ",
				" . $data['level_id'] . ",
				" . $data['degree_id'] . ",
				" . $data['blog_allow_comments'] . ",
				" . $data['genre_id'] . "
				)"
			;

			$result = $this->db->Execute($query);

			if (isset($result->fields)) {
				$query = "
					SELECT blog_id  
					FROM " . $this->db->prefix . "_blog 
					WHERE 
					section_id=" . $this->section_id . " AND 
					section_item_id=" . $this->section_item_id . " AND 
					blog_create_datetime=" . $datetime 
				;
		
				$result = $this->db->SelectLimit($query, 1);
				
				if (isset($result->fields['blog_id'])) {
					$this->blog_id = $result->fields['blog_id'];
				}
				else {
					$error_info = "function=insertBlog class=Blog.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
					$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
				}
			}
			else {
				$error_info = "function=insertBlog class=Blog.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	} //EO insertBlog
	
	
	
	// getBlogs --------------------------------------------------------------------
	// returns multiple rows of blogs from DB
	// tom calthrop - 22nd May 2004
	//
	function getBlogs($search=null) {
		$query = "
			SELECT b.blog_id, b.blog_title, b.blog_synopsis, b.blog_create_datetime,
			b.user_id, p.profile_nic, b.file_id, b.blog_body, b.section_id, 
			b.section_item_id, b.blog_allow_comments, p.profile_create_datetime, 
			p.profile_hometown 
			FROM " . $this->db->prefix . "_blog b 
			LEFT JOIN " . $this->db->prefix . "_user_profile p ON b.user_id=p.user_id AND p.profile_default=1 
			WHERE "
		;
		
		if (isset($this->section_id)) {
		    $query .= "b.section_id=" . $this->section_id . " AND ";
		}
			
		if (isset($this->level_id)) {
			$query .= "level_id=" . $this->level_id . " and ";
		}
		
		if (isset($this->degree_id)) {
			$query .= "(degree_id>=" . $this->degree_id . " or degree_id is null) and ";
		}
		
		if (isset($this->genre_id)) {
		    $query .= "b.genre_id=" . $this->genre_id . " AND ";
		}
		
		if (isset($this->section_item_id)) {
			$query .= "b.section_item_id=" . $this->section_item_id . " AND ";
		}
		
		if (isset($this->user_id)) {
			$query .= "b.user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->not_user_id)) {
			$query .= "b.user_id != " . $this->not_user_id . " AND ";
		}
		
		if (isset($this->search)) {
			$query .= "(
				b.blog_title like '%" . $this->search . "%' or
				b.blog_body like '%" . $this->search . "%') AND "
			;
		}
			
		if (isset($this->before_timestamp)) {
			$datetime = date("Y-m-d H:i:s", $this->before_timestamp);
			$datetime = $this->db->DBDate($datetime);
			$query .= "b.blog_create_datetime <= " . $datetime . " AND ";
		}

		if (isset($this->after_timestamp)) {
			$datetime = date("Y-m-d H:i:s", $this->after_timestamp);
			$datetime = $this->db->DBDate($datetime);
			$query .= "b.blog_create_datetime >= " . $datetime . " AND ";
		}
		
		if (isset($this->blog_ids)) {
			$blog_ids = "";
			foreach($this->blog_ids as $key => $i):
				$blog_ids .= $i;
				if (count($this->blog_ids) > $key+1) {
				    $blog_ids .=",";
				}
			endforeach;
			$query .="blog_id in (" . $blog_ids . ") and ";
		}
		
		$query .="1=1 ";
		
		if (isset($this->order_by)) {
		    $query .= "order by b." . $this->order_by;
		}
		else {
			$query .= "order by b.blog_create_datetime desc";
		}
		
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		} 
		else {
			$result = $this->db->Execute($query);
		}
		
		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				
				$temp1 = $result->fields;
				$temp1['blog_create_datetime'] = $this->date->formatDate($temp1['blog_create_datetime'], 1);
				
				if (isset($this->file)) {
					if ($temp1['section_id'] == 1) {
					    $this->file->path = "user";
					}
					elseif ($temp1['section_id'] == 2) {
					    $this->file->path = "group";
					}
				
					if (isset($temp1['file_id'])) {
	 					$this->file->file_id = $temp1['file_id'];
	 					$temp1['image'] = $this->file->getFileRecord();
	 				}
	 				else {
	 					$temp1['image']['file_id'] = "";
	 					$temp1['image']['file'] = $this->file->noimage;
	 				}
				}
				
				//format search results
				if (isset($this->search)) {
					$temp1['blog_synopsis'] = searchTextFormat($search, $temp1['blog_synopsis']);
					$temp1['blog_title'] = searchTextFormat($search, $temp1['blog_title']);
				}
				
				array_push($temp, $temp1);

				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getBlogs class=Blog.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO getBlogs()



	// deleteBlogs --------------------------------------------------------------------
	// deletes multiple rows of blogs from DB
	// tom calthrop - 22nd May 2004
	//
	function deleteBlogs($del_arr) {
		$rownums = count ($del_arr);

		//echo $rownums;

		for ($i=0; $i < $rownums; $i++) {
			$query = "
				DELETE from " . $this->db->prefix . "_blog
				WHERE
				blog_id = " . $del_arr[$i]
			;

			$result = $this->db->Execute($query);

			if (empty($result)) {
				$GLOBALS['am_error_log'][] = array(1, 1, $query . "-" . $this->db->ErrorMsg());
			}
		}
	}//EO deleteBlogs
	
	
	
	
	// getBlogCount --------------------------------------------------------------------
	// will get the coutn of unique page names
	// tom calthrop - 27th December 2004
	//
	function getBlogCount() {
		$query = "
			SELECT DISTINCT blog_id as total 
			FROM " . $this->db->prefix . "_blog 
			WHERE 
			section_id=" . $this->section_id . " and 
			section_item_id=" . $this->section_item_id
		;
		
		$result = $this->db->Execute($query);

		if (isset($result->fields['total'])) {
			return $result->fields['total'];
		}
		else {
			$error_info = "function=getBlogCount class=Blog.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}

	}//EO getBlogCount
}

?>
