<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

//Note setlocale(); is set in the User.class.php at login
//this will affect date output.


class Calendar {
	// CLASS FUNCTIONS
	// Calendar
	// setCalendarBase
	// setBlankDays
	// getCalendar
	// getToDay
	// getDayContent
	// modifyActivityDate
	// populateActivity
	// calculateDate
	
	
	
	var $id;             // Group or user id
	var $db;             // Database connection
	var $tables;         // Head table to use
	var $calendar;       // The aray that contains everything in the calendar
	var $daysinmonth;    // Number of days in month
	var $firstdaynumber; // First day of the month (0 = sun, 6 = sat)
	var $mh, $da, $yr;
	
	
	// Calendar --------------------------------------------------------------------
	// the constuctor
	// Erik Sundelf, 3rd June 2004
	//
	function Calendar($db, $now, $id = null, $type = null) {
		$this->db = $db;
		$this->id  = $id;

		$this->mh  = $now['mon'];
		$this->da  = $now['mday'];
		$this->yr  = $now['year'];

		$this->calendar = array(); // Initialize calendar
	}//EO Calendar

	
	
	
	// setCalendarBase --------------------------------------------------------------------
	// Erik Sundelf, 3rd June 2004
	//
	function setCalendarBase()
	{
		//setup calendar array
		$this->daysinmonth = date("t",mktime(0, 0, 0, $this->mh, 1, $this->yr));

		//get first day of the month (0 = sun, 6 = sat)
		$this->firstdaynumber = date("w",mktime(0,0,0,$this->mh,1,$this->yr));

		//populate the calendar array with dates
		//fill the calendar
		for ($i=0; $i < $this->daysinmonth; $i++) {
			$temp = array(
				'today' => date("d-M-Y",mktime(0,0,0,$this->mh,$i+1,$this->yr)),
				'daynumber' => $i+1,
				'content' => array()
			);

			array_push($this->calendar, $temp);
		}
	}//EO setCalendarBase
	
	
	
	// setBlankDays --------------------------------------------------------------------
	// Erik Sundelf, 3rd June 2004
	//
	function setBlankDays() {
		//work out how many blank calendar spaces to put at the start of the calendar
		$blankdays = 7-(7-$this->firstdaynumber);

		for ($i=0; $i < $blankdays; $i++) {
			array_unshift($this->calendar, array());
		}

		//work out the blank to fill the calendar
		$blankdays = count($this->calendar);
		while($blankdays > 7){
			$blankdays = $blankdays-7;
		} // while
		$blankdays = 7-$blankdays;


		for ($i=0; $i < $blankdays; $i++) {
			array_push($this->calendar, array());
		}
	}//EO setBlankDays
	
	
	
	// getCalendar --------------------------------------------------------------------
	// Erik Sundelf, 3rd June 2004
	//
	function getCalendar() {
		return $this->calendar;
	}//EO getCalendar
	
	
	
	// getToDay --------------------------------------------------------------------
	// Erik Sundelf, 3rd June 2004
	//
	function getToDay($time) {
		// Checks if the view is the current month
		$date = getdate($time);
		$mh  = $date['mon'];
		$yr  = $date['year'];

		if($mh == $this->mh & $yr == $this->yr)
			return date("j",mktime());
		else
			return "";
	}//EO getToDay
	
	
	
	// getDayContent --------------------------------------------------------------------
	// Erik Sundelf, 3rd June 2004
	//
	function getDayContent($day) {
		return $this->calendar[$day-1+$this->firstdaynumber]['content'];
	}//EO getDayContent
	
	
	
	// getDayContent --------------------------------------------------------------------
	// Recalculate the dates so that the matches up the structure of the populating algortihm
	// Erik Sundelf, June 3, 2004
	//
	function modifyActivityDate($activity) {
		$activity_date = $this->calculateDate($activity);

		if(!empty($activity_date[0])) {
			$activity[5] = $activity_date[0];
			$activity["activity_start_datetime"] = $activity_date[0];
		}

		if(!empty($activity_date[1])) {
			$activity[6] = $activity_date[1];
			$activity["activity_end_datetime"] = $activity_date[1];
		}

		return $activity;
	}//EO modifyActivityDate
	
	
	
	// populateActivity --------------------------------------------------------------------
	// Erik Sundelf, 3rd June 2004
	//
	function populateActivity($activity) {
		if(!empty($activity["activity_start_datetime"]))
			$start = strtotime($activity["activity_start_datetime"]);
	    else
			$start = 0;

		if(!empty($activity["activity_end_datetime"])) {
			$end = strtotime($activity["activity_end_datetime"]);
	    }
		else {
			$end = 0;
		}

		// Defines the next month
		if($this->mh+1>12) {
			$next_mh = 1;
			$next_yr = $this->yr+1;
		}
		else {
			$next_mh = $this->mh+1;
			$next_yr = $this->yr;
		}

		// Defines useful dates
		$time_start = mktime(0, 0, 0, $this->mh, 1, $this->yr);
		$time_end = strtotime("+1 month", $time_start);

		if($start>=$time_start & $start<=$time_end) {
			if($end<=$time_end) {
				$ds = date("d", $start);
				$de = date("d", $end);
			}
			else {
				$ds = date("d", $start);
				$de = $this->daysinmonth;
			}

		}
		elseif($end>=$time_start & $end<=$time_end) {
			$ds = 1;
			$de = date("d", $end);
		}
		elseif($start<$time_start & $end>$time_end) {
			$ds = 1;
			$de = $this->daysinmonth;
		}

		if(isset($ds) & isset($de)) {
			for($d = $ds; $d <= $de; $d++) {
				if(!empty($activity["activity_frequency"])) {
					if($activity["activity_frequency"]==3){ // Weekly
						$weekday        = date("w", mktime(0, 0, 0, $this->mh, $d, $this->yr))+1;
						$start_weekday = $activity["activity_start_weekday"];

						if(empty($activity["activity_end_weekday"]))
							$end_weekday = $activity["activity_start_weekday"];
						else
							$end_weekday = $activity["activity_end_weekday"];

						if($start_weekday<=$weekday & $end_weekday>=$weekday)
							array_push($this->calendar[$d-1]['content'], $activity);
					}
					elseif ($activity["activity_frequency"]==9) { // Monthly
						$start_day = $activity["activity_start_day"];

						if(empty($activity["activity_end_day"]))
							$end_day = $activity["activity_start_day"];
						else
							$end_day = $activity["activity_end_day"];

						if($start_day<=$d & $end_day>=$d)
							array_push($this->calendar[$d-1]['content'], $activity);
					}
					elseif ($activity["activity_frequency"]==10) { // Yearly
						$start_day = $activity["activity_start_day"];

						if(empty($activity["activity_end_day"]))
							$end_day = $activity["activity_start_day"];
						else
							$end_day = $activity["activity_end_day"];

						if($start_day<=$d & $end_day>=$d & $activity["activity_start_month"]<=$this->mh & $activity["activity_end_month"]>=$this->mh)
							array_push($this->calendar[$d-1]['content'], $activity);
					}
					else // Daily
						array_push($this->calendar[$d-1]['content'], $activity);
						
				}
				else
					array_push($this->calendar[$d-1]['content'], $activity);
			}
		}
	}//EO populateActivity
	
	
	
	// calculateDate --------------------------------------------------------------------
	// Calculate starting date
	// Erik Sundelf, 3rd June 2004
	//
	function calculateDate($activity){
		$sec[0] = (!empty($activity['activity_start_sec'])) ? $activity['activity_start_sec'] : "01";
		$min[0] = (!empty($activity['activity_start_min'])) ? $activity['activity_start_min'] : "01";
		$hour[0] = (!empty($activity['activity_start_hour'])) ? $activity['activity_start_hour'] : "01";
		$day[0] = (!empty($activity['activity_start_day'])) ? $activity['activity_start_day'] : 1;
		$month[0] = (!empty($activity['activity_start_month'])) ? $activity['activity_start_month'] : $this->mh;
		$year[0] = (!empty($activity['activity_start_year'])) ? $activity['activity_start_year'] : $this->yr;

		$sec[1] = (!empty($activity['activity_end_sec'])) ? $activity['activity_end_sec'] : "01";
		$min[1] = (!empty($activity['activity_end_min'])) ? $activity['activity_end_min'] : "01";
		$hour[1] = (!empty($activity['activity_end_hour'])) ? $activity['activity_end_hour'] : "01";
		$day[1] = (!empty($activity['activity_end_day'])) ? $activity['activity_end_day'] : $this->daysinmonth;
		$month[1] = (!empty($activity['activity_end_month'])) ? $activity['activity_end_month'] : $this->mh;
		$year[1] = (!empty($activity['activity_end_year'])) ? $activity['activity_end_year'] : $this->yr;

		for($i = 0; $i<=1; $i++)
			$activity_date[$i] = mktime($hour[$i], $min[$i], $sec[$i], $month[$i], $day[$i], $year[$i]);

		// Redefining the end date so that it matches the activities
		if(isset($activity["activity_frequency"]) && $activity["activity_frequency"]>0) {

			$freq = $activity["activity_frequency"];
			if($freq==3 || $freq==1) {
				$activity_date[0] = mktime(0, 0, 0, $this->mh, 1, $this->yr);
				$activity_date[1] = strtotime("+1 month -1 day", $activity_date[0]);
			}
		}

		if(!empty($activity["activity_start_datetime"]))
			$activity_date[0] = ($activity_date[0]>=strtotime($activity["activity_start_datetime"])) ? $activity_date[0] : strtotime($activity["activity_start_datetime"]);

		if(!empty($activity["activity_end_datetime"]))
			$activity_date[1] = ($activity_date[1]>=strtotime($activity["activity_end_datetime"])) ? $activity_date[1] : strtotime($activity["activity_end_datetime"]);

		$activity_date[0] = ($activity_date[0]<=mktime(0, 0, 0, $this->mh, 1, $this->yr)) ? date("Y-n-j G:i:s", mktime(0, 0, 0, $this->mh, 1, $this->yr)) : date("Y-n-j G:i:s", $activity_date[0]);
		$activity_date[1] = ($activity_date[1]<=strtotime("+1 month", $activity_date[0])) ? date("Y-n-j G:i:s", strtotime("+1 month", $activity_date[0])) : date("Y-n-j G:i:s", $activity_date[1]);

		if(empty($activity['activity_frequency']) && isset($activity)) {
			$activity_date[0] = $activity['activity_start_datetime'];
			$activity_date[1] = $activity['activity_end_datetime'];
		}

		return $activity_date;
	}//EO calculateDate
}
