<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_lib.inc.php";

if (!empty($group_id)) { // page under group section
    //ACS check
	if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_library'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
		header("Location: g_group.php?group_id=" . $group_id ."&".SID);
		exit;
	}
}


// PROCESS COMMENTS
require_once($c_node['dir']['class_path'] . 'Comment.class.php');
$comment = new Comment($db, $c_node['rsp']['item_type']['library'], $date);
$comment->user_id = $me['user_id'];
if (isset($group_id)) {
    $comment->group_id = $group_id;
}

if (isset($_POST['preview'])) {
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	$output_comment['display_comment_body'] = nl2br(htmlspecialchars($output_comment["comment_body"], ENT_QUOTES));
	$output_comment['comment_body'] = str_replace ('"', '&quot;', $output_comment['comment_body']);
	
	$display = "preview_comment";

}
elseif (isset($_POST['insert'])) {
	$comment->item_id = $library->library_id;
	$comment->insertComment($frmdata);
		
	if (empty($GLOBALS['am_error_log'])) {
		//setup statistics
		require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
		$statistic = new Statistic($db, $date);
		//update stats
		if (!empty($group_id)) { // page under group section
			//group member comments
			$comment->group_id = $group_id;
			unset($comment->rsp_item_type_id, $comment->item_id);
			$comment->user_id = $me['user_id'];
			$statistic->statistic_type_id = $c_node['statistic']['group_member']['total_comments'];
			$statistic->user_id = $me['user_id'];
			$statistic->setStatistic($comment->getCommentCount());
			//group stats
			unset($comment->user_id, $statistic->user_id);
			$statistic->statistic_type_id = $c_node['statistic']['group']['total_comments'];
			$statistic->setStatistic($comment->getCommentCount());
		}

		$statistic->statistic_type_id = $c_node['statistic']['user']['total_comments'];
		$statistic->section_id = $c_acs['arr_section']['user'];
		$comment->user_id = $me['user_id'];
		unset($comment->item_id, $comment->rsp_item_type_id, $comment->section_id, $comment->section_item_id);
		$statistic->user_id = $me['user_id'];
		$statistic->setStatistic($comment->getCommentCount());
		
		if (!empty($group_id)) { // page under group section
			return header("Location: lib_item.php?group_id=". $group_id . "&library_id=". $library->library_id . "&" . SID);
		}
		else {
			return header("Location: lib_item.php?user_id=". $user_id . "&library_id=". $library->library_id . "&" . SID);
		}	
		exit;
	}
}
elseif (isset($_POST['edit_again'])) {
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
}


if (isset($library->library_id)) {
	$output_library = $library->getPageID($library->library_id);

	//find out if this is the newest article
	$newest_doc = $library->getPageName($output_library['library_page_name']);

	if ($output_library['library_id'] == $newest_doc['library_id']) {
	    $newest = true;
	}

}
elseif (isset($page)) {
	$output_library = $library->getPageName($page);
	$newest = true;
}
else {
	$output_library = $library->getPageDefault();
	$newest = true;
}


if (!empty($output_library)) {
	//wikify body
	if (!empty($output_library['group_id'])) { // page under group section
	    $wiki_path = "lib_item.php?group_id=" . $output_library['group_id'] . "&page=";
		$wiki_new_path = "lib_edit.php?group_id=" . $output_library['group_id'] . "&page=";
		$wiki_image_base = "get_file.php?file=group/";

	}
	else {
	    $wiki_path = "lib_item.php?user_id=" . $output_library['user_id'] . "&page=";
		$wiki_new_path = "lib_edit.php?page=";
		$wiki_image_base = "get_file.php?file=user/";
	}
	require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');
	$wiki =& new Text_Wiki();
	$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', $wiki_path);
	$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', $wiki_new_path);
	$wiki->setRenderConf('xhtml', 'image', 'base', $wiki_image_base);
	$wiki->setRenderConf('xhtml', 'swf', 'base', $wiki_image_base);
	
	
	//ACS check - can we edit the library - if we are not a member we turn off the ability to make new links
	if (isset($group_id) && !$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_library'], $c_acs['arr_acs']['privilege']['allow_edit'])) { //resourece_id, Priv_id
		$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', ''); // turn off the ability to link pages
		$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', '#'); // turn off the ability to create new pages
	}
	
	// set an array of pages that exist in the library
	$pages = $library->getPages();
	$wiki->setRenderConf('xhtml', 'wikilink', 'pages', $pages);
	
	$output_library['library_body_display'] = $wiki->transform($output_library['library_body'], 'Xhtml');
	
	//get the group and/or the author
	$user->user_id = $output_library['user_id'];
	$output_author = $user->getProfile();
	
	
	//setup bookmarks --------------------------------------------------
	require_once($c_node['dir']['class_path'] . 'Bookmark.class.php');
	$bookmark = new Bookmark($db, $c_node['rsp']['item_type']['library'], $date, $me['user_id']);
	$bookmark->item_id = $library->library_id;
	
	//watching
	$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
	//set or unset bookmarks
	if (isset($_REQUEST['watch'])) {
		$bookmark->insertBookmark();
	}
	elseif (isset($_REQUEST['unwatch'])) {
		$bookmark->deleteBookmark();
	}
	//get and update bookmark
	if ($bookmark->getBookmark()) {
		$bookmark->updateBookmark();
		$tpl->set('toolbar_watch', 1);
	}
	
	//recommended
	$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
	//set or unset bookmarks
	if (isset($_REQUEST['recommend'])) {
		$bookmark->insertBookmark();
	}
	elseif (isset($_REQUEST['unrecommend'])) {
		$bookmark->deleteBookmark();
	}
	//get and update bookmark
	if ($bookmark->getBookmark()) {
		$bookmark->updateBookmark();
		$tpl->set('toolbar_recommend', 1);
	}
	
	
	//get comments
	unset($comment->user_id);
	$output_comments = $comment->selComments($library->library_id);
	
	
	
	//get RSP items if I am looking at my blog
	if ($output_library['user_id'] == $me['user_id']) {
		require_once($languageArrayPath . 'arr_rsp.lang.php');
		require_once($c_node['dir']['class_path'] . 'Rsp.class.php');
		$rsp = new Rsp($db, $c_node['rsp']['item_type']['library']);
		$output_library['rsp'] = $rsp->selRspItem($library->library_id);
		
		$body->set('rsp_config', $c_node['rsp']); 
	}
}



//move vars to template
if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($output_library)) {
	$body->set('library', $output_library);
	$template_pageLink = $lang['txt_library'];
	$template_pageLinkNote = $output_library['library_title'];
}
elseif (empty($display)) { // we will display a button to allow the user to create a first library item
	$body->set('library_first_page', $lang['txt_wiki_default']);
}


if (!empty($output_profile)) {
	$body->set('profile', $output_profile);
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($newest)) {
	$body->set('newest', $newest);
}

if (!empty($output_comment)) {
	$body->set('comment', $output_comment);
}

if (!empty($output_author)) {
	$body->set('author', $output_author);
}

if (!empty($output_statistic)) {
	$body->set('profile_statistic', $output_statistic);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
}

//setup print options
$tpl->set('toolbar_print', 'print_item.php?library_id=' . $output_library['library_id']);
$tpl->set('toolbar_printc', 'print_item.php?library_id=' . $output_library['library_id'] . '&amp;inc_comment=1');

if (isset($_REQUEST['group_id'])) {
	$tpl->set('toolbar_bookmark_url', 'lib_item.php?group_id=' . $_REQUEST['group_id'].'&amp;library_id=' . $output_library['library_id']);
}
else {
	$tpl->set('toolbar_bookmark_url', 'lib_item.php?library_id=' . $output_library['library_id']);
}

if (isset($output_library['library_title'])) {
    $template_pageLink = $lang['txt_library'];
	$template_pageLinkNote = $output_library['library_title'];
}

$tpl->set('info_pages', '13'); //setup help button

include "inc/footer.inc.php";

?>