<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_pre_login.inc.php";
include "config/config_acs.inc.php";


if (isset($_REQUEST['blog_id'])) {
    $blog_id = $_REQUEST['blog_id'];
}

if (isset($_REQUEST['library_id'])) {
    $library_id = $_REQUEST['library_id'];
}

if (isset($_REQUEST['section_id'])) {
    $section_id = $_REQUEST['section_id'];
}

//setup file
require_once($c_node['dir']['class_path'] . 'File.class.php');
$file = new File($db, null, $c_node['file'], $c_node['dir']);
$file->noimage = $c_node['file']['image']['thumb'][2]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][2]['name'];
$file->config_ids = $c_node['file'];

		
//setup Wiki
require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');
$wiki =& new Text_Wiki();
$wiki->disableRule('Freelink');
$wiki->disableRule('wikilink');


// SETUP USER -----------------------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'User.class.php');
$user = new User($db, $date);


if (isset($blog_id)) {
	require_once($c_node['dir']['class_path'] . 'Blog.class.php');
	$blog = new Blog($db, $c_node['rsp']['item_type']['blog'], $date, $file);
	$blog->blog_id = $blog_id;
	$output_blog = $blog->getBlog();
	
	if (isset($group_id)) {
		$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'group/');
		$wiki->setRenderConf('xhtml', 'swf', 'base', $c_node['dir']['asset_path'] . 'group/');
	}
	else {
	    $wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'user/');
		$wiki->setRenderConf('xhtml', 'swf', 'base', $c_node['dir']['asset_path'] . 'user/');
	    
	}
	
	$output_blog['blog_body_display'] = $wiki->transform($output_blog['blog_body'], 'Xhtml');
	
	if (isset($output_blog['user_id'])) {
		$user->user_id = $output_blog['user_id'];
    	$output_author = $user->getProfile();
	}
}


if (isset($library_id)) {
	require_once($c_node['dir']['class_path'] . 'Library.class.php');
	$library = new Library($db, $c_node['rsp']['item_type']['library'], $date, $file);
	$library->library_id = $library_id;
	$output_library_item = $library->getPageID();
	
	if ($output_library_item['section_id'] == $c_acs['arr_section']['user']) {
	    $wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'user/');
		$wiki->setRenderConf('xhtml', 'shockwaveflash', 'base', $c_node['dir']['asset_path'] . 'user/');
	}
	elseif ($output_library_item['section_id'] == $c_acs['arr_section']['group']) {
	    $wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'group/');
		$wiki->setRenderConf('xhtml', 'shockwaveflash', 'base', $c_node['dir']['asset_path'] . 'group/');
	}
	
	$output_library_item['library_body'] = $wiki->transform($output_library_item['library_body'], 'Xhtml');
	$output_library_item['display_library_create_datetime'] = $date->formatDate($output_library_item['library_create_datetime'], 1);
	
	if (isset($output_library_item['user_id'])) {
		$user->user_id = $output_library_item['user_id'];
    	$output_author = $user->getProfile();
	}
}


//move to template
if (!empty($output_blog)) {
	$body->set('blog', $output_blog);
}

if (!empty($output_library_item)) {
	$body->set('library', $output_library_item);
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_comment)) {
	$body->set('comment', $output_comment);
}

if (!empty($output_author)) {
	$body->set('author', $output_author);
}

if (!empty($allow_add_comment)) {
	$body->set('allow_add_comment', $allow_add_comment);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (isset($output_poll_history)) {
	$body->set('poll_history', $output_poll_history);
}

include "inc/footer_pre_login.inc.php";
?>
