<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


include "inc/header_schedule.inc.php";

if (!empty($group_id)) { // page under group section
    //ACS check
	if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_schedule'], $c_acs['arr_acs']['privilege']['allow_edit'])) { //resourece_id, Priv_id
		header("Location: g_group.php?group_id=" . $group_id ."&".SID);
		exit;
	}
}


//SETUP RSP ---------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Rsp.class.php');
$rsp = new Rsp($db, $c_node['rsp']['item_type']['schedule']);
$rsp->user_id = $me['user_id'];

if($c_node['rsp']['node']['auto_publish'] == 1) {
	$rsp->status_id = $c_node['rsp']['status']['live'];
}
else {
	$rsp->status_id = $c_node['rsp']['status']['pending'];
}

if (isset($group_id)) {
    $rsp->group_id = $group_id;
}


//RECEIVE POST AND PROCESS ---------------------------------------------------------
if (!empty($frmdata)) {
	if (!empty($frmdata['group_id'])) {
	    $wiki_path = "g_library.php?group_id=" . $frmdata['group_id'] . "&page=";
		$wiki_new_path = "g_library_edit.php?group_id=" . $frmdata['group_id'] . "&page=";
		$wiki_image_base = $c_node['dir']['asset_path'] . "group/";
	}
	else {
	    $wiki_path = "my_library.php?page=";
		$wiki_new_path = "lib_edit.php?page=";
		$wiki_image_base = $c_node['dir']['asset_path'] . "user/";
	}

	require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');
	//wiki setup
	$wiki =& new Text_Wiki();
	$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', $wiki_path);
	$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', $wiki_new_path);
	$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . $wiki_image_base);


	$frmdata['schedule_synopsis'] = htmlspecialchars($frmdata['schedule_synopsis']);
	$frmdata['schedule_title'] = htmlspecialchars($frmdata['schedule_title']);


	if (isset($frmdata['preview'])) {
		$frmdata['schedule_body'] = stripslashes($frmdata['schedule_body']);
		$frmdata['schedule_synopsis'] = stripslashes($frmdata['schedule_synopsis']);
		$frmdata['schedule_title'] = stripslashes($frmdata['schedule_title']);
		$frmdata['schedule_body_preview'] = $wiki->transform($frmdata['schedule_body'], 'Xhtml');

		$output_schedule = $frmdata;

		$display = "edit_overview";
	}
	elseif (isset($frmdata['save_overview']) || isset($frmdata['save_go_overview'])) {


		if (!empty($frmdata['schedule_start_date'])) {
			if (!empty($frmdata['schedule_start_time'])) {
		    	$frmdata['schedule_start_datetime'] = $date->formatFormDateTime($frmdata['schedule_start_date'], $frmdata['schedule_start_time']);
			}
			else {
				$frmdata['schedule_start_datetime'] = $date->formatFormDateTime($frmdata['schedule_start_date']);
			}
		}
		else {
			$GLOBALS['am_error_log'][] = array(38, null, null);
		}

		if (!empty($frmdata['schedule_end_date'])) {
			if (!empty($frmdata['schedule_end_time'])) {
		    	$frmdata['schedule_end_datetime'] = $date->formatFormDateTime($frmdata['schedule_end_date'], $frmdata['schedule_end_time']);
			}
			else {
				$frmdata['schedule_end_datetime'] = $date->formatFormDateTime($frmdata['schedule_end_date']);
			}
		}
		else {
			$GLOBALS['am_error_log'][] = array(39, null, null);
		}

		if (empty($frmdata['schedule_title'])) {
		    $GLOBALS['am_error_log'][] = array(11, null, null);
		}

		if (!empty($frmdata['schedule_allocation']) && !is_numeric($frmdata['schedule_allocation'])) {
		    $GLOBALS['am_error_log'][] = array(40, null, null);
		}

		if (empty($frmdata['schedule_synopsis'])) {
		    $GLOBALS['am_error_log'][] = array(30, null, null);
		}

		if (empty($GLOBALS['am_error_log'])) {
			//
			if (isset($frmdata['schedule_id']) && $frmdata['schedule_id'] > 0) {
		         //we update the event
		 		$schedule->updateScheduleItem($frmdata);
			}
		 	else { //we insert record
		 		$schedule->user_id = $me['user_id'];
		 		$schedule->insertScheduleItem($frmdata);
		 	}

			if (empty($GLOBALS['am_error_log'])) {


				//insert into setup rsp
				$temp['language_id'] = $frmdata['language_id'];
				$temp['item_id'] = $schedule->schedule_id;
				//delete all
				$rsp->deleteRspItem($schedule->schedule_id);

				//insert node rsp entry
				if (!empty($frmdata['rsp_degree'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['degree'];
					if ($frmdata['rsp_degree'] == "all") {
					    $temp['degree_id'] = "null";
					}
					else {
						$temp['degree_id'] = $frmdata['rsp_degree'];
					}
					$rsp->insertRspItem($temp);
				}

				if (!empty($frmdata['rsp_node'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['node'];
					$rsp->insertRspItem($temp);
				}

				if (!empty($frmdata['rsp_public'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['public'];
					$rsp->insertRspItem($temp);
				}

				if (isset($frmdata['rsp_group'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['group']['home'];

					$rsp->insertRspItem($temp);
				}

				if (isset($frmdata['save_go_overview'])) {
					if (!empty($frmdata['group_id'])) { // page under group section
					    header("Location: sch_item.php?group_id=" . $frmdata['group_id'] . "&schedule_id=" . $schedule->schedule_id . "&".SID);
						exit;
					}
					else {
						header("Location: sch_item.php?schedule_id=" . $schedule->schedule_id . "&".SID);
						exit;
					}
				}
				else {
					if (!empty($frmdata['group_id'])) { // page under group section
						header("Location: sch_edit.php?group_id=" . $frmdata['group_id'] . "&schedule_id=" . $schedule->schedule_id . "&".SID);
						exit;
					}
					else {
						header("Location: sch_edit.php?schedule_id=" . $schedule->schedule_id . "&".SID);
						exit;
					}
				}
			}
		}
		else { // somehing errored
			$output_schedule = $frmdata;
		}

		$display = "edit_overview";


	}
}
elseif (isset($_REQUEST['schedule_id']) && $_REQUEST['schedule_id'] > 0) {
	$schedule_id = $_REQUEST['schedule_id'];
	$schedule->schedule_id = $schedule_id;
	$schedule->user_id = $me['user_id']; // gets my allocation
	$output_schedule = $schedule->selScheduleItem();

	if ($output_schedule['user_id'] == $me['user_id']) { // we are allowed to edit
	    $display = "edit_overview";
	}
	else {
		unset($output_schedule, $display);
	}
}
else { // we add a record

	$display = "edit_overview";
}


//format dates
if (isset($output_schedule['schedule_start_datetime'])) {
	$output_schedule['schedule_start_date'] = substr($output_schedule['schedule_start_datetime'], 0,10);
	$output_schedule['schedule_end_date'] = substr($output_schedule['schedule_end_datetime'], 0,10);
	$output_schedule['schedule_start_time'] = substr($output_schedule['schedule_start_datetime'], 11,15);
	$output_schedule['schedule_end_time'] = substr($output_schedule['schedule_end_datetime'], 11,15);
}
else {
	$output_schedule['schedule_start_date'] = date('Y-m-d');
	$output_schedule['schedule_end_date'] = date('Y-m-d');
	$output_schedule['schedule_start_time'] = date('H:i');
	$output_schedule['schedule_end_time'] = date('H:i');
}


if ((isset($_REQUEST['schedule_type_id']) && $_REQUEST['schedule_type_id'] == 2) || (isset($output_schedule['schedule_type_id']) && $output_schedule['schedule_type_id'] == 2)) { // task
	//we overwrite the standard language file the tasks version
	require_once($languagePath . 'sch_edit_task.lang.php');
}


//setup file ----------------------------------------------------------------
if (!empty($_REQUEST['group_id'])) { // page under group section
	$file->section_id = $c_node['arr_section']['group'];
	$file->section_item_id = $_REQUEST['group_id'];
}
$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
$file->type_ids[] = $c_node['file']['mime'][1]['suffix']; //jpg
$file->type_ids[] = $c_node['file']['mime'][2]['suffix']; //png
$file->type_ids[] = $c_node['file']['mime'][3]['suffix']; //gif

$output_images = $file->getFiles();


//language and language file manipulation --------------------------------------------
if (!empty($_REQUEST['group_id'])) { // page under group section
	$lang['hdr_group_schedule'] = str_replace('GROUPTITLE', $output_group['group_title'], $lang['hdr_group_schedule']);
	$output_schedule['language_id'] = $output_group['language_id'];
}
else {
	$output_schedule['language_id'] = $me['language_id'];
}

//RSP items
if (!empty($schedule->schedule_id)) {
	$output_schedule['rsp'] = $rsp->selRspItem($schedule->schedule_id);
	//print_r($output_schedule['rsp']);
}


//move to template ---------------------------------------------------------
if (!empty($c_node['schedule']['occurrence'])) {
   $body->set('occurrence_ids', $c_node['schedule']['occurrence']);
}

if (!empty($output_schedule)) {
   $body->set('schedule', $output_schedule);
}

if (isset($display)) {
   $body->set('display', $display);
}

if (!empty($output_images)) {
	$body->set('images', $output_images);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
}

$body->set('languagePath', $languagePath);

$body->set('rspconfig', $c_node['rsp']);

$tpl->set('info_pages', '2,3,4,5,6'); //setup help button

include "inc/footer.inc.php";

?>
