<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_schedule.inc.php";

if (!empty($_REQUEST['group_id'])) { // page under group section
	//ACS check
	if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_schedule'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
		header("Location: g_group.php?group_id=" . $_REQUEST['group_id']."&".SID);
		exit;
	}
}


//see if we have a start date
if(!empty($frmdata['start_date'])) { // default is today
	$schedule->start_date = $date->formatFormDateTime($frmdata['start_date']);
}
else {
	$frmdata['start_date'] = date("Y-m-d"); //now
}


if(!empty($frmdata['schedule_show'])) { //default is 5
	$schedule->no_of_days_shown = $frmdata['schedule_show'];
}

if(!empty($frmdata['schedule_network']) && $frmdata['schedule_network'] == 2) { // friends only
	$schedule->user_ids = $_SESSION['s_social_network'];
}

if(!empty($frmdata['schedule_status'])) {
	$schedule->status_id = $lang['schedule']['arr_event_status'][1];
}


// get schedule items
$schedule->file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
$schedule->file->thumb = $c_node['file']['image']['thumb'][3]['name'];


$schedule->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
$schedule->rsp_status_id = $c_node['rsp']['status']['live'];

if (!empty($_REQUEST['group_id'])) { // page under group section
	unset($schedule->user_id);
	$output_schedule_items = $schedule->selScheduleItems();
}
elseif ($menu_section == "my") {
    $output_schedule_items = $schedule->selScheduleItems();
}
else {
	unset($schedule->user_id);
	$output_schedule_items = $schedule->selRspScheduleItems();
}


if ($output_schedule['schedule_type_id'] == $c_node['schedule']['type']['task']) {
    $display = "task";
}

//get the total future items --------------------------------------------
$total_schedule_items = $schedule->countScheduleItems();
$lang['txt_event_summary'] = str_replace('SCHEDTOTAL', $total_schedule_items, $lang['txt_event_summary']);
$lang['txt_task_summary'] = str_replace('SCHEDTOTAL', $total_schedule_items, $lang['txt_task_summary']);





//move to template
if (!empty($output_schedule_items)) {
   $body->set('schedule_items', $output_schedule_items);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (!empty($frmdata)) {
    $body->set('search', $frmdata);
}


$body->set('languagePath', $languagePath);
$tpl->set('info_pages', '8,9');
$body->set('schedule_type_id', $output_schedule['schedule_type_id']);
$tpl->set('schedule_type_id', $output_schedule['schedule_type_id']);

$template_pageLink = $lang['txt_schedule_items'];

include "inc/footer.inc.php";

?>
