<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_blg.inc.php";

if (!empty($_REQUEST['group_id'])) { // page under group section
    //ACS check
	if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_blog'], $c_acs['arr_acs']['privilege']['allow_edit'])) { //resourece_id, Priv_id
		header("Location: g_group.php?group_id=" . $_REQUEST['group_id']."&".SID);
		exit;
	}
}


//SETUP RSP ---------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Rsp.class.php');
$rsp = new Rsp($db, $c_node['rsp']['item_type']['blog']);
$rsp->user_id = $me['user_id'];

if($c_node['rsp']['node']['auto_publish'] == 1) {
	$rsp->status_id = $c_node['rsp']['status']['live'];
}
else {
	$rsp->status_id = $c_node['rsp']['status']['pending'];
}

if (isset($group_id)) {
    $rsp->group_id = $group_id;
}


//RECEIVE POST AND PROCESS ---------------------------------------------------------
if (!empty($frmdata)) {
	if (!empty($frmdata['group_id'])) { // page under group section
	    $wiki_path = "lib_item.php?group_id=" . $frmdata['group_id'] . "&page=";
		$wiki_new_path = "lib_edit.php?group_id=" . $frmdata['group_id'] . "&page=";
		$wiki_image_base = "get_file.php?file=group/";
	}
	else {
	    $wiki_path = "lib_item.php?user_id=" . $me['user_id'] . "&page=";
		$wiki_new_path = "lib_edit.php?page=";
		$wiki_image_base = "get_file.php?file=user/";
	}

	require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');
	//wiki setup
	$wiki =& new Text_Wiki();
	$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', $wiki_path);
	$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', $wiki_new_path);
	$wiki->setRenderConf('xhtml', 'image', 'base', $wiki_image_base);



	$frmdata['blog_synopsis'] = htmlspecialchars($frmdata['blog_synopsis']);
	$frmdata['blog_title'] = htmlspecialchars($frmdata['blog_title']);


	if (isset($frmdata['preview'])) {
		$frmdata['blog_body'] = stripslashes($frmdata['blog_body']);
		$frmdata['blog_synopsis'] = stripslashes($frmdata['blog_synopsis']);
		$frmdata['blog_title'] = stripslashes($frmdata['blog_title']);
		$frmdata['blog_body_preview'] = $wiki->transform($frmdata['blog_body'], 'Xhtml');

		if (!empty($frmdata['rsp_degree'])) {
			$frmdata['rsp'][] = array('level_id' => $c_node['rsp']['rsp_level']['degree'], 'degree_id' => $frmdata['rsp_degree']);
		}
		
		if (!empty($frmdata['rsp_node'])) {
			$frmdata['rsp'][] = array('level_id' => $c_node['rsp']['rsp_level']['node']);
		}
		
		if (!empty($frmdata['rsp_public'])) {
			$frmdata['rsp'][] = array('level_id' => $c_node['rsp']['rsp_level']['public']);
		}
		
		if (!empty($frmdata['rsp_group'])) {
			$frmdata['rsp'][] = array('level_id' => $c_node['rsp']['rsp_level']['group']);
		}
		
		$output_blog = $frmdata;
		
		$display = "allow_edit";
	}
	elseif (isset($frmdata['save']) || isset($frmdata['save_go'])) {

		if (empty($frmdata['blog_title'])) {
		    $GLOBALS['am_error_log'][] = array(11, null, null);
		}

		if (empty($frmdata['blog_synopsis'])) {
		    $GLOBALS['am_error_log'][] = array(30, null, null);
		}

		if (empty($frmdata['language_id'])) {
		    $frmdata['language_id'] = $me['language_id'];
		}

		if (empty($GLOBALS['am_error_log'])) {
			//
			if (isset($frmdata['blog_id']) && $frmdata['blog_id'] > 0) {
		         //we update the event
		 		$blog->updateBlog($frmdata);
			}
		 	else { //we insert record
		 		$blog->user_id = $me['user_id'];
		 		$blog->insertBlog($frmdata);

		 	}

			if (empty($GLOBALS['am_error_log'])) {
				//insert into setup rsp
				if (!empty($frmdata['group_id'])) {
				    $temp['language_id'] = $output_group['language_id'];
				}
				else {
					$temp['language_id'] = $me['language_id'];
				}

				$temp['item_id'] = $blog->blog_id;
				//delete all
				$rsp->deleteRspItem($blog->blog_id);

				//insert node rsp entry
				if (!empty($frmdata['rsp_degree'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['degree'];
					if ($frmdata['rsp_degree'] == "all") {
					    $temp['degree_id'] = "null";
					}
					else {
						$temp['degree_id'] = $frmdata['rsp_degree'];
					}
					$rsp->insertRspItem($temp);
				}

				if (!empty($frmdata['rsp_node'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['node'];
					$rsp->insertRspItem($temp);
				}

				if (isset($frmdata['rsp_group'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['group']['home'];

					$rsp->insertRspItem($temp);
				}
				
				if (!empty($frmdata['rsp_public'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['public'];
					$rsp->status_id = $c_node['rsp']['status']['pending'];
					$rsp->insertRspItem($temp);
				}
				
				//setup statistics
				require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
				$statistic = new Statistic($db, $c_node['rsp']['item_type']['blog'], $date);

				//update stats
				if (!empty($frmdata['group_id'])) { // page under group section
					$statistic->section_item_id = $frmdata['group_id'];
					$statistic->statistic_type_id = $c_node['statistic']['group']['total_blogs'];
				}
				else {
					$statistic->user_id = $me['user_id'];
					$statistic->section_item_id = $me['user_id'];
					$statistic->statistic_type_id = $c_node['statistic']['user']['total_blogs'];
				}

				$statistic->setStatistic($blog->getBlogCount());

				//get member blog stats
				if (!empty($frmdata['group_id'])) { // page under group section
					$statistic->user_id = $me['user_id'];
					$statistic->statistic_type_id = $c_node['statistic']['group_member']['total_blogs'];
					$statistic->setStatistic($blog->getBlogCount($me['user_id']));
				}


				if (isset($frmdata['save_go'])) {
					if (!empty($frmdata['group_id'])) { // page under group section
					    header("Location: blg_item.php?group_id=" . $frmdata['group_id'] . "&blog_id=" . $blog->blog_id . "&".SID);
						exit;
					}
					else {
						header("Location: blg_item.php?blog_id=" . $blog->blog_id . "&".SID);
						exit;
					}
				}
				else {
					if (!empty($frmdata['group_id'])) { // page under group section
						header("Location: blg_edit.php?group_id=" . $frmdata['group_id'] . "&blog_id=" . $blog->blog_id . "&".SID);
						exit;
					}
					else {
						header("Location: blg_edit.php?blog_id=" . $blog->blog_id . "&".SID);
						exit;
					}
				}
			}
		}
		else { // somehing errored
			$output_blog = $frmdata;
		}

		$display = "allow_edit";


	}
}
elseif (isset($_REQUEST['blog_id']) && $_REQUEST['blog_id'] > 0) {
	$blog->blog_id = $_REQUEST['blog_id'];
	$output_blog = $blog->getBlog();

	if (isset($output_blog['user_id']) && $output_blog['user_id'] == $me['user_id']) { // we are allowed to edit
	    $display = "allow_edit";
	}
	else {
		unset($output_blog, $display);
	}
}
else { // we add a record

	$display = "allow_edit";
}


//setup file ----------------------------------------------------------------
$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
$file->type_ids[] = $c_node['file']['mime'][1]['suffix']; //jpg
$file->type_ids[] = $c_node['file']['mime'][2]['suffix']; //png
$file->type_ids[] = $c_node['file']['mime'][3]['suffix']; //gif

$output_images = $file->getFiles();


//language and language file manipulation --------------------------------------------
if (!empty($group_id)) { // page under group section
	$lang['hdr_blog'] = str_replace('GROUPTITLE', $output_group['group_title'], $lang['hdr_group_blog']);
}

//RSP items
if (!empty($blog->blog_id)) {
	$output_blog['rsp'] = $rsp->selRspItem($blog->blog_id);
}

//language and language file manipulation --------------------------------------------
if (!empty($_REQUEST['group_id'])) { // page under group section
	$lang['hdr_group_blog'] = str_replace('GROUPTITLE', $output_group['group_title'], $lang['hdr_group_blog']);
}



//move vars to template
if (!empty($output_user)) {
	$body->set('user', $output_user);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_blog)) {
	$body->set('blog', $output_blog);
}

if (!empty($output_blogs)) {
	$body->set('blogs', $output_blogs);
}

if (!empty($output_images)) {
	$body->set('images', $output_images);
	$body->set('image_thumbs', $c_node['file']['image']['thumb']);
}

$body->set('rspconfig', $c_node['rsp']);

include "inc/footer.inc.php";

?>
