<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_lib.inc.php";

if (!isset($library->library_id) && !isset($page)) {
	if (!empty($group_id)) { // page under group section
		header("Location: lib_item.php?group_id=" . $group_id . "&" . SID);
	}
	else {
		header("Location: lib_item.php?" . SID);
	}
	exit;
}

if (!empty($group_id)) { // page under group section
    //ACS check
	if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_library'], $c_acs['arr_acs']['privilege']['allow_edit'])) { //resourece_id, Priv_id
		header("Location: lib_item.php?group_id=" . $group_id ."&".SID);
		exit;
	}
}





//SETUP RSP ---------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Rsp.class.php');
$rsp = new Rsp($db, $c_node['rsp']['item_type']['library']);
$rsp->user_id = $me['user_id'];

if($c_node['rsp']['node']['auto_publish'] == 1) {
	$rsp->status_id = $c_node['rsp']['status']['live'];
}
else {
	$rsp->status_id = $c_node['rsp']['status']['pending'];
}

if (isset($group_id)) {
    $rsp->group_id = $group_id;
}

// SETUP WIKI ----------------------------------------------------------------------
if (!empty($frmdata['group_id'])) { // page under group section
	$wiki_path = "lib_item.php?group_id=" . $frmdata['group_id'] . "&page=";
	$wiki_new_path = "lib_edit.php?group_id=" . $frmdata['group_id'] . "&page=";
	$wiki_image_base = "get_file.php?file=group/";

}
else {
	$wiki_path = "lib_item.php?user_id=" . $me['user_id'] . "&page=";
	$wiki_new_path = "lib_edit.php?page=";
	$wiki_image_base = "get_file.php?file=user/";
}

require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');
//wiki setup
$wiki =& new Text_Wiki();
$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', $wiki_path);
$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', $wiki_new_path);
$wiki->setRenderConf('xhtml', 'image', 'base', $wiki_image_base);


// set an array of pages that exist in the library
$pages = $library->getPages();
$wiki->setRenderConf('xhtml', 'wikilink', 'pages', $pages);


//RECEIVE POST AND PROCESS ---------------------------------------------------------
if (!empty($frmdata)) {

	$frmdata['library_synopsis'] = htmlspecialchars($frmdata['library_synopsis']);
	$frmdata['library_title'] = htmlspecialchars($frmdata['library_title']);


	if (isset($frmdata['preview'])) {
		$frmdata['library_body'] = stripslashes($frmdata['library_body']);
		$frmdata['library_synopsis'] = stripslashes($frmdata['library_synopsis']);
		$frmdata['library_title'] = stripslashes($frmdata['library_title']);
		$frmdata['library_body_preview'] = $wiki->transform($frmdata['library_body'], 'Xhtml');
		$frmdata['library_page_name'] = $page;

		if (!empty($frmdata['rsp_degree'])) {
			$frmdata['rsp'][] = array('level_id' => $c_node['rsp']['rsp_level']['degree'], 'degree_id' => $frmdata['rsp_degree']);
		}
		
		if (!empty($frmdata['rsp_node'])) {
			$frmdata['rsp'][] = array('level_id' => $c_node['rsp']['rsp_level']['node']);
		}
		
		if (!empty($frmdata['rsp_public'])) {
			$frmdata['rsp'][] = array('level_id' => $c_node['rsp']['rsp_level']['public']);
		}
		
		if (!empty($frmdata['rsp_group'])) {
			$frmdata['rsp'][] = array('level_id' => $c_node['rsp']['rsp_level']['group']);
		}

		$output_library = $frmdata;

		$display = "allow_edit";
	}
	elseif (isset($_POST['edit_library_again'])) {
		$output_library = $frmdata;

		$display = "allow_edit";

	}
	elseif (isset($frmdata['save']) || isset($frmdata['save_go'])) {

		if (empty($frmdata['library_title'])) {
		    $GLOBALS['am_error_log'][] = array(11, null, null);
		}

		if (empty($frmdata['library_synopsis'])) {
		    $GLOBALS['am_error_log'][] = array(30, null, null);
		}

		if (empty($frmdata['language_id'])) {
		    $frmdata['language_id'] = $me['language_id'];
		}

		if (empty($GLOBALS['am_error_log'])) {
			//we insert record
	 		$library->user_id = $me['user_id'];
	 		$library->insertLibrary($frmdata);

			if (empty($GLOBALS['am_error_log'])) {
				//insert into setup rsp
				if (!empty($frmdata['group_id'])) {
				    $temp['language_id'] = $output_group['language_id'];
				}
				else {
					$temp['language_id'] = $me['language_id'];
				}

				$temp['item_id'] = $library->library_id;
				$temp['item_name'] = $library->library_page_name;
				//delete all
				$rsp->deleteRspItem(null, $library->library_page_name);

				//insert node rsp entry
				if (!empty($frmdata['rsp_degree'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['degree'];
					if ($frmdata['rsp_degree'] == "all") {
					    $temp['degree_id'] = "null";
					}
					else {
						$temp['degree_id'] = $frmdata['rsp_degree'];
					}
					$rsp->insertRspItem($temp);
				}

				if (!empty($frmdata['rsp_node'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['node'];
					$rsp->insertRspItem($temp);
				}

				if (isset($frmdata['rsp_group'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['group']['home'];

					$rsp->insertRspItem($temp);
				}
				
				if (!empty($frmdata['rsp_public'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['public'];
					$rsp->status_id = $c_node['rsp']['status']['pending'];
					$rsp->insertRspItem($temp);
				}
				
				//setup statistics
				require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
				$statistic = new Statistic($db, $c_node['rsp']['item_type']['library'], $date);
				
				//update stats
				if (!empty($frmdata['group_id'])) { // page under group section
					$statistic->section_item_id = $frmdata['group_id'];
					$statistic->statistic_type_id = $c_node['statistic']['group']['total_library_items'];
				}
				else {
					$statistic->user_id = $me['user_id'];
					$statistic->section_item_id = $me['user_id'];
					$statistic->statistic_type_id = $c_node['statistic']['user']['total_library_items'];
				}
				
				$statistic->setStatistic($library->getLibraryItemCount());
				
				//get member blog stats
				if (!empty($frmdata['group_id'])) { // page under group section
					$statistic->user_id = $me['user_id'];
					$statistic->statistic_type_id = $c_node['statistic']['group_member']['total_library_items'];
					$statistic->setStatistic($library->getLibraryItemCount($me['user_id']));
				}
				
			 }

			if (empty($GLOBALS['am_error_log'])) {

				if (isset($frmdata['save_go'])) {
					if (!empty($frmdata['group_id'])) { // page under group section
					    header("Location: lib_item.php?group_id=" . $frmdata['group_id'] . "&library_id=" . $library->library_id . "&".SID);
						exit;
					}
					else {
						header("Location: lib_item.php?library_id=" . $library->library_id . "&".SID);
						exit;
					}
				}
				else {
					if (!empty($frmdata['group_id'])) { // page under group section
						header("Location: lib_edit.php?group_id=" . $frmdata['group_id'] . "&library_id=" . $library->library_id . "&".SID);
						exit;
					}
					else {
						header("Location: lib_edit.php?library_id=" . $library->library_id . "&".SID);
						exit;
					}
				}
			}
		}
		else { // something errored
			$output_library = $frmdata;
		}

		$display = "allow_edit";


	}
}
elseif (isset($library->library_id) && $library->library_id > 0) {
	$output_library = $library->getPageID($library->library_id);

	$display = "allow_edit";
}
elseif (isset($page)) {//else we assign the new page name
	$output_library = $library->getPageName($page);

	if (empty($output_library)) { //is a new page
	    $output_library['library_page_name'] = $page;
	}

	$display = "allow_edit";
}


//handle new libraries - we've deleted all library items and now adding new one
if (isset($output_library['library_page_name']) && !isset($output_library['library_id']) && ($output_library['library_page_name'] == $lang['txt_wiki_default'])) {
	$output_library['library_default'] = 1;
}


//get the author
if (isset($output_library['user_id'])) {
	$user->user_id = $output_library['user_id'];
	$output_author = $user->getProfile();
	$output_author['profile_create_datetime'] = $date->formatDate($output_author['profile_create_datetime']);
}



//setup file ----------------------------------------------------------------
if (!empty($_REQUEST['group_id'])) { // page under group section
	$file->section_id = $c_node['arr_section']['group'];
	$file->section_item_id = $_REQUEST['group_id'];
}
$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
$file->type_ids[] = $c_node['file']['mime'][1]['suffix']; //jpg
$file->type_ids[] = $c_node['file']['mime'][2]['suffix']; //png
$file->type_ids[] = $c_node['file']['mime'][3]['suffix']; //gif

$output_images = $file->getFiles();


//language and language file manipulation --------------------------------------------
if (!empty($group_id)) { // page under group section
	$lang['hdr_group_library'] = str_replace('GROUPTITLE', $output_group['group_title'], $lang['hdr_group_library']);
}


//RSP items
if (isset($library->library_id)) {
	$output_library['rsp'] = $rsp->selRspItem($library->library_id);
}

//move vars to template ----------------------------------------------------
if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (!empty($output_user)) {
	$body->set('user', $output_user);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (!empty($output_library)) {
	$body->set('library', $output_library);
}

if (!empty($output_images)) {
	$body->set('images', $output_images);
	$body->set('image_thumbs', $c_node['file']['image']['thumb']);
}

if (!empty($output_author)) {
	$body->set('author', $output_author);
}

if (!empty($pages)) {
	$body->set('pages', $pages);
}

$body->set('rspconfig', $c_node['rsp']);

include "inc/footer.inc.php";

?>
