<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------
// Tom Calthrop - 20th November 2004 (tom@barnraiser.org)




// ROLES ------------------------------------------------------------
/*
* a job function or assigned role or a level of membership
* user roles are fixed
* group roles are used as defaults when setting up a group
* once set up group roles are stored in the database
* refer to the acs_config file to see how roles are attached to sections
*/
$lang['arr_acs']['role'][101] = 					"administrator";		//user
$lang['arr_acs']['role'][102] = 					"member";			//user

$lang['arr_acs']['role'][201] = 					"administrator";		//group
$lang['arr_acs']['role'][202] = 					"moderator";			//group
$lang['arr_acs']['role'][203] = 					"chair";			//group
$lang['arr_acs']['role'][204] = 					"council";			//group
$lang['arr_acs']['role'][205] = 					"member";			//group


// SECTIONS ------------------------------------------------------------
$lang['arr_acs']['section'][1] = 					"user";
$lang['arr_acs']['section'][2] = 					"group";



// RESOURCES ------------------------------------------------------------
$lang['arr_acs']['resource'][101] = 				"administration"; 	//user
$lang['arr_acs']['resource'][102] = 				"membership";		//user
$lang['arr_acs']['resource'][103] = 				"social network";	//user
$lang['arr_acs']['resource'][104] = 				"ACS";				//user
$lang['arr_acs']['resource'][105] = 				"shoutbox";			//user
$lang['arr_acs']['resource'][106] = 				"RSP";				//user
$lang['arr_acs']['resource'][107] = 				"group";			//user
$lang['arr_acs']['resource'][108] = 				"poll";				//user
$lang['arr_acs']['resource'][109] = 				"forum";			//user
$lang['arr_acs']['resource'][110] = 				"newsletter";		//user

$lang['arr_acs']['resource'][201] = 				"administration";	//group
$lang['arr_acs']['resource'][202] = 				"ACS";				//group
$lang['arr_acs']['resource'][203] = 				"membership";		//group
$lang['arr_acs']['resource'][204] = 				"wiki";				//group
$lang['arr_acs']['resource'][205] = 				"forum";			//group
$lang['arr_acs']['resource'][206] = 				"files";			//group
$lang['arr_acs']['resource'][207] = 				"activities";		//group
$lang['arr_acs']['resource'][208] = 				"RSP";				//group
$lang['arr_acs']['resource'][209] = 				"polls";			//group
$lang['arr_acs']['resource'][210] = 				"blog";				//group
$lang['arr_acs']['resource'][211] = 				"newsletter";		//group
$lang['arr_acs']['resource'][212] = 				"channels";			//group


//resource descriptions
$lang['arr_acs']['resource_desc'][101] = 			"node administration permissions";
$lang['arr_acs']['resource_desc'][102] = 			"membership permissions";
$lang['arr_acs']['resource_desc'][103] = 			"social networking permissions";
$lang['arr_acs']['resource_desc'][104] = 			"Access control system permissions";
$lang['arr_acs']['resource_desc'][105] = 			"Shoutbox permissions";
$lang['arr_acs']['resource_desc'][106] = 			"Content management system (Splash magazine)";
$lang['arr_acs']['resource_desc'][107] = 			"Group permissions";
$lang['arr_acs']['resource_desc'][108] = 			"Community wide poll permissions";
$lang['arr_acs']['resource_desc'][109] = 			"Community wide forum permissions";
$lang['arr_acs']['resource_desc'][110] = 			"Community wide newsletter permissions";

$lang['arr_acs']['resource_desc'][201] = 			"group administration permissions (rules and structure)";
$lang['arr_acs']['resource_desc'][202] = 			"Access control system permissions";
$lang['arr_acs']['resource_desc'][203] = 			"membership permissions";
$lang['arr_acs']['resource_desc'][204] = 			"wiki permissions";
$lang['arr_acs']['resource_desc'][205] = 			"forum permissions";
$lang['arr_acs']['resource_desc'][206] = 			"group files (images) permissions";
$lang['arr_acs']['resource_desc'][207] = 			"activity permissions";
$lang['arr_acs']['resource_desc'][208] = 			"content management system permissions (the level of publishing).";
$lang['arr_acs']['resource_desc'][209] = 			"poll permissions";
$lang['arr_acs']['resource_desc'][210] = 			"blog permissions";
$lang['arr_acs']['resource_desc'][211] = 			"newsletter permissions";
$lang['arr_acs']['resource_desc'][212] = 			"channel permissions";

// PRIVILEGES ------------------------------------------------------------
$lang['arr_acs']['privilege'][1] = 				"allow access";
$lang['arr_acs']['privilege'][2] = 				"add item";
$lang['arr_acs']['privilege'][3] = 				"allow edit";
$lang['arr_acs']['privilege'][4] = 				"allow invite";
$lang['arr_acs']['privilege'][5] = 				"allow public";
$lang['arr_acs']['privilege'][6] = 				"view hidden";
$lang['arr_acs']['privilege'][7] = 				"allow group home";
$lang['arr_acs']['privilege'][8] = 				"group edit";
$lang['arr_acs']['privilege'][9] = 				"user edit";
$lang['arr_acs']['privilege'][10] = 			"allow comment";
$lang['arr_acs']['privilege'][11] = 			"allow node";
$lang['arr_acs']['privilege'][12] = 			"allow create";
$lang['arr_acs']['privilege'][13] = 			"allow add";
$lang['arr_acs']['privilege'][14] = 			"allow send";
$lang['arr_acs']['privilege'][15] = 			"allow locking";

?>
