<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_pre_login.inc.php";
include "config/config_acs.inc.php";


if (isset($_REQUEST['blog_id'])) {
    $blog_id = $_REQUEST['blog_id'];
}

if (isset($_REQUEST['subject_id'])) {
    $subject_id = $_REQUEST['subject_id'];
}

if (isset($_REQUEST['poll_id'])) {
    $poll_id = $_REQUEST['poll_id'];
}

if (isset($_REQUEST['library_id'])) {
    $library_id = $_REQUEST['library_id'];
}

if (isset($_REQUEST['page'])) {
    $wiki_page_name = $_REQUEST['page'];
}

//setup comment
require_once($c_node['dir']['class_path'] . 'Comment.class.php');
$comment = new Comment($db, null, $date);
if (isset($group_id)) {
    $comment->group_id = $group_id;
}


//setup file
require_once($c_node['dir']['class_path'] . 'File.class.php');
$file = new File($db, null, $c_node['file'], $c_node['dir']);
$file->noimage = $c_node['file']['image']['thumb'][2]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][2]['name'];
$file->config_ids = $c_node['file'];

		
//setup Wiki
require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');
$wiki =& new Text_Wiki();
$wiki->disableRule('Freelink');
$wiki->disableRule('wikilink');


// SETUP USER ------------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'User.class.php');
$user = new User($db, $date);


if (isset($blog_id)) {
	require_once($c_node['dir']['class_path'] . 'Blog.class.php');
	$blog = new Blog($db, $c_node['rsp']['item_type']['blog'], $date, $file);
	$blog->blog_id = $blog_id;
	$output_blog = $blog->getBlog();

	if (!empty($output_blog['group_id'])) { // page under group section
	    $wiki->setRenderConf('xhtml', 'image', 'base', 'get_file.php?file=group/');
	}
	else {
	    $wiki->setRenderConf('xhtml', 'image', 'base', 'get_file.php?file=user/');
	}

	$output_blog['blog_body_display'] = $wiki->transform($output_blog['blog_body'], 'Xhtml');

	$comment->item_id = $blog_id;
	$comment->user_id = $output_blog['user_id'];
	$output_comments = $comment->selComments($blog_id);

	if (isset($output_blog['user_id'])) {
		$user->user_id = $output_blog['user_id'];
    	$output_author = $user->getProfile();
	}
}

if (isset($subject_id)) {
	require_once($c_node['dir']['class_path'] . 'Forum.class.php');
	$forum = new Forum($db, $c_node['rsp']['item_type']['forum'], $date, $file);
	$forum->subject_id = $subject_id;
	$output_subject = $forum->getSubject();

	if (!empty($output_subject['subject_id'])) { // page under group section
	    $wiki->setRenderConf('xhtml', 'image', 'base', 'get_file.php?file=group/');
	}
	else {
	    $wiki->setRenderConf('xhtml', 'image', 'base', 'get_file.php?file=user/');
	}
	
	$output_subject['display_subject_body'] = $wiki->transform($output_subject['subject_body'], 'Xhtml');
	
	$comment->item_id = $subject_id;
	$comment->user_id = $output_subject['user_id'];
	$output_comments = $comment->selComments($subject_id);

	if (isset($output_subject['user_id'])) {
		$user->user_id = $output_subject['user_id'];
    	$output_author = $user->getProfile();
	}
}


if (isset($poll_id)) {
	require_once($c_node['dir']['class_path'] . 'Poll.class.php');
	$poll = new Poll($db, $c_node['rsp']['item_type']['poll'], $date);
	$poll->poll_id = $poll_id;
	$output_poll = $poll->getPoll();
	
	$comment->item_id = $poll_id;
	$output_comments = $comment->selComments($poll_id);

	//get users vote for each comment
	if (isset($output_comments)) {
		foreach($output_comments as $key => $i):
			$output_comments[$key]['vote'] = $poll->pollUserVoteHistory($i['user_id']);
		endforeach;
	}

	if (isset($output_poll['user_id'])) {
		$user->user_id = $output_poll['user_id'];
    	$output_author = $user->getProfile();
	}
}


if (isset($library_id) || isset($wiki_page_name)) {
	require_once($c_node['dir']['class_path'] . 'Library.class.php');
	$library = new Library($db, $c_node['rsp']['item_type']['library'], $date, $file);
	
	if (isset($library_id)) {
		$library->library_id = $library_id;
		$output_library_item = $library->getPageID();
	}
	else {
		$output_library_item = $library->getPageName($wiki_page_name);
		$library_id = $output_library_item['library_id'];
	}
	
	//wikify body
	if (!empty($output_library_item['group_id'])) { // page under group section
	    $wiki_path = "lib_item.php?group_id=" . $output_library_item['group_id'] . "&page=";
		$wiki_image_base = "get_file.php?file=group/";

	}
	else {
	    $wiki_path = "lib_item.php?user_id=" . $output_library_item['user_id'] . "&page=";
		$wiki_image_base = "get_file.php?file=user/";
	}
	
	$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', $wiki_path);
	$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', '#'); // turn off the ability to link pages
	$wiki->setRenderConf('xhtml', 'wikilink', 'new_text', ' '); // remove '?' in new links
	$wiki->setRenderConf('xhtml', 'image', 'base', $wiki_image_base);
	
	
	// set an array of pages that exist in the library
	$pages = $library->getPages();
	$wiki->setRenderConf('xhtml', 'wikilink', 'pages', $pages);
	
	$output_library_item['library_body'] = $wiki->transform($output_library_item['library_body'], 'Xhtml');
	$output_library_item['display_library_create_datetime'] = $date->formatDate($output_library_item['library_create_datetime'], 1);

	
	//get comments
	unset($comment->user_id);
	// if Item comments is requested (&ico=1) we select only select comment for
	// this library_id, else we get the history and get comments for all 
	// versions of this wiki page
	if (empty($_REQUEST['ico'])) {
		if (!empty($output_library_item['group_id'])) {
			$library->group_id = $output_library_item['group_id'];
		}
		$output_library_history = $library->getHistory($library_id);
		
		if (!empty($output_library_history)) {
			$comment->item_ids = array();
			foreach($output_library_history as $key => $i):
				array_push($comment->item_ids, $i['library_id']);
			endforeach;
		}
		
		$output_comments = $comment->selComments();
	}
	else {
		$output_comments = $comment->selComments($library_id);
	}

	if (isset($output_library_item['user_id'])) {
		$user->user_id = $output_library_item['user_id'];
    	$output_author = $user->getProfile();
	}
}




//move to template
if (!empty($output_blog)) {
	$body->set('blog', $output_blog);
}

if (!empty($output_poll)) {
	$body->set('poll', $output_poll);
}

if (!empty($output_subject)) {
	$body->set('subject', $output_subject);
}

if (!empty($output_library_item)) {
	$body->set('library', $output_library_item);
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_comment)) {
	$body->set('comment', $output_comment);
}

if (!empty($output_author)) {
	$body->set('author', $output_author);
}

if (!empty($allow_add_comment)) {
	$body->set('allow_add_comment', $allow_add_comment);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (isset($output_poll_history)) {
	$body->set('poll_history', $output_poll_history);
}

include "inc/footer_pre_login.inc.php";
?>
